/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.ContainerTabOrder;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.Heuristic2D;
import com.sun.javafx.scene.traversal.TraversalContext;
import com.sun.javafx.scene.traversal.TraverseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;

public abstract class TraversalEngine {
    static final Algorithm DEFAULT_ALGORITHM = PlatformImpl.isContextual2DNavigation() ? new Heuristic2D() : new ContainerTabOrder();
    private final TraversalContext context = new EngineContext(this);
    private final TempEngineContext tempEngineContext = new TempEngineContext(this);
    protected final Algorithm algorithm;
    private final Bounds initialBounds = new BoundingBox(0.0, 0.0, 1.0, 1.0);
    private final ArrayList<TraverseListener> listeners = new ArrayList();

    protected TraversalEngine(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    protected TraversalEngine() {
        this.algorithm = null;
    }

    public final void addTraverseListener(TraverseListener traverseListener) {
        this.listeners.add(traverseListener);
    }

    final void notifyTraversedTo(Node node) {
        for (TraverseListener traverseListener : this.listeners) {
            traverseListener.onTraverse(node, this.getLayoutBounds(node, this.getRoot()));
        }
    }

    public final Node select(Node node, Direction direction) {
        return this.algorithm.select(node, direction, this.context);
    }

    public final Node selectFirst() {
        return this.algorithm.selectFirst(this.context);
    }

    public final Node selectLast() {
        return this.algorithm.selectLast(this.context);
    }

    protected abstract Parent getRoot();

    public final boolean canTraverse() {
        return this.algorithm != null;
    }

    private Bounds getLayoutBounds(Node node, Parent parent) {
        Bounds bounds = node != null ? (parent == null ? node.localToScene(node.getLayoutBounds()) : parent.sceneToLocal(node.localToScene(node.getLayoutBounds()))) : this.initialBounds;
        return bounds;
    }

    private final class EngineContext
    extends BaseEngineContext {
        final /* synthetic */ TraversalEngine this$0;

        private EngineContext(TraversalEngine traversalEngine) {
            TraversalEngine traversalEngine2 = traversalEngine;
            Objects.requireNonNull(traversalEngine2);
            this.this$0 = traversalEngine2;
            super(traversalEngine);
        }

        @Override
        public Parent getRoot() {
            return this.this$0.getRoot();
        }
    }

    private final class TempEngineContext
    extends BaseEngineContext {
        private Parent root;

        private TempEngineContext(TraversalEngine traversalEngine) {
            Objects.requireNonNull(traversalEngine);
            super(traversalEngine);
        }

        @Override
        public Parent getRoot() {
            return this.root;
        }

        public void setRoot(Parent parent) {
            this.root = parent;
        }
    }

    private abstract class BaseEngineContext
    implements TraversalContext {
        final /* synthetic */ TraversalEngine this$0;

        private BaseEngineContext(TraversalEngine traversalEngine) {
            TraversalEngine traversalEngine2 = traversalEngine;
            Objects.requireNonNull(traversalEngine2);
            this.this$0 = traversalEngine2;
        }

        @Override
        public List<Node> getAllTargetNodes() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            this.addFocusableChildrenToList(arrayList, this.getRoot());
            return arrayList;
        }

        @Override
        public Bounds getSceneLayoutBounds(Node node) {
            return this.this$0.getLayoutBounds(node, null);
        }

        private void addFocusableChildrenToList(List<Node> list, Parent parent) {
            ObservableList<Node> observableList = parent.getChildrenUnmodifiable();
            for (Node node : observableList) {
                if (node.isFocusTraversable() && !node.isFocused() && NodeHelper.isTreeVisible(node) && !node.isDisabled()) {
                    list.add(node);
                }
                if (!(node instanceof Parent)) continue;
                this.addFocusableChildrenToList(list, (Parent)node);
            }
        }

        @Override
        public Node selectFirstInParent(Parent parent) {
            this.this$0.tempEngineContext.setRoot(parent);
            return DEFAULT_ALGORITHM.selectFirst(this.this$0.tempEngineContext);
        }

        @Override
        public Node selectLastInParent(Parent parent) {
            this.this$0.tempEngineContext.setRoot(parent);
            return DEFAULT_ALGORITHM.selectLast(this.this$0.tempEngineContext);
        }

        @Override
        public Node selectInSubtree(Parent parent, Node node, Direction direction) {
            this.this$0.tempEngineContext.setRoot(parent);
            return DEFAULT_ALGORITHM.select(node, direction, this.this$0.tempEngineContext);
        }
    }
}

