/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.javafx.animation.TickCalculation;
import com.sun.javafx.util.Logging;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.Settings;
import com.sun.scenario.animation.AnimationPulse;
import com.sun.scenario.animation.shared.PulseReceiver;
import com.sun.scenario.animation.shared.TimerReceiver;
import java.util.Arrays;
import java.util.Objects;
import javafx.animation.AnimationTimer;
import javafx.util.Callback;

public abstract class AbstractPrimaryTimer {
    protected static final String FULLSPEED_PROP = "javafx.animation.fullspeed";
    private static boolean fullspeed = Settings.getBoolean("javafx.animation.fullspeed");
    protected static final String ADAPTIVE_PULSE_PROP = "com.sun.scenario.animation.adaptivepulse";
    private static boolean useAdaptivePulse = Settings.getBoolean("com.sun.scenario.animation.adaptivepulse");
    protected static final String PULSE_PROP = "javafx.animation.pulse";
    protected static final String FRAMERATE_PROP = "javafx.animation.framerate";
    protected static final String FIXED_PULSE_LENGTH_PROP = "com.sun.scenario.animation.fixed.pulse.length";
    protected static final String ANIMATION_MBEAN_ENABLED = "com.sun.scenario.animation.AnimationMBean.enabled";
    protected static final boolean enableAnimationMBean = false;
    private final int PULSE_DURATION_NS = this.getPulseDuration(1000000000);
    private final int PULSE_DURATION_TICKS = this.getPulseDuration((int)TickCalculation.fromMillis(1000.0));
    public static final int FAILING_TIMER_THRESHOLD = 100;
    private static Callback<String, Void> pcl = string -> {
        switch (string) {
            case "javafx.animation.fullspeed": {
                fullspeed = Settings.getBoolean(FULLSPEED_PROP);
                break;
            }
            case "com.sun.scenario.animation.adaptivepulse": {
                useAdaptivePulse = Settings.getBoolean(ADAPTIVE_PULSE_PROP);
                break;
            }
            case "com.sun.scenario.animation.AnimationMBean.enabled": {
                AnimationPulse.getDefaultBean().setEnabled(Settings.getBoolean(ANIMATION_MBEAN_ENABLED));
            }
        }
        return null;
    };
    private ReceiverRecord<PulseReceiver>[] receivers = new ReceiverRecord[2];
    private int receiversLength;
    private boolean receiversLocked;
    private ReceiverRecord<TimerReceiver>[] animationTimers = new ReceiverRecord[2];
    private int animationTimersLength;
    private boolean animationTimersLocked;
    private final long fixedPulseLength = Boolean.getBoolean("com.sun.scenario.animation.fixed.pulse.length") ? (long)this.PULSE_DURATION_NS : 0L;
    private long debugNanos = 0L;
    private final MainLoop theMainLoop = new MainLoop(this);

    public int getDefaultResolution() {
        return this.PULSE_DURATION_TICKS;
    }

    public long nanos() {
        if (this.fixedPulseLength > 0L) {
            return this.debugNanos;
        }
        return System.nanoTime();
    }

    public boolean isFullspeed() {
        return fullspeed;
    }

    protected AbstractPrimaryTimer() {
    }

    public void addPulseReceiver(PulseReceiver pulseReceiver) {
        boolean bl;
        boolean bl2 = bl = this.receiversLength == this.receivers.length;
        if (this.receiversLocked || bl) {
            this.receivers = Arrays.copyOf(this.receivers, bl ? this.receivers.length * 3 / 2 + 1 : this.receivers.length);
            this.receiversLocked = false;
        }
        this.receivers[this.receiversLength++] = ReceiverRecord.ofPulseReceiver(pulseReceiver);
        if (this.receiversLength == 1) {
            this.theMainLoop.updateAnimationRunnable();
        }
    }

    public void removePulseReceiver(PulseReceiver pulseReceiver) {
        if (this.receiversLocked) {
            this.receivers = (ReceiverRecord[])this.receivers.clone();
            this.receiversLocked = false;
        }
        for (int i = 0; i < this.receiversLength; ++i) {
            if (pulseReceiver != this.receivers[i].receiver()) continue;
            if (i == this.receiversLength - 1) {
                this.receivers[i] = null;
            } else {
                System.arraycopy(this.receivers, i + 1, this.receivers, i, this.receiversLength - i - 1);
                this.receivers[this.receiversLength - 1] = null;
            }
            --this.receiversLength;
            break;
        }
        if (this.receiversLength == 0) {
            this.theMainLoop.updateAnimationRunnable();
        }
    }

    public void addAnimationTimer(TimerReceiver timerReceiver) {
        boolean bl;
        boolean bl2 = bl = this.animationTimersLength == this.animationTimers.length;
        if (this.animationTimersLocked || bl) {
            this.animationTimers = Arrays.copyOf(this.animationTimers, bl ? this.animationTimers.length * 3 / 2 + 1 : this.animationTimers.length);
            this.animationTimersLocked = false;
        }
        this.animationTimers[this.animationTimersLength++] = ReceiverRecord.ofAnimationTimer(timerReceiver);
        if (this.animationTimersLength == 1) {
            this.theMainLoop.updateAnimationRunnable();
        }
    }

    public void removeAnimationTimer(TimerReceiver timerReceiver) {
        if (this.animationTimersLocked) {
            this.animationTimers = (ReceiverRecord[])this.animationTimers.clone();
            this.animationTimersLocked = false;
        }
        for (int i = 0; i < this.animationTimersLength; ++i) {
            if (timerReceiver != this.animationTimers[i].receiver()) continue;
            if (i == this.animationTimersLength - 1) {
                this.animationTimers[i] = null;
            } else {
                System.arraycopy(this.animationTimers, i + 1, this.animationTimers, i, this.animationTimersLength - i - 1);
                this.animationTimers[this.animationTimersLength - 1] = null;
            }
            --this.animationTimersLength;
            break;
        }
        if (this.animationTimersLength == 0) {
            this.theMainLoop.updateAnimationRunnable();
        }
    }

    protected void recordStart(long l) {
    }

    protected void recordEnd() {
    }

    protected void recordAnimationEnd() {
    }

    protected abstract void postUpdateAnimationRunnable(DelayedRunnable var1);

    protected abstract int getPulseDuration(int var1);

    protected void timePulseImpl(long l) {
        if (this.fixedPulseLength > 0L) {
            this.debugNanos += this.fixedPulseLength;
            l = this.debugNanos;
        }
        ReceiverRecord<PulseReceiver>[] receiverRecordArray = this.receivers;
        int n = this.receiversLength;
        this.receiversLocked = true;
        for (int i = 0; i < n; ++i) {
            try {
                receiverRecordArray[i].receiver().timePulse(TickCalculation.fromNano(l));
                continue;
            }
            catch (Throwable throwable) {
                receiverRecordArray[i].handleException(throwable);
            }
        }
        this.receiversLocked = false;
        this.recordAnimationEnd();
        ReceiverRecord<TimerReceiver>[] receiverRecordArray2 = this.animationTimers;
        int n2 = this.animationTimersLength;
        this.animationTimersLocked = true;
        for (int i = 0; i < n2; ++i) {
            try {
                receiverRecordArray2[i].receiver().handle(l);
                continue;
            }
            catch (Throwable throwable) {
                receiverRecordArray2[i].handleException(throwable);
            }
        }
        this.animationTimersLocked = false;
    }

    static {
        Settings.addPropertyChangeListener(pcl);
        int n = Settings.getInt(PULSE_PROP, -1);
        if (n != -1) {
            System.err.println("Setting PULSE_DURATION to " + n + " hz");
        }
    }

    private static abstract class ReceiverRecord<T> {
        int exceptionsThrown;

        private ReceiverRecord() {
        }

        static ReceiverRecord<TimerReceiver> ofAnimationTimer(final TimerReceiver timerReceiver) {
            return new ReceiverRecord<TimerReceiver>(){

                @Override
                TimerReceiver receiver() {
                    return timerReceiver;
                }

                @Override
                Class<?> type() {
                    return AnimationTimer.class;
                }
            };
        }

        static ReceiverRecord<PulseReceiver> ofPulseReceiver(final PulseReceiver pulseReceiver) {
            return new ReceiverRecord<PulseReceiver>(){

                @Override
                PulseReceiver receiver() {
                    return pulseReceiver;
                }

                @Override
                Class<?> type() {
                    return PulseReceiver.class;
                }
            };
        }

        abstract T receiver();

        abstract Class<?> type();

        void handleException(Throwable throwable) {
            if (this.exceptionsThrown < 100) {
                ++this.exceptionsThrown;
                try {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, throwable);
                }
                catch (Throwable throwable2) {}
            } else if (this.exceptionsThrown == 100) {
                ++this.exceptionsThrown;
                if (Logging.getJavaFXLogger().isLoggable(System.Logger.Level.WARNING)) {
                    Logging.getJavaFXLogger().warning("Too many exceptions thrown by " + this.type().getSimpleName() + ", ignoring further exceptions.");
                }
            }
        }
    }

    private final class MainLoop
    implements DelayedRunnable {
        private boolean inactive;
        private long nextPulseTime;
        private long lastPulseDuration;
        final /* synthetic */ AbstractPrimaryTimer this$0;

        private MainLoop(AbstractPrimaryTimer abstractPrimaryTimer) {
            AbstractPrimaryTimer abstractPrimaryTimer2 = abstractPrimaryTimer;
            Objects.requireNonNull(abstractPrimaryTimer2);
            this.this$0 = abstractPrimaryTimer2;
            this.inactive = true;
            this.nextPulseTime = this.this$0.nanos();
            this.lastPulseDuration = Integer.MIN_VALUE;
        }

        @Override
        public void run() {
            long l = this.this$0.nanos();
            this.this$0.recordStart((this.nextPulseTime - l) / 1000000L);
            this.this$0.timePulseImpl(l);
            this.this$0.recordEnd();
            this.updateNextPulseTime(l);
            this.updateAnimationRunnable();
        }

        @Override
        public long getDelay() {
            long l = this.this$0.nanos();
            long l2 = (this.nextPulseTime - l) / 1000000L;
            return Math.max(0L, l2);
        }

        private void updateNextPulseTime(long l) {
            long l2 = this.this$0.nanos();
            if (fullspeed) {
                this.nextPulseTime = l2;
            } else if (useAdaptivePulse) {
                this.nextPulseTime += (long)this.this$0.PULSE_DURATION_NS;
                long l3 = l2 - l;
                if (l3 - this.lastPulseDuration > 500000L) {
                    l3 /= 2L;
                }
                if (l3 < 2000000L) {
                    l3 = 2000000L;
                }
                if (l3 >= (long)this.this$0.PULSE_DURATION_NS) {
                    l3 = 3 * this.this$0.PULSE_DURATION_NS / 4;
                }
                this.lastPulseDuration = l3;
                this.nextPulseTime -= l3;
            } else {
                this.nextPulseTime = (this.nextPulseTime + (long)this.this$0.PULSE_DURATION_NS) / (long)this.this$0.PULSE_DURATION_NS * (long)this.this$0.PULSE_DURATION_NS;
            }
        }

        private void updateAnimationRunnable() {
            boolean bl;
            boolean bl2 = bl = this.this$0.animationTimersLength == 0 && this.this$0.receiversLength == 0;
            if (this.inactive != bl) {
                this.inactive = bl;
                MainLoop mainLoop = this.inactive ? null : this;
                this.this$0.postUpdateAnimationRunnable(mainLoop);
            }
        }
    }
}

