/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.PreviewFeature;
import com.sun.javafx.geom.Vec2d;
import com.sun.javafx.scene.layout.HeaderButtonBehavior;
import com.sun.javafx.stage.HeaderButtonMetrics;
import com.sun.javafx.stage.StageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.StyleOrigin;
import javafx.css.StyleableDoubleProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.HeaderButtonType;
import javafx.scene.layout.HeaderDragType;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Subscription;

@Deprecated(since="25")
public class HeaderBar
extends Region {
    private static final Dimension2D EMPTY = new Dimension2D(0.0, 0.0);
    private static final String ALIGNMENT = "headerbar-alignment";
    private static final String MARGIN = "headerbar-margin";
    public static final double USE_DEFAULT_SIZE = -1.0;
    private Subscription subscriptions = Subscription.EMPTY;
    private final ObjectProperty<Node> left = new NodeProperty(this, "left");
    private final ObjectProperty<Node> center = new NodeProperty(this, "center");
    private final ObjectProperty<Node> right = new NodeProperty(this, "right");
    private final BooleanProperty leftSystemPadding = new BooleanPropertyBase(this, true){
        final /* synthetic */ HeaderBar this$0;
        {
            HeaderBar headerBar2 = headerBar;
            Objects.requireNonNull(headerBar2);
            this.this$0 = headerBar2;
            super(bl);
        }

        public Object getBean() {
            return this.this$0;
        }

        public String getName() {
            return "leftSystemPadding";
        }

        protected void invalidated() {
            this.this$0.requestLayout();
        }
    };
    private final BooleanProperty rightSystemPadding = new BooleanPropertyBase(this, true){
        final /* synthetic */ HeaderBar this$0;
        {
            HeaderBar headerBar2 = headerBar;
            Objects.requireNonNull(headerBar2);
            this.this$0 = headerBar2;
            super(bl);
        }

        public Object getBean() {
            return this.this$0;
        }

        public String getName() {
            return "rightSystemPadding";
        }

        protected void invalidated() {
            this.this$0.requestLayout();
        }
    };

    public static void setDragType(Node node, HeaderDragType headerDragType) {
        if (HeaderBar.getDragType(node) != headerDragType) {
            HeaderBar.dragTypeProperty(node).set((Object)headerDragType);
        }
    }

    public static HeaderDragType getDragType(Node node) {
        HeaderDragType headerDragType;
        if (!node.hasProperties()) {
            return null;
        }
        Object object = node.getProperties().get(HeaderDragType.class);
        if (object instanceof ObjectProperty) {
            ObjectProperty objectProperty = (ObjectProperty)object;
            headerDragType = (HeaderDragType)((Object)objectProperty.get());
        } else {
            headerDragType = null;
        }
        return headerDragType;
    }

    public static ObjectProperty<HeaderDragType> dragTypeProperty(Node node) {
        Object object = node.getProperties().get(HeaderDragType.class);
        if (object instanceof ObjectProperty) {
            ObjectProperty objectProperty = (ObjectProperty)object;
            return objectProperty;
        }
        SimpleObjectProperty simpleObjectProperty = new SimpleObjectProperty((Object)node, "dragType");
        node.getProperties().put(HeaderDragType.class, (Object)simpleObjectProperty);
        return simpleObjectProperty;
    }

    public static void setButtonType(Node node, HeaderButtonType headerButtonType) {
        if (HeaderBar.getButtonType(node) != headerButtonType) {
            HeaderBar.buttonTypeProperty(node).set((Object)headerButtonType);
        }
    }

    public static HeaderButtonType getButtonType(Node node) {
        HeaderButtonType headerButtonType;
        if (!node.hasProperties()) {
            return null;
        }
        Object object = node.getProperties().get(HeaderButtonType.class);
        if (object instanceof ObjectProperty) {
            ObjectProperty objectProperty = (ObjectProperty)object;
            headerButtonType = (HeaderButtonType)((Object)objectProperty.get());
        } else {
            headerButtonType = null;
        }
        return headerButtonType;
    }

    public static ObjectProperty<HeaderButtonType> buttonTypeProperty(Node node) {
        Object object = node.getProperties().get(HeaderButtonType.class);
        if (object instanceof ObjectProperty) {
            ObjectProperty objectProperty = (ObjectProperty)object;
            return objectProperty;
        }
        SimpleObjectProperty<HeaderButtonType> simpleObjectProperty = new SimpleObjectProperty<HeaderButtonType>((Object)node, "buttonType"){
            HeaderButtonBehavior behavior;

            protected void invalidated() {
                HeaderButtonType headerButtonType = (HeaderButtonType)((Object)this.get());
                if (this.behavior != null) {
                    this.behavior.dispose();
                }
                if (headerButtonType != null) {
                    this.behavior = new HeaderButtonBehavior((Node)this.getBean(), headerButtonType);
                }
            }
        };
        node.getProperties().put(HeaderButtonType.class, (Object)simpleObjectProperty);
        return simpleObjectProperty;
    }

    public static void setPrefButtonHeight(Stage stage, double d) {
        AttachedProperties.of((Stage)stage).prefButtonHeight.set(d);
    }

    public static double getPrefButtonHeight(Stage stage) {
        return AttachedProperties.of((Stage)stage).prefButtonHeight.get();
    }

    public static DoubleProperty prefButtonHeightProperty(Stage stage) {
        return AttachedProperties.of((Stage)stage).prefButtonHeight;
    }

    public static ReadOnlyObjectProperty<Dimension2D> leftSystemInsetProperty(Stage stage) {
        return AttachedProperties.of((Stage)stage).leftSystemInset.getReadOnlyProperty();
    }

    public static Dimension2D getLeftSystemInset(Stage stage) {
        return (Dimension2D)AttachedProperties.of((Stage)stage).leftSystemInset.get();
    }

    public static ReadOnlyObjectProperty<Dimension2D> rightSystemInsetProperty(Stage stage) {
        return AttachedProperties.of((Stage)stage).rightSystemInset.getReadOnlyProperty();
    }

    public static Dimension2D getRightSystemInset(Stage stage) {
        return (Dimension2D)AttachedProperties.of((Stage)stage).rightSystemInset.get();
    }

    public static ReadOnlyDoubleProperty minSystemHeightProperty(Stage stage) {
        return AttachedProperties.of((Stage)stage).minSystemHeight.getReadOnlyProperty();
    }

    public static double getMinSystemHeight(Stage stage) {
        return AttachedProperties.of((Stage)stage).minSystemHeight.get();
    }

    public static void setAlignment(Node node, Pos pos) {
        Pane.setConstraint(node, ALIGNMENT, (Object)pos);
    }

    public static Pos getAlignment(Node node) {
        return (Pos)((Object)Pane.getConstraint(node, ALIGNMENT));
    }

    public static void setMargin(Node node, Insets insets) {
        Pane.setConstraint(node, MARGIN, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)Pane.getConstraint(node, MARGIN);
    }

    public HeaderBar() {
        PreviewFeature.HEADER_BAR.checkEnabled();
        this.minHeightProperty();
        this.sceneProperty().flatMap(Scene::windowProperty).map(window -> {
            Stage stage;
            return window instanceof Stage ? (stage = (Stage)window) : null;
        }).subscribe(this::onStageChanged);
    }

    public HeaderBar(Node node, Node node2, Node node3) {
        this();
        this.setLeft(node);
        this.setCenter(node2);
        this.setRight(node3);
    }

    public final ObjectProperty<Node> leftProperty() {
        return this.left;
    }

    public final Node getLeft() {
        return (Node)this.left.get();
    }

    public final void setLeft(Node node) {
        this.left.set((Object)node);
    }

    public final ObjectProperty<Node> centerProperty() {
        return this.center;
    }

    public final Node getCenter() {
        return (Node)this.center.get();
    }

    public final void setCenter(Node node) {
        this.center.set((Object)node);
    }

    public final ObjectProperty<Node> rightProperty() {
        return this.right;
    }

    public final Node getRight() {
        return (Node)this.right.get();
    }

    public final void setRight(Node node) {
        this.right.set((Object)node);
    }

    public final BooleanProperty leftSystemPaddingProperty() {
        return this.leftSystemPadding;
    }

    public final boolean isLeftSystemPadding() {
        return this.leftSystemPadding.get();
    }

    public final void setLeftSystemPadding(boolean bl) {
        this.leftSystemPadding.set(bl);
    }

    public final BooleanProperty rightSystemPaddingProperty() {
        return this.rightSystemPadding;
    }

    public final boolean isRightSystemPadding() {
        return this.rightSystemPadding.get();
    }

    public final void setRightSystemPadding(boolean bl) {
        this.rightSystemPadding.set(bl);
    }

    @Override
    protected double computeMinWidth(double d) {
        Object object;
        Object object2;
        Window window;
        double d2;
        double d3;
        double d4;
        Node node = this.getLeft();
        Node node2 = this.getCenter();
        Node node3 = this.getRight();
        Insets insets = this.getInsets();
        double d5 = 0.0;
        double d6 = 0.0;
        if (d != -1.0 && (this.childHasContentBias(node, Orientation.VERTICAL) || this.childHasContentBias(node3, Orientation.VERTICAL) || this.childHasContentBias(node2, Orientation.VERTICAL))) {
            double d7 = Math.max(0.0, d);
            d4 = this.getAreaWidth(node, d7, false);
            d3 = this.getAreaWidth(node3, d7, false);
            d2 = this.getAreaWidth(node2, d7, true);
        } else {
            d4 = this.getAreaWidth(node, -1.0, false);
            d3 = this.getAreaWidth(node3, -1.0, false);
            d2 = this.getAreaWidth(node2, -1.0, true);
        }
        Scene scene = this.getScene();
        Object object3 = scene != null ? ((window = scene.getWindow()) instanceof Stage ? (object2 = (Stage)window) : null) : (object = null);
        if (object != null) {
            object2 = AttachedProperties.of(object);
            if (scene.getEffectiveNodeOrientation() != this.getEffectiveNodeOrientation()) {
                d5 = this.isLeftSystemPadding() ? ((Dimension2D)((AttachedProperties)object2).rightSystemInset.get()).getWidth() : 0.0;
                d6 = this.isRightSystemPadding() ? ((Dimension2D)((AttachedProperties)object2).leftSystemInset.get()).getWidth() : 0.0;
            } else {
                d5 = this.isLeftSystemPadding() ? ((Dimension2D)((AttachedProperties)object2).leftSystemInset.get()).getWidth() : 0.0;
                d6 = this.isRightSystemPadding() ? ((Dimension2D)((AttachedProperties)object2).rightSystemInset.get()).getWidth() : 0.0;
            }
        }
        return insets.getLeft() + d4 + d2 + d3 + insets.getRight() + d5 + d6;
    }

    @Override
    protected double computeMinHeight(double d) {
        double d2;
        Node node = this.getLeft();
        Node node2 = this.getCenter();
        Node node3 = this.getRight();
        Insets insets = this.getInsets();
        double d3 = this.getAreaHeight(node, -1.0, true);
        double d4 = this.getAreaHeight(node3, -1.0, true);
        if (d != -1.0 && this.childHasContentBias(node2, Orientation.HORIZONTAL)) {
            double d5 = this.getAreaWidth(node, -1.0, false);
            double d6 = this.getAreaWidth(node3, -1.0, false);
            d2 = this.getAreaHeight(node2, Math.max(0.0, d - d5 - d6), true);
        } else {
            d2 = this.getAreaHeight(node2, -1.0, true);
        }
        return insets.getTop() + insets.getBottom() + Math.max(d2, Math.max(d4, d3));
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2;
        Node node = this.getLeft();
        Node node2 = this.getCenter();
        Node node3 = this.getRight();
        Insets insets = this.getInsets();
        double d3 = this.getAreaHeight(node, -1.0, false);
        double d4 = this.getAreaHeight(node3, -1.0, false);
        if (d != -1.0 && this.childHasContentBias(node2, Orientation.HORIZONTAL)) {
            double d5 = this.getAreaWidth(node, -1.0, false);
            double d6 = this.getAreaWidth(node3, -1.0, false);
            d2 = this.getAreaHeight(node2, Math.max(0.0, d - d5 - d6), false);
        } else {
            d2 = this.getAreaHeight(node2, -1.0, false);
        }
        return insets.getTop() + insets.getBottom() + Math.max(d2, Math.max(d4, d3));
    }

    @Override
    protected void layoutChildren() {
        Pos pos;
        double d;
        double d2;
        Insets insets;
        Object object;
        Object object2;
        Window window;
        Node node = this.getLeft();
        Node node2 = this.getCenter();
        Node node3 = this.getRight();
        Insets insets2 = this.getInsets();
        double d3 = Math.max(this.getWidth(), this.minWidth(-1.0));
        double d4 = Math.max(this.getHeight(), this.minHeight(-1.0));
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = insets2.getTop();
        double d8 = d4 - d7 - insets2.getBottom();
        double d9 = 0.0;
        double d10 = 0.0;
        Scene scene = this.getScene();
        Object object3 = scene != null ? ((window = scene.getWindow()) instanceof Stage ? (object2 = (Stage)window) : null) : (object = null);
        if (object != null) {
            object2 = AttachedProperties.of(object);
            if (scene.getEffectiveNodeOrientation() != this.getEffectiveNodeOrientation()) {
                d10 = this.isLeftSystemPadding() ? ((Dimension2D)((AttachedProperties)object2).rightSystemInset.get()).getWidth() : 0.0;
                d9 = this.isRightSystemPadding() ? ((Dimension2D)((AttachedProperties)object2).leftSystemInset.get()).getWidth() : 0.0;
            } else {
                d10 = this.isLeftSystemPadding() ? ((Dimension2D)((AttachedProperties)object2).leftSystemInset.get()).getWidth() : 0.0;
                d9 = this.isRightSystemPadding() ? ((Dimension2D)((AttachedProperties)object2).rightSystemInset.get()).getWidth() : 0.0;
            }
        }
        double d11 = insets2.getLeft() + d10;
        double d12 = d3 - d11 - insets2.getRight() - d9;
        if (node != null && node.isManaged()) {
            insets = this.getNodeMargin(node);
            d2 = this.adjustWidthByMargin(d12, insets);
            d = this.resizeChild(node, d2, false, d8, insets);
            d5 = this.snapSpaceX(insets.getLeft()) + d + this.snapSpaceX(insets.getRight());
            pos = HeaderBar.getAlignment(node);
            HeaderBar.positionInArea(node, d11, d7, d5, d8, 0.0, insets, pos != null ? pos.getHpos() : HPos.CENTER, pos != null ? pos.getVpos() : VPos.CENTER, this.isSnapToPixel());
        }
        if (node3 != null && node3.isManaged()) {
            insets = this.getNodeMargin(node3);
            d2 = this.adjustWidthByMargin(d12 - d5, insets);
            d = this.resizeChild(node3, d2, false, d8, insets);
            d6 = this.snapSpaceX(insets.getLeft()) + d + this.snapSpaceX(insets.getRight());
            pos = HeaderBar.getAlignment(node3);
            HeaderBar.positionInArea(node3, d11 + d12 - d6, d7, d6, d8, 0.0, insets, pos != null ? pos.getHpos() : HPos.CENTER, pos != null ? pos.getVpos() : VPos.CENTER, this.isSnapToPixel());
        }
        if (node2 != null && node2.isManaged()) {
            insets = this.getNodeMargin(node2);
            Pos pos2 = HeaderBar.getAlignment(node2);
            if (pos2 == null || pos2.getHpos() == HPos.CENTER) {
                double d13 = this.adjustWidthByMargin(d12 - d5 - d6, insets);
                double d14 = this.resizeChild(node2, d13, true, d8, insets);
                double d15 = d3 / 2.0 - d14 / 2.0;
                double d16 = d11 + d5 + insets.getLeft();
                double d17 = d11 + d12 - d6 - insets.getRight();
                double d18 = d15 < d16 ? d16 : (d15 + d14 > d17 ? d17 - d14 : d15);
                HeaderBar.positionInArea(node2, d18, d7, d14, d8, 0.0, new Insets(insets.getTop(), 0.0, insets.getBottom(), 0.0), HPos.LEFT, pos2 != null ? pos2.getVpos() : VPos.CENTER, this.isSnapToPixel());
            } else {
                this.layoutInArea(node2, d11 + d5, d7, d12 - d5 - d6, d8, 0.0, insets, pos2.getHpos(), pos2.getVpos());
            }
        }
    }

    private boolean childHasContentBias(Node node, Orientation orientation) {
        if (node != null && node.isManaged()) {
            return node.getContentBias() == orientation;
        }
        return false;
    }

    private double resizeChild(Node node, double d, boolean bl, double d2, Insets insets) {
        double d3 = this.adjustHeightByMargin(d2, insets);
        double d4 = bl ? d : Math.min(this.snapSizeX(node.prefWidth(d3)), d);
        Vec2d vec2d = HeaderBar.boundedNodeSizeWithBias(node, d4, d3, true, true, TEMP_VEC2D);
        vec2d.x = this.snapSizeX(vec2d.x);
        vec2d.y = this.snapSizeX(vec2d.y);
        node.resize(vec2d.x, vec2d.y);
        return vec2d.x;
    }

    private double getAreaWidth(Node node, double d, boolean bl) {
        if (node != null && node.isManaged()) {
            Insets insets = this.getNodeMargin(node);
            return bl ? this.computeChildMinAreaWidth(node, -1.0, insets, d, false) : this.computeChildPrefAreaWidth(node, -1.0, insets, d, false);
        }
        return 0.0;
    }

    private double getAreaHeight(Node node, double d, boolean bl) {
        if (node != null && node.isManaged()) {
            Insets insets = this.getNodeMargin(node);
            return bl ? this.computeChildMinAreaHeight(node, -1.0, insets, d, false) : this.computeChildPrefAreaHeight(node, -1.0, insets, d, false);
        }
        return 0.0;
    }

    private Insets getNodeMargin(Node node) {
        Insets insets = HeaderBar.getMargin(node);
        return insets != null ? insets : Insets.EMPTY;
    }

    private void onStageChanged(Stage stage) {
        this.subscriptions.unsubscribe();
        if (stage != null) {
            AttachedProperties attachedProperties = AttachedProperties.of(stage);
            this.subscriptions = Subscription.combine((Subscription[])new Subscription[]{attachedProperties.minSystemHeight.subscribe(number -> {
                StyleableDoubleProperty styleableDoubleProperty = (StyleableDoubleProperty)this.minHeightProperty();
                if (styleableDoubleProperty.getStyleOrigin() == null) {
                    styleableDoubleProperty.applyStyle((StyleOrigin)null, (Number)number);
                }
            }), attachedProperties.subscribeLayoutInvalidated(this::requestLayout)});
        }
    }

    private static final class AttachedProperties {
        private final Stage stage;
        private final ReadOnlyObjectWrapper<Dimension2D> leftSystemInset;
        private final ReadOnlyObjectWrapper<Dimension2D> rightSystemInset;
        private final ReadOnlyDoubleWrapper minSystemHeight;
        private final DoubleProperty prefButtonHeight;
        private final List<Runnable> layoutInvalidatedListeners = new ArrayList<Runnable>();
        private boolean currentFullScreen;
        private HeaderButtonMetrics currentMetrics;

        AttachedProperties(final Stage stage) {
            this.stage = stage;
            this.leftSystemInset = new ReadOnlyObjectWrapper((Object)stage, "leftSystemInset", (Object)EMPTY);
            this.rightSystemInset = new ReadOnlyObjectWrapper((Object)stage, "rightSystemInset", (Object)EMPTY);
            this.minSystemHeight = new ReadOnlyDoubleWrapper((Object)stage, "minSystemHeight");
            this.prefButtonHeight = new SimpleDoubleProperty(this, stage, "prefButtonHeight", StageHelper.getPrefHeaderButtonHeight(stage)){
                {
                    Objects.requireNonNull(attachedProperties);
                    super(object, string, d);
                }

                protected void invalidated() {
                    StageHelper.setPrefHeaderButtonHeight(stage, this.get());
                }
            };
            StageHelper.getHeaderButtonMetrics(stage).subscribe(this::onMetricsChanged);
            stage.fullScreenProperty().subscribe(this::onFullScreenChanged);
            stage.sceneProperty().flatMap(Scene::effectiveNodeOrientationProperty).subscribe(this::updateInsets);
        }

        public static AttachedProperties of(Stage stage) {
            AttachedProperties attachedProperties = (AttachedProperties)Objects.requireNonNull(stage, "Stage cannot be null").getProperties().get(AttachedProperties.class);
            if (attachedProperties == null) {
                attachedProperties = new AttachedProperties(stage);
                stage.getProperties().put(AttachedProperties.class, (Object)attachedProperties);
            }
            return attachedProperties;
        }

        public Subscription subscribeLayoutInvalidated(Runnable runnable) {
            this.layoutInvalidatedListeners.add(runnable);
            return () -> this.layoutInvalidatedListeners.remove(runnable);
        }

        private void onMetricsChanged(HeaderButtonMetrics headerButtonMetrics) {
            NodeOrientation nodeOrientation;
            this.currentMetrics = headerButtonMetrics;
            Scene scene = this.stage.getScene();
            if (scene instanceof Scene) {
                Scene scene2 = scene;
                nodeOrientation = scene2.getEffectiveNodeOrientation();
            } else {
                nodeOrientation = NodeOrientation.LEFT_TO_RIGHT;
            }
            this.updateInsets(nodeOrientation);
        }

        private void onFullScreenChanged(boolean bl) {
            NodeOrientation nodeOrientation;
            this.currentFullScreen = bl;
            Scene scene = this.stage.getScene();
            if (scene instanceof Scene) {
                Scene scene2 = scene;
                nodeOrientation = scene2.getEffectiveNodeOrientation();
            } else {
                nodeOrientation = NodeOrientation.LEFT_TO_RIGHT;
            }
            this.updateInsets(nodeOrientation);
        }

        private void updateInsets(NodeOrientation nodeOrientation) {
            if (this.currentFullScreen || this.currentMetrics == null) {
                this.leftSystemInset.set((Object)EMPTY);
                this.rightSystemInset.set((Object)EMPTY);
                this.minSystemHeight.set(0.0);
            } else if (nodeOrientation == NodeOrientation.LEFT_TO_RIGHT) {
                this.leftSystemInset.set((Object)this.currentMetrics.leftInset());
                this.rightSystemInset.set((Object)this.currentMetrics.rightInset());
                this.minSystemHeight.set(this.currentMetrics.minHeight());
            } else {
                this.leftSystemInset.set((Object)this.currentMetrics.rightInset());
                this.rightSystemInset.set((Object)this.currentMetrics.leftInset());
                this.minSystemHeight.set(this.currentMetrics.minHeight());
            }
            this.layoutInvalidatedListeners.forEach(Runnable::run);
        }
    }

    private final class NodeProperty
    extends ObjectPropertyBase<Node> {
        private final String name;
        private Node value;
        final /* synthetic */ HeaderBar this$0;

        NodeProperty(HeaderBar headerBar, String string) {
            HeaderBar headerBar2 = headerBar;
            Objects.requireNonNull(headerBar2);
            this.this$0 = headerBar2;
            this.name = string;
        }

        public Object getBean() {
            return this.this$0;
        }

        public String getName() {
            return this.name;
        }

        protected void invalidated() {
            if (this.value != null) {
                this.this$0.getChildren().remove((Object)this.value);
            }
            this.value = (Node)this.get();
            if (this.value != null) {
                this.this$0.getChildren().add((Object)this.value);
            }
        }
    }
}

