/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.StringBuilderStyledOutput;
import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.text.Font;
import jfx.incubator.scene.control.richtext.LineNumberDecorator;
import jfx.incubator.scene.control.richtext.RichTextArea;
import jfx.incubator.scene.control.richtext.SyntaxDecorator;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.CodeTextModel;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;
import jfx.incubator.scene.control.richtext.skin.CodeAreaSkin;
import jfx.incubator.scene.control.richtext.skin.RichTextAreaSkin;

public class CodeArea
extends RichTextArea {
    private BooleanProperty lineNumbers;
    private StyleableIntegerProperty tabSize;
    private StyleableObjectProperty<Font> font;
    private StyleableDoubleProperty lineSpacing;
    private String fontStyle;

    public CodeArea(CodeTextModel codeTextModel) {
        super(codeTextModel);
        this.getStyleClass().add((Object)"code-area");
        this.setAccessibleRoleDescription("Code Area");
    }

    public CodeArea() {
        this(new CodeTextModel());
    }

    @Override
    protected void validateModel(StyledTextModel styledTextModel) {
        if (styledTextModel != null && !(styledTextModel instanceof CodeTextModel)) {
            throw new IllegalArgumentException("CodeArea accepts models that extend CodeTextModel");
        }
    }

    @Override
    protected RichTextAreaSkin createDefaultSkin() {
        return new CodeAreaSkin(this);
    }

    public final void setSyntaxDecorator(SyntaxDecorator syntaxDecorator) {
        CodeTextModel codeTextModel = this.codeModel();
        if (codeTextModel != null) {
            codeTextModel.setDecorator(syntaxDecorator);
        }
    }

    public final SyntaxDecorator getSyntaxDecorator() {
        CodeTextModel codeTextModel = this.codeModel();
        return codeTextModel == null ? null : codeTextModel.getDecorator();
    }

    public final BooleanProperty lineNumbersEnabledProperty() {
        if (this.lineNumbers == null) {
            this.lineNumbers = new SimpleBooleanProperty(this){
                final /* synthetic */ CodeArea this$0;
                {
                    CodeArea codeArea2 = codeArea;
                    Objects.requireNonNull(codeArea2);
                    this.this$0 = codeArea2;
                }

                protected void invalidated() {
                    LineNumberDecorator lineNumberDecorator = this.get() ? new LineNumberDecorator(this){
                        final /* synthetic */ 1 this$1;
                        {
                            1 v0 = var1_1;
                            Objects.requireNonNull(v0);
                            this.this$1 = v0;
                        }

                        @Override
                        public Node getMeasurementNode(int n) {
                            return this.bindFont(super.getMeasurementNode(n));
                        }

                        @Override
                        public Node getNode(int n) {
                            return this.bindFont(super.getNode(n));
                        }

                        private Node bindFont(Node node) {
                            if (node instanceof Labeled) {
                                Labeled labeled = (Labeled)node;
                                labeled.fontProperty().bind(this.this$1.this$0.fontProperty());
                            }
                            return node;
                        }
                    } : null;
                    this.this$0.setLeftDecorator(lineNumberDecorator);
                }
            };
        }
        return this.lineNumbers;
    }

    public final boolean isLineNumbersEnabled() {
        return this.lineNumbers == null ? false : this.lineNumbers.get();
    }

    public final void setLineNumbersEnabled(boolean bl) {
        this.lineNumbersEnabledProperty().set(bl);
    }

    public final IntegerProperty tabSizeProperty() {
        if (this.tabSize == null) {
            this.tabSize = new StyleableIntegerProperty(this, 8){
                final /* synthetic */ CodeArea this$0;
                {
                    CodeArea codeArea2 = codeArea;
                    Objects.requireNonNull(codeArea2);
                    this.this$0 = codeArea2;
                    super(n);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "tabSize";
                }

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TAB_SIZE;
                }
            };
        }
        return this.tabSize;
    }

    public final int getTabSize() {
        return this.tabSize == null ? 8 : this.tabSize.get();
    }

    public final void setTabSize(int n) {
        this.tabSizeProperty().set(n);
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new StyleableObjectProperty<Font>(this, CodeArea.defaultFont()){
                private boolean fontSetByCss;
                final /* synthetic */ CodeArea this$0;
                {
                    CodeArea codeArea2 = codeArea;
                    Objects.requireNonNull(codeArea2);
                    this.this$0 = codeArea2;
                    super((Object)font);
                }

                public void applyStyle(StyleOrigin styleOrigin, Font font) {
                    try {
                        this.fontSetByCss = true;
                        super.applyStyle(styleOrigin, (Object)font);
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                    finally {
                        this.fontSetByCss = false;
                    }
                }

                public void set(Font font) {
                    Font font2 = (Font)this.get();
                    if (font == null ? font2 == null : font.equals((Object)font2)) {
                        return;
                    }
                    super.set((Object)font);
                }

                public CssMetaData<CodeArea, Font> getCssMetaData() {
                    return StyleableProperties.FONT;
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "font";
                }
            };
        }
        return this.font;
    }

    public final void setFont(Font font) {
        this.fontProperty().setValue((Object)font);
    }

    public final Font getFont() {
        return this.font == null ? CodeArea.defaultFont() : (Font)this.font.getValue();
    }

    private static Font defaultFont() {
        return Font.font((String)"Monospaced", (double)-1.0);
    }

    public final DoubleProperty lineSpacingProperty() {
        if (this.lineSpacing == null) {
            this.lineSpacing = new StyleableDoubleProperty(this, 0.0){
                final /* synthetic */ CodeArea this$0;
                {
                    CodeArea codeArea2 = codeArea;
                    Objects.requireNonNull(codeArea2);
                    this.this$0 = codeArea2;
                    super(d);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "lineSpacing";
                }

                public CssMetaData<CodeArea, Number> getCssMetaData() {
                    return StyleableProperties.LINE_SPACING;
                }
            };
        }
        return this.lineSpacing;
    }

    public final void setLineSpacing(double d) {
        this.lineSpacingProperty().set(d);
    }

    public final double getLineSpacing() {
        return this.lineSpacing == null ? 0.0 : this.lineSpacing.get();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case FONT: {
                return this.getFont();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public final String getText() {
        String string;
        StyledTextModel styledTextModel = this.getModel();
        if (styledTextModel == null) {
            return "";
        }
        TextPos textPos = styledTextModel.getDocumentEnd();
        StringBuilderStyledOutput stringBuilderStyledOutput = new StringBuilderStyledOutput(styledTextModel.getLineEnding());
        try {
            styledTextModel.export(TextPos.ZERO, textPos, stringBuilderStyledOutput);
            string = stringBuilderStyledOutput.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stringBuilderStyledOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        stringBuilderStyledOutput.close();
        return string;
    }

    public final void setText(String string) {
        TextPos textPos = this.getDocumentEnd();
        this.getModel().replace(null, TextPos.ZERO, textPos, string);
    }

    private CodeTextModel codeModel() {
        return (CodeTextModel)this.getModel();
    }

    private static class StyleableProperties {
        private static final CssMetaData<CodeArea, Number> LINE_SPACING = new CssMetaData<CodeArea, Number>("-fx-line-spacing", SizeConverter.getInstance(), (Number)0){

            public boolean isSettable(CodeArea codeArea) {
                return codeArea.lineSpacing == null || !codeArea.lineSpacing.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(CodeArea codeArea) {
                return (StyleableProperty)codeArea.lineSpacingProperty();
            }
        };
        private static final FontCssMetaData<CodeArea> FONT = new FontCssMetaData<CodeArea>("-fx-font", CodeArea.defaultFont()){

            public boolean isSettable(CodeArea codeArea) {
                return codeArea.font == null || !codeArea.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(CodeArea codeArea) {
                return (StyleableProperty)codeArea.fontProperty();
            }
        };
        private static final CssMetaData<CodeArea, Number> TAB_SIZE = new CssMetaData<CodeArea, Number>("-fx-tab-size", SizeConverter.getInstance(), (Number)8){

            public boolean isSettable(CodeArea codeArea) {
                return codeArea.tabSize == null || !codeArea.tabSize.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(CodeArea codeArea) {
                return (StyleableProperty)codeArea.tabSizeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES = RichUtils.combine(RichTextArea.getClassCssMetaData(), new CssMetaData[]{FONT, LINE_SPACING, TAB_SIZE});

        private StyleableProperties() {
        }
    }
}

