/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.tk.Toolkit;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import com.sun.webkit.network.ByteBufferPool;
import com.sun.webkit.network.FormDataElement;
import com.sun.webkit.network.URLLoader;
import com.sun.webkit.network.URLLoaderBase;
import com.sun.webkit.network.URLs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLHandshakeException;

final class HTTP2Loader
extends URLLoaderBase {
    private static final PlatformLogger logger = PlatformLogger.getLogger((String)URLLoader.class.getName());
    private final WebPage webPage;
    private final boolean asynchronous;
    private String url;
    private String method;
    private final String headers;
    private FormDataElement[] formDataElements;
    private final long data;
    private volatile boolean canceled = false;
    private final CompletableFuture<Void> response;
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NEVER).connectTimeout(Duration.ofSeconds(30L)).cookieHandler(CookieHandler.getDefault()).build();
    private static final int DEFAULT_BUFSIZE = 40960;
    private static final ByteBuffer BUFFER;

    static HTTP2Loader create(WebPage webPage, ByteBufferPool byteBufferPool, boolean bl, String string, String string2, String string3, FormDataElement[] formDataElementArray, long l) {
        if (string.startsWith("http://") || string.startsWith("https://")) {
            return new HTTP2Loader(webPage, byteBufferPool, bl, string, string2, string3, formDataElementArray, l);
        }
        return null;
    }

    private String[] getCustomHeaders() {
        Locale locale = Locale.getDefault();
        Object object = "";
        if (!locale.equals(Locale.US) && !locale.equals(Locale.ENGLISH)) {
            object = locale.getCountry().isEmpty() ? locale.getLanguage() + "," : locale.getLanguage() + "-" + locale.getCountry() + ",";
        }
        return new String[]{"Accept-Language", ((String)object).toLowerCase() + "en-us;q=0.8,en;q=0.7", "Accept-Encoding", "gzip, inflate", "Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7"};
    }

    private String[] getRequestHeaders() {
        return (String[])Arrays.stream(this.headers.split("\n")).flatMap(string -> Stream.of(string.split(":", 2))).toArray(String[]::new);
    }

    private URI toURI() throws MalformedURLException {
        URI uRI;
        try {
            uRI = new URI(this.url);
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            try {
                URL uRL = URLs.newURL(this.url);
                uRI = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception2) {
                throw new MalformedURLException(this.url);
            }
        }
        return uRI;
    }

    private HttpRequest.BodyPublisher getFormDataPublisher() {
        if (this.formDataElements == null) {
            return HttpRequest.BodyPublishers.noBody();
        }
        Vector<InputStream> vector = new Vector<InputStream>();
        final AtomicLong atomicLong = new AtomicLong();
        for (FormDataElement formDataElement : this.formDataElements) {
            try {
                formDataElement.open();
                atomicLong.addAndGet(formDataElement.getSize());
                vector.add(formDataElement.getInputStream());
            }
            catch (IOException iOException) {
                return null;
            }
        }
        SequenceInputStream sequenceInputStream = new SequenceInputStream(vector.elements());
        final HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> sequenceInputStream);
        HttpRequest.BodyPublisher bodyPublisher2 = new HttpRequest.BodyPublisher(){
            final /* synthetic */ HTTP2Loader this$0;
            {
                HTTP2Loader hTTP2Loader2 = hTTP2Loader;
                Objects.requireNonNull(hTTP2Loader2);
                this.this$0 = hTTP2Loader2;
            }

            @Override
            public long contentLength() {
                return atomicLong.longValue() <= Integer.MAX_VALUE ? atomicLong.longValue() : -1L;
            }

            @Override
            public void subscribe(final Flow.Subscriber<? super ByteBuffer> subscriber) {
                bodyPublisher.subscribe(new Flow.Subscriber<ByteBuffer>(){
                    final /* synthetic */ 1 this$1;
                    {
                        1 v0 = var1_1;
                        Objects.requireNonNull(v0);
                        this.this$1 = v0;
                    }

                    @Override
                    public void onComplete() {
                        subscriber.onComplete();
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        subscriber.onError(throwable);
                    }

                    @Override
                    public void onNext(ByteBuffer byteBuffer) {
                        subscriber.onNext(byteBuffer);
                        this.this$1.this$0.didSendData(byteBuffer.limit(), atomicLong.longValue());
                    }

                    @Override
                    public void onSubscribe(Flow.Subscription subscription) {
                        subscriber.onSubscribe(subscription);
                    }
                });
            }
        };
        return bodyPublisher2;
    }

    private InputStream createZIPStream(String string, InputStream inputStream) throws IOException {
        if ("gzip".equalsIgnoreCase(string)) {
            return new GZIPInputStream(inputStream);
        }
        if ("deflate".equalsIgnoreCase(string)) {
            return new InflaterInputStream(inputStream);
        }
        return inputStream;
    }

    private HttpResponse.BodySubscriber<Void> createZIPEncodedBodySubscriber(String string) {
        if (!"gzip".equalsIgnoreCase(string) && !"inflate".equalsIgnoreCase(string)) {
            logger.severe(String.format("Unknown encoding type '%s' found, discarding", string));
            return HttpResponse.BodySubscribers.discarding();
        }
        final HttpResponse.BodySubscriber<InputStream> bodySubscriber = HttpResponse.BodySubscribers.ofInputStream();
        final CompletionStage<Void> completionStage = bodySubscriber.getBody().thenAcceptAsync(inputStream -> {
            try (InputStream inputStream2 = inputStream;
                 InputStream inputStream3 = this.createZIPStream(string, inputStream2);){
                while (!this.canceled) {
                    byte[] byArray = new byte[8192];
                    int n = inputStream3.read(byArray);
                    if (n < 0) {
                        this.didFinishLoading();
                        break;
                    }
                    this.didReceiveData(byArray, n);
                }
            }
            catch (IOException iOException) {
                this.didFail(iOException);
            }
        });
        return new HttpResponse.BodySubscriber<Void>(this){
            {
                Objects.requireNonNull(hTTP2Loader);
            }

            @Override
            public void onComplete() {
                bodySubscriber.onComplete();
            }

            @Override
            public void onError(Throwable throwable) {
                bodySubscriber.onError(throwable);
            }

            @Override
            public void onNext(List<ByteBuffer> list) {
                bodySubscriber.onNext(list);
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                bodySubscriber.onSubscribe(subscription);
            }

            @Override
            public CompletionStage<Void> getBody() {
                return bodySubscriber.getBody().thenCombine(completionStage, (inputStream, void_) -> null);
            }
        };
    }

    private HttpResponse.BodySubscriber<Void> createNormalBodySubscriber() {
        HttpResponse.BodySubscriber<Void> bodySubscriber = HttpResponse.BodySubscribers.fromSubscriber((Flow.Subscriber<? super List<ByteBuffer>>)new Flow.Subscriber<List<ByteBuffer>>(this){
            private Flow.Subscription subscription;
            private final AtomicBoolean subscribed;
            final /* synthetic */ HTTP2Loader this$0;
            {
                HTTP2Loader hTTP2Loader2 = hTTP2Loader;
                Objects.requireNonNull(hTTP2Loader2);
                this.this$0 = hTTP2Loader2;
                this.subscribed = new AtomicBoolean();
            }

            @Override
            public void onComplete() {
                this.this$0.didFinishLoading();
            }

            @Override
            public void onError(Throwable throwable) {
            }

            @Override
            public void onNext(List<ByteBuffer> list) {
                this.this$0.didReceiveData(list);
                this.requestIfNotCancelled();
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                if (!this.subscribed.compareAndSet(false, true)) {
                    subscription.cancel();
                } else {
                    this.subscription = subscription;
                    this.requestIfNotCancelled();
                }
            }

            private void requestIfNotCancelled() {
                if (this.this$0.canceled) {
                    this.subscription.cancel();
                } else {
                    this.subscription.request(1L);
                }
            }
        });
        return bodySubscriber;
    }

    private HttpResponse.BodySubscriber<Void> getBodySubscriber(String string) {
        return string.isEmpty() ? this.createNormalBodySubscriber() : this.createZIPEncodedBodySubscriber(string);
    }

    private HTTP2Loader(WebPage webPage, ByteBufferPool byteBufferPool, boolean bl, String string, String string2, String string3, FormDataElement[] formDataElementArray, long l) {
        URI uRI;
        this.webPage = webPage;
        this.asynchronous = bl;
        this.url = string;
        this.method = string2;
        this.headers = string3;
        this.formDataElements = formDataElementArray;
        this.data = l;
        try {
            uRI = this.toURI();
        }
        catch (MalformedURLException malformedURLException) {
            this.response = null;
            this.didFail(malformedURLException);
            return;
        }
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).headers(this.getRequestHeaders()).headers(this.getCustomHeaders()).version(HttpClient.Version.HTTP_2).method(string2, this.getFormDataPublisher()).build();
        HttpResponse.BodyHandler bodyHandler = responseInfo -> {
            if (!this.handleRedirectionIfNeeded(responseInfo)) {
                this.didReceiveResponse(responseInfo);
            }
            return this.getBodySubscriber(HTTP2Loader.getContentEncoding(responseInfo));
        };
        this.response = ((CompletableFuture)HTTP_CLIENT.sendAsync(httpRequest, bodyHandler).thenAccept(httpResponse -> {})).exceptionally(throwable -> this.didFail(throwable.getCause()));
        if (!bl) {
            this.waitForRequestToComplete();
        }
    }

    @Override
    public void fwkCancel() {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("data: [0x%016X]", this.data));
        }
        this.canceled = true;
    }

    private void callBackIfNotCanceled(Runnable runnable) {
        Invoker.getInvoker().invokeOnEventThread(() -> {
            if (!this.canceled) {
                runnable.run();
            }
        });
    }

    private void waitForRequestToComplete() {
        Object object = new Object();
        this.response.handle((void_, throwable) -> {
            Invoker.getInvoker().invokeOnEventThread(() -> Toolkit.getToolkit().exitNestedEventLoop(object, null));
            return null;
        });
        Toolkit.getToolkit().enterNestedEventLoop(object);
    }

    private boolean handleRedirectionIfNeeded(HttpResponse.ResponseInfo responseInfo) {
        switch (responseInfo.statusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                this.willSendRequest(responseInfo);
                return true;
            }
            case 304: {
                this.didReceiveResponse(responseInfo);
                this.didFinishLoading();
                return true;
            }
        }
        return false;
    }

    private static long getContentLength(HttpResponse.ResponseInfo responseInfo) {
        return responseInfo.headers().firstValueAsLong("content-length").orElse(-1L);
    }

    private static String getContentType(HttpResponse.ResponseInfo responseInfo) {
        return responseInfo.headers().firstValue("content-type").orElse("application/octet-stream");
    }

    private static String getContentEncoding(HttpResponse.ResponseInfo responseInfo) {
        return responseInfo.headers().firstValue("content-encoding").orElse("");
    }

    private static String getHeadersAsString(HttpResponse.ResponseInfo responseInfo) {
        return responseInfo.headers().map().entrySet().stream().map(entry -> String.format("%s:%s", entry.getKey(), ((List)entry.getValue()).stream().collect(Collectors.joining(",")))).collect(Collectors.joining("\n")) + "\n";
    }

    private void willSendRequest(HttpResponse.ResponseInfo responseInfo) {
        this.callBackIfNotCanceled(() -> HTTP2Loader.twkWillSendRequest(responseInfo.statusCode(), HTTP2Loader.getContentType(responseInfo), "", HTTP2Loader.getContentLength(responseInfo), HTTP2Loader.getHeadersAsString(responseInfo), this.url, this.data));
    }

    private void didReceiveResponse(HttpResponse.ResponseInfo responseInfo) {
        this.callBackIfNotCanceled(() -> HTTP2Loader.twkDidReceiveResponse(responseInfo.statusCode(), HTTP2Loader.getContentType(responseInfo), "", HTTP2Loader.getContentLength(responseInfo), HTTP2Loader.getHeadersAsString(responseInfo), this.url, this.data));
    }

    private ByteBuffer getDirectBuffer(int n) {
        ByteBuffer byteBuffer = BUFFER;
        if (n > byteBuffer.capacity()) {
            byteBuffer = ByteBuffer.allocateDirect(n);
        }
        return byteBuffer.clear();
    }

    private ByteBuffer copyToDirectBuffer(ByteBuffer byteBuffer) {
        return this.getDirectBuffer(byteBuffer.limit()).put(byteBuffer).flip();
    }

    private void didReceiveData(byte[] byArray, int n) {
        this.callBackIfNotCanceled(() -> this.notifyDidReceiveData(this.getDirectBuffer(n).put(byArray, 0, n).flip()));
    }

    private void didReceiveData(List<ByteBuffer> list) {
        this.callBackIfNotCanceled(() -> list.stream().map(this::copyToDirectBuffer).forEach(this::notifyDidReceiveData));
    }

    private void notifyDidReceiveData(ByteBuffer byteBuffer) {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("byteBuffer: [%s], position: [%s], remaining: [%s], data: [0x%016X]", byteBuffer, byteBuffer.position(), byteBuffer.remaining(), this.data));
        }
        HTTP2Loader.twkDidReceiveData(byteBuffer, byteBuffer.position(), byteBuffer.remaining(), this.data);
    }

    private void didFinishLoading() {
        this.callBackIfNotCanceled(this::notifyDidFinishLoading);
    }

    private void notifyDidFinishLoading() {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("data: [0x%016X]", this.data));
        }
        HTTP2Loader.twkDidFinishLoading(this.data);
    }

    private Void didFail(Throwable throwable) {
        this.callBackIfNotCanceled(() -> {
            int n;
            try {
                throw throwable;
            }
            catch (MalformedURLException malformedURLException) {
                n = 2;
            }
            catch (UnknownHostException unknownHostException) {
                n = 1;
            }
            catch (NoRouteToHostException noRouteToHostException) {
                n = 6;
            }
            catch (ConnectException connectException) {
                n = 4;
            }
            catch (SocketException socketException) {
                n = 5;
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                n = 3;
            }
            catch (SocketTimeoutException | HttpTimeoutException iOException) {
                n = 7;
            }
            catch (FileNotFoundException fileNotFoundException) {
                n = 11;
            }
            catch (Throwable throwable2) {
                n = 99;
            }
            this.notifyDidFail(n, this.url, throwable.getMessage());
        });
        return null;
    }

    private void notifyDidFail(int n, String string, String string2) {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("errorCode: [%d], url: [%s], message: [%s], data: [0x%016X]", n, string, string2, this.data));
        }
        HTTP2Loader.twkDidFail(n, string, string2, this.data);
    }

    private void didSendData(long l, long l2) {
        this.callBackIfNotCanceled(() -> this.notifyDidSendData(l, l2));
    }

    private void notifyDidSendData(long l, long l2) {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest(String.format("totalBytesSent: [%d], totalBytesToBeSent: [%d], data: [0x%016X]", l, l2, this.data));
        }
        HTTP2Loader.twkDidSendData(l, l2, this.data);
    }

    static {
        int n = Integer.valueOf(System.getProperty("jdk.httpclient.bufsize", Integer.toString(40960)));
        BUFFER = ByteBuffer.allocateDirect(n);
    }
}

