/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ChangeHelper;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public final class MappingChange<E, F>
extends ListChangeListener.Change<F> {
    private final Function<E, F> mapper;
    private final ListChangeListener.Change<? extends E> original;
    private List<F> removed;

    public MappingChange(ListChangeListener.Change<? extends E> change, Function<E, F> function, ObservableList<F> observableList) {
        super(observableList);
        this.original = change;
        this.mapper = function;
    }

    @Override
    public boolean next() {
        return this.original.next();
    }

    @Override
    public void reset() {
        this.original.reset();
    }

    @Override
    public int getFrom() {
        return this.original.getFrom();
    }

    @Override
    public int getTo() {
        return this.original.getTo();
    }

    @Override
    public List<F> getRemoved() {
        if (this.removed == null) {
            this.removed = new AbstractList<F>(this){
                final /* synthetic */ MappingChange this$0;
                {
                    MappingChange mappingChange2 = mappingChange;
                    Objects.requireNonNull(mappingChange2);
                    this.this$0 = mappingChange2;
                }

                @Override
                public F get(int n) {
                    return this.this$0.mapper.apply(this.this$0.original.getRemoved().get(n));
                }

                @Override
                public int size() {
                    return this.this$0.original.getRemovedSize();
                }
            };
        }
        return this.removed;
    }

    @Override
    protected int[] getPermutation() {
        return new int[0];
    }

    @Override
    public boolean wasPermutated() {
        return this.original.wasPermutated();
    }

    @Override
    public boolean wasUpdated() {
        return this.original.wasUpdated();
    }

    @Override
    public int getPermutation(int n) {
        return this.original.getPermutation(n);
    }

    public String toString() {
        int n = 0;
        while (this.next()) {
            ++n;
        }
        int n2 = 0;
        this.reset();
        while (this.next()) {
            ++n2;
        }
        this.reset();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        int n3 = 0;
        while (this.next()) {
            if (this.wasPermutated()) {
                stringBuilder.append(ChangeHelper.permChangeToString(this.getPermutation()));
            } else if (this.wasUpdated()) {
                stringBuilder.append(ChangeHelper.updateChangeToString(this.getFrom(), this.getTo()));
            } else {
                stringBuilder.append(ChangeHelper.addRemoveChangeToString(this.getFrom(), this.getTo(), this.getList(), this.getRemoved()));
            }
            if (n3 == n2) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" }");
        this.reset();
        n3 = n2 - n;
        while (n3-- > 0) {
            this.next();
        }
        return stringBuilder.toString();
    }
}

