/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.menu.CheckMenuItemBase;
import com.sun.javafx.menu.CustomMenuItemBase;
import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.menu.MenuItemBase;
import com.sun.javafx.menu.RadioMenuItemBase;
import com.sun.javafx.menu.SeparatorMenuItemBase;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class GlobalMenuAdapter
extends Menu
implements MenuBase {
    private Menu menu;
    private final ObservableList<MenuItemBase> items = new TrackableObservableList<MenuItemBase>(this){
        {
            Objects.requireNonNull(globalMenuAdapter);
        }

        protected void onChanged(ListChangeListener.Change<MenuItemBase> change) {
        }
    };

    public static MenuBase adapt(Menu menu) {
        return new GlobalMenuAdapter(menu);
    }

    private GlobalMenuAdapter(Menu menu) {
        super(menu.getText());
        this.menu = menu;
        GlobalMenuAdapter.bindMenuItemProperties(this, menu);
        menu.showingProperty().addListener(observable -> {
            if (menu.isShowing() && !this.isShowing()) {
                this.show();
            } else if (!menu.isShowing() && this.isShowing()) {
                this.hide();
            }
        });
        this.showingProperty().addListener(observable -> {
            if (this.isShowing() && !menu.isShowing()) {
                menu.show();
            } else if (!this.isShowing() && menu.isShowing()) {
                menu.hide();
            }
        });
        menu.getItems().addListener((ListChangeListener)new ListChangeListener<MenuItem>(this){
            final /* synthetic */ GlobalMenuAdapter this$0;
            {
                GlobalMenuAdapter globalMenuAdapter2 = globalMenuAdapter;
                Objects.requireNonNull(globalMenuAdapter2);
                this.this$0 = globalMenuAdapter2;
            }

            public void onChanged(ListChangeListener.Change<? extends MenuItem> change) {
                while (change.next()) {
                    int n;
                    int n2 = change.getFrom();
                    int n3 = change.getTo();
                    List list = change.getRemoved();
                    for (n = n2 + list.size() - 1; n >= n2; --n) {
                        this.this$0.items.remove(n);
                        this.this$0.getItems().remove(n);
                    }
                    for (n = n2; n < n3; ++n) {
                        MenuItem menuItem = (MenuItem)change.getList().get(n);
                        this.this$0.insertItem(menuItem, n);
                    }
                }
            }
        });
        for (MenuItem menuItem : menu.getItems()) {
            this.insertItem(menuItem, this.items.size());
        }
    }

    private void insertItem(MenuItem menuItem, int n) {
        MenuItem menuItem2 = menuItem instanceof Menu ? new GlobalMenuAdapter((Menu)menuItem) : (menuItem instanceof CheckMenuItem ? new CheckMenuItemAdapter((CheckMenuItem)menuItem) : (menuItem instanceof RadioMenuItem ? new RadioMenuItemAdapter((RadioMenuItem)menuItem) : (menuItem instanceof SeparatorMenuItem ? new SeparatorMenuItemAdapter((SeparatorMenuItem)menuItem) : (menuItem instanceof CustomMenuItem ? new CustomMenuItemAdapter((CustomMenuItem)menuItem) : new MenuItemAdapter(menuItem)))));
        this.items.add(n, (Object)menuItem2);
        this.getItems().add(n, (Object)menuItem2);
    }

    public final ObservableList<MenuItemBase> getItemsBase() {
        return this.items;
    }

    private static void bindMenuItemProperties(MenuItem menuItem, MenuItem menuItem2) {
        menuItem.idProperty().bind((ObservableValue)menuItem2.idProperty());
        menuItem.textProperty().bind((ObservableValue)menuItem2.textProperty());
        menuItem.graphicProperty().bind(menuItem2.graphicProperty());
        menuItem.disableProperty().bind((ObservableValue)menuItem2.disableProperty());
        menuItem.visibleProperty().bind((ObservableValue)menuItem2.visibleProperty());
        menuItem.acceleratorProperty().bind(menuItem2.acceleratorProperty());
        menuItem.mnemonicParsingProperty().bind((ObservableValue)menuItem2.mnemonicParsingProperty());
        menuItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)actionEvent -> menuItem2.fire()));
    }

    public void fireValidation() {
        Menu menu;
        if (this.menu.getOnMenuValidation() != null) {
            Event.fireEvent((EventTarget)this.menu, (Event)new Event(MENU_VALIDATION_EVENT));
        }
        if ((menu = this.menu.getParentMenu()) != null && menu.getOnMenuValidation() != null) {
            Event.fireEvent((EventTarget)menu, (Event)new Event(MenuItem.MENU_VALIDATION_EVENT));
        }
    }

    private static class CheckMenuItemAdapter
    extends CheckMenuItem
    implements CheckMenuItemBase {
        private CheckMenuItem menuItem;

        private CheckMenuItemAdapter(CheckMenuItem checkMenuItem) {
            super(checkMenuItem.getText());
            this.menuItem = checkMenuItem;
            GlobalMenuAdapter.bindMenuItemProperties(this, checkMenuItem);
            this.selectedProperty().bindBidirectional((Property)checkMenuItem.selectedProperty());
        }

        public void fireValidation() {
            Menu menu;
            if (this.getOnMenuValidation() != null) {
                Event.fireEvent((EventTarget)this.menuItem, (Event)new Event(MENU_VALIDATION_EVENT));
            }
            if ((menu = this.menuItem.getParentMenu()).getOnMenuValidation() != null) {
                Event.fireEvent((EventTarget)menu, (Event)new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
        }
    }

    private static class RadioMenuItemAdapter
    extends RadioMenuItem
    implements RadioMenuItemBase {
        private RadioMenuItem menuItem;

        private RadioMenuItemAdapter(RadioMenuItem radioMenuItem) {
            super(radioMenuItem.getText());
            this.menuItem = radioMenuItem;
            GlobalMenuAdapter.bindMenuItemProperties(this, radioMenuItem);
            this.selectedProperty().bindBidirectional((Property)radioMenuItem.selectedProperty());
        }

        public void fireValidation() {
            Menu menu;
            if (this.getOnMenuValidation() != null) {
                Event.fireEvent((EventTarget)this.menuItem, (Event)new Event(MENU_VALIDATION_EVENT));
            }
            if ((menu = this.menuItem.getParentMenu()).getOnMenuValidation() != null) {
                Event.fireEvent((EventTarget)menu, (Event)new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
        }
    }

    private static class SeparatorMenuItemAdapter
    extends SeparatorMenuItem
    implements SeparatorMenuItemBase {
        private SeparatorMenuItem menuItem;

        private SeparatorMenuItemAdapter(SeparatorMenuItem separatorMenuItem) {
            this.menuItem = separatorMenuItem;
            GlobalMenuAdapter.bindMenuItemProperties(this, separatorMenuItem);
        }

        public void fireValidation() {
            Menu menu;
            if (this.getOnMenuValidation() != null) {
                Event.fireEvent((EventTarget)this.menuItem, (Event)new Event(MENU_VALIDATION_EVENT));
            }
            if ((menu = this.menuItem.getParentMenu()).getOnMenuValidation() != null) {
                Event.fireEvent((EventTarget)menu, (Event)new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
        }
    }

    private static class CustomMenuItemAdapter
    extends CustomMenuItem
    implements CustomMenuItemBase {
        private CustomMenuItem menuItem;

        private CustomMenuItemAdapter(CustomMenuItem customMenuItem) {
            this.menuItem = customMenuItem;
            GlobalMenuAdapter.bindMenuItemProperties(this, customMenuItem);
        }

        public void fireValidation() {
            Menu menu;
            if (this.getOnMenuValidation() != null) {
                Event.fireEvent((EventTarget)this.menuItem, (Event)new Event(MENU_VALIDATION_EVENT));
            }
            if ((menu = this.menuItem.getParentMenu()).getOnMenuValidation() != null) {
                Event.fireEvent((EventTarget)menu, (Event)new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
        }
    }

    private static class MenuItemAdapter
    extends MenuItem
    implements MenuItemBase {
        private MenuItem menuItem;

        private MenuItemAdapter(MenuItem menuItem) {
            super(menuItem.getText());
            this.menuItem = menuItem;
            GlobalMenuAdapter.bindMenuItemProperties(this, menuItem);
        }

        public void fireValidation() {
            Menu menu;
            if (this.menuItem.getOnMenuValidation() != null) {
                Event.fireEvent((EventTarget)this.menuItem, (Event)new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
            if ((menu = this.menuItem.getParentMenu()).getOnMenuValidation() != null) {
                Event.fireEvent((EventTarget)menu, (Event)new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
        }
    }
}

