/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.event.EventDispatchChainImpl;
import com.sun.javafx.scene.control.InputField;
import java.util.Collection;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventDispatchChain;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;

public abstract class InputFieldSkin
implements Skin<InputField> {
    protected InputField control;
    private InnerTextField textField;
    private InvalidationListener InputFieldFocusListener;
    private InvalidationListener InputFieldStyleClassListener;

    public InputFieldSkin(InputField inputField) {
        this.control = inputField;
        this.textField = new InnerTextField(this){
            final /* synthetic */ InputFieldSkin this$0;
            {
                InputFieldSkin inputFieldSkin2 = inputFieldSkin;
                Objects.requireNonNull(inputFieldSkin2);
                this.this$0 = inputFieldSkin2;
                super(inputFieldSkin);
            }

            @Override
            public void replaceText(int n, int n2, String string) {
                Object object = this.this$0.textField.getText() == null ? "" : this.this$0.textField.getText();
                if (this.this$0.accept((String)(object = ((String)object).substring(0, n) + string + ((String)object).substring(n2)))) {
                    super.replaceText(n, n2, string);
                }
            }

            @Override
            public void replaceSelection(String string) {
                Object object = this.this$0.textField.getText() == null ? "" : this.this$0.textField.getText();
                int n = Math.min(this.this$0.textField.getAnchor(), this.this$0.textField.getCaretPosition());
                int n2 = Math.max(this.this$0.textField.getAnchor(), this.this$0.textField.getCaretPosition());
                if (this.this$0.accept((String)(object = ((String)object).substring(0, n) + string + ((String)object).substring(n2)))) {
                    super.replaceSelection(string);
                }
            }
        };
        this.textField.setId("input-text-field");
        this.textField.setFocusTraversable(false);
        inputField.getStyleClass().addAll((Collection)this.textField.getStyleClass());
        this.textField.getStyleClass().setAll((Collection)inputField.getStyleClass());
        this.InputFieldStyleClassListener = observable -> this.textField.getStyleClass().setAll((Collection)inputField.getStyleClass());
        inputField.getStyleClass().addListener(this.InputFieldStyleClassListener);
        this.textField.promptTextProperty().bind((ObservableValue)inputField.promptTextProperty());
        this.textField.prefColumnCountProperty().bind((ObservableValue)inputField.prefColumnCountProperty());
        this.textField.textProperty().addListener(observable -> this.updateValue());
        this.InputFieldFocusListener = observable -> this.textField.handleFocus(inputField.isFocused());
        inputField.focusedProperty().addListener(this.InputFieldFocusListener);
        this.updateText();
    }

    @Override
    public InputField getSkinnable() {
        return this.control;
    }

    @Override
    public Node getNode() {
        return this.textField;
    }

    @Override
    public void dispose() {
        this.control.getStyleClass().removeListener(this.InputFieldStyleClassListener);
        this.control.focusedProperty().removeListener(this.InputFieldFocusListener);
        this.textField = null;
    }

    protected abstract boolean accept(String var1);

    protected abstract void updateText();

    protected abstract void updateValue();

    protected TextField getTextField() {
        return this.textField;
    }

    private class InnerTextField
    extends TextField {
        final /* synthetic */ InputFieldSkin this$0;

        private InnerTextField(InputFieldSkin inputFieldSkin) {
            InputFieldSkin inputFieldSkin2 = inputFieldSkin;
            Objects.requireNonNull(inputFieldSkin2);
            this.this$0 = inputFieldSkin2;
        }

        public void handleFocus(boolean bl) {
            this.setFocused(bl);
        }

        public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
            EventDispatchChainImpl eventDispatchChainImpl = new EventDispatchChainImpl();
            eventDispatchChainImpl.append(this.this$0.textField.getEventDispatcher());
            return eventDispatchChainImpl;
        }
    }
}

