/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;

public class Alert
extends Dialog<ButtonType> {
    private WeakReference<DialogPane> dialogPaneRef;
    private boolean installingDefaults = false;
    private boolean hasCustomButtons = false;
    private boolean hasCustomTitle = false;
    private boolean hasCustomHeaderText = false;
    private final InvalidationListener headerTextListener = observable -> {
        if (!this.installingDefaults) {
            this.hasCustomHeaderText = true;
        }
    };
    private final InvalidationListener titleListener = observable -> {
        if (!this.installingDefaults) {
            this.hasCustomTitle = true;
        }
    };
    private final ListChangeListener<ButtonType> buttonsListener = change -> {
        if (!this.installingDefaults) {
            this.hasCustomButtons = true;
        }
    };
    private final ObjectProperty<AlertType> alertType = new SimpleObjectProperty<AlertType>(this, null){
        final String[] styleClasses;
        final /* synthetic */ Alert this$0;
        {
            Alert alert2 = alert;
            Objects.requireNonNull(alert2);
            this.this$0 = alert2;
            super((Object)alertType);
            this.styleClasses = new String[]{"information", "warning", "error", "confirmation"};
        }

        protected void invalidated() {
            DialogPane dialogPane;
            String string = "";
            String string2 = "";
            String string3 = "";
            Object[] objectArray = new ButtonType[]{ButtonType.OK};
            switch (this.this$0.getAlertType().ordinal()) {
                case 0: {
                    objectArray = new ButtonType[]{};
                    break;
                }
                case 1: {
                    string = ControlResources.getString("Dialog.info.title");
                    string2 = ControlResources.getString("Dialog.info.header");
                    string3 = "information";
                    break;
                }
                case 2: {
                    string = ControlResources.getString("Dialog.warning.title");
                    string2 = ControlResources.getString("Dialog.warning.header");
                    string3 = "warning";
                    break;
                }
                case 4: {
                    string = ControlResources.getString("Dialog.error.title");
                    string2 = ControlResources.getString("Dialog.error.header");
                    string3 = "error";
                    break;
                }
                case 3: {
                    string = ControlResources.getString("Dialog.confirm.title");
                    string2 = ControlResources.getString("Dialog.confirm.header");
                    string3 = "confirmation";
                    objectArray = new ButtonType[]{ButtonType.OK, ButtonType.CANCEL};
                }
            }
            this.this$0.installingDefaults = true;
            if (!this.this$0.hasCustomTitle) {
                this.this$0.setTitle(string);
            }
            if (!this.this$0.hasCustomHeaderText) {
                this.this$0.setHeaderText(string2);
            }
            if (!this.this$0.hasCustomButtons) {
                this.this$0.getButtonTypes().setAll(objectArray);
            }
            if ((dialogPane = this.this$0.getDialogPane()) != null) {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.styleClasses));
                arrayList.remove(string3);
                dialogPane.getStyleClass().removeAll(arrayList);
                if (!dialogPane.getStyleClass().contains((Object)string3)) {
                    dialogPane.getStyleClass().add((Object)string3);
                }
            }
            this.this$0.installingDefaults = false;
        }
    };

    public Alert(@NamedArg(value="alertType") AlertType alertType) {
        this(alertType, "", new ButtonType[0]);
    }

    public Alert(@NamedArg(value="alertType") AlertType alertType, @NamedArg(value="contentText") String string, ButtonType ... buttonTypeArray) {
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.setContentText(string);
        this.getDialogPane().getStyleClass().add((Object)"alert");
        this.dialogPaneRef = new WeakReference<DialogPane>(dialogPane);
        boolean bl = this.hasCustomButtons = buttonTypeArray != null && buttonTypeArray.length > 0;
        if (this.hasCustomButtons) {
            for (ButtonType buttonType : buttonTypeArray) {
                dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{buttonType});
            }
        }
        this.setAlertType(alertType);
        this.dialogPaneProperty().addListener(observable -> this.updateListeners());
        this.titleProperty().addListener(this.titleListener);
        this.updateListeners();
    }

    public final AlertType getAlertType() {
        return (AlertType)((Object)this.alertType.get());
    }

    public final void setAlertType(AlertType alertType) {
        this.alertType.setValue((Object)alertType);
    }

    public final ObjectProperty<AlertType> alertTypeProperty() {
        return this.alertType;
    }

    public final ObservableList<ButtonType> getButtonTypes() {
        return this.getDialogPane().getButtonTypes();
    }

    private void updateListeners() {
        DialogPane dialogPane;
        DialogPane dialogPane2 = (DialogPane)((Object)this.dialogPaneRef.get());
        if (dialogPane2 != null) {
            dialogPane2.headerTextProperty().removeListener(this.headerTextListener);
            dialogPane2.getButtonTypes().removeListener(this.buttonsListener);
        }
        if ((dialogPane = this.getDialogPane()) != null) {
            dialogPane.headerTextProperty().addListener(this.headerTextListener);
            dialogPane.getButtonTypes().addListener(this.buttonsListener);
        }
        this.dialogPaneRef = new WeakReference<DialogPane>(dialogPane);
    }

    public static enum AlertType {
        NONE,
        INFORMATION,
        WARNING,
        CONFIRMATION,
        ERROR;

    }
}

