/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.control.Logging;
import com.sun.javafx.scene.layout.PaneHelper;
import com.sun.javafx.stage.PopupWindowHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.application.Application;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.CssParser;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.css.converter.StringConverter;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.layout.Pane;
import javafx.stage.PopupWindow;
import javafx.stage.Window;

public class PopupControl
extends PopupWindow
implements Skinnable,
Styleable {
    public static final double USE_PREF_SIZE = Double.NEGATIVE_INFINITY;
    public static final double USE_COMPUTED_SIZE = -1.0;
    protected CSSBridge bridge;
    private final ObjectProperty<Skin<?>> skin = new ObjectPropertyBase<Skin<?>>(this){
        private Skin<?> oldValue;
        final /* synthetic */ PopupControl this$0;
        {
            PopupControl popupControl2 = popupControl;
            Objects.requireNonNull(popupControl2);
            this.this$0 = popupControl2;
        }

        protected void invalidated() {
            Skin skin = (Skin)this.get();
            this.this$0.currentSkinClassName = skin == null ? null : skin.getClass().getName();
            this.this$0.skinClassNameProperty().set((Object)this.this$0.currentSkinClassName);
            if (this.oldValue != null) {
                this.oldValue.dispose();
            }
            this.oldValue = (Skin)this.getValue();
            this.this$0.prefWidthCache = -1.0;
            this.this$0.prefHeightCache = -1.0;
            this.this$0.minWidthCache = -1.0;
            this.this$0.minHeightCache = -1.0;
            this.this$0.maxWidthCache = -1.0;
            this.this$0.maxHeightCache = -1.0;
            this.this$0.skinSizeComputed = false;
            Node node = this.this$0.getSkinNode();
            if (node != null) {
                this.this$0.bridge.getChildren().setAll((Object[])new Node[]{node});
            } else {
                this.this$0.bridge.getChildren().clear();
            }
            if (skin != null) {
                skin.install();
            }
            NodeHelper.reapplyCSS((Node)this.this$0.bridge);
            PlatformLogger platformLogger = Logging.getControlsLogger();
            if (platformLogger.isLoggable(PlatformLogger.Level.FINEST)) {
                platformLogger.finest("Stored skin[" + String.valueOf(this.getValue()) + "] on " + String.valueOf((Object)this));
            }
        }

        public Object getBean() {
            return this.this$0;
        }

        public String getName() {
            return "skin";
        }
    };
    private String currentSkinClassName = null;
    private StringProperty skinClassName = null;
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    private double prefWidthCache = -1.0;
    private double prefHeightCache = -1.0;
    private double minWidthCache = -1.0;
    private double minHeightCache = -1.0;
    private double maxWidthCache = -1.0;
    private double maxHeightCache = -1.0;
    private boolean skinSizeComputed = false;
    private static final CssMetaData<CSSBridge, String> SKIN;
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public PopupControl() {
        this.bridge = new CSSBridge(this);
        this.setAnchorLocation(PopupWindow.AnchorLocation.CONTENT_TOP_LEFT);
        PopupWindowHelper.getContent((PopupWindow)this).add((Object)this.bridge);
    }

    public final StringProperty idProperty() {
        return this.bridge.idProperty();
    }

    public final void setId(String string) {
        this.idProperty().set((Object)string);
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final ObservableList<String> getStyleClass() {
        return this.bridge.getStyleClass();
    }

    public final void setStyle(String string) {
        this.styleProperty().set((Object)string);
    }

    public final String getStyle() {
        return (String)this.styleProperty().get();
    }

    public final StringProperty styleProperty() {
        return this.bridge.styleProperty();
    }

    @Override
    public final ObjectProperty<Skin<?>> skinProperty() {
        return this.skin;
    }

    @Override
    public final void setSkin(Skin<?> skin) {
        this.skinProperty().setValue(skin);
    }

    @Override
    public final Skin<?> getSkin() {
        return (Skin)this.skinProperty().getValue();
    }

    private StringProperty skinClassNameProperty() {
        if (this.skinClassName == null) {
            this.skinClassName = new StyleableStringProperty(this){
                final /* synthetic */ PopupControl this$0;
                {
                    PopupControl popupControl2 = popupControl;
                    Objects.requireNonNull(popupControl2);
                    this.this$0 = popupControl2;
                }

                public void set(String string) {
                    if (string == null || string.isEmpty() || string.equals(this.get())) {
                        return;
                    }
                    super.set(string);
                }

                public void invalidated() {
                    if (this.get() != null && !this.get().equals(this.this$0.currentSkinClassName)) {
                        Control.loadSkinClass(this.this$0, this.get());
                    }
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "skinClassName";
                }

                public CssMetaData<CSSBridge, String> getCssMetaData() {
                    return SKIN;
                }
            };
        }
        return this.skinClassName;
    }

    private Node getSkinNode() {
        return this.getSkin() == null ? null : this.getSkin().getNode();
    }

    public final void setMinWidth(double d) {
        this.minWidthProperty().set(d);
    }

    public final double getMinWidth() {
        return this.minWidth == null ? -1.0 : this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new DoublePropertyBase(this, -1.0){
                final /* synthetic */ PopupControl this$0;
                {
                    PopupControl popupControl2 = popupControl;
                    Objects.requireNonNull(popupControl2);
                    this.this$0 = popupControl2;
                    super(d);
                }

                public void invalidated() {
                    if (this.this$0.isShowing()) {
                        this.this$0.bridge.requestLayout();
                    }
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinHeight(double d) {
        this.minHeightProperty().set(d);
    }

    public final double getMinHeight() {
        return this.minHeight == null ? -1.0 : this.minHeight.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new DoublePropertyBase(this, -1.0){
                final /* synthetic */ PopupControl this$0;
                {
                    PopupControl popupControl2 = popupControl;
                    Objects.requireNonNull(popupControl2);
                    this.this$0 = popupControl2;
                    super(d);
                }

                public void invalidated() {
                    if (this.this$0.isShowing()) {
                        this.this$0.bridge.requestLayout();
                    }
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public void setMinSize(double d, double d2) {
        this.setMinWidth(d);
        this.setMinHeight(d2);
    }

    public final void setPrefWidth(double d) {
        this.prefWidthProperty().set(d);
    }

    public final double getPrefWidth() {
        return this.prefWidth == null ? -1.0 : this.prefWidth.get();
    }

    public final DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new DoublePropertyBase(this, -1.0){
                final /* synthetic */ PopupControl this$0;
                {
                    PopupControl popupControl2 = popupControl;
                    Objects.requireNonNull(popupControl2);
                    this.this$0 = popupControl2;
                    super(d);
                }

                public void invalidated() {
                    if (this.this$0.isShowing()) {
                        this.this$0.bridge.requestLayout();
                    }
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "prefWidth";
                }
            };
        }
        return this.prefWidth;
    }

    public final void setPrefHeight(double d) {
        this.prefHeightProperty().set(d);
    }

    public final double getPrefHeight() {
        return this.prefHeight == null ? -1.0 : this.prefHeight.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new DoublePropertyBase(this, -1.0){
                final /* synthetic */ PopupControl this$0;
                {
                    PopupControl popupControl2 = popupControl;
                    Objects.requireNonNull(popupControl2);
                    this.this$0 = popupControl2;
                    super(d);
                }

                public void invalidated() {
                    if (this.this$0.isShowing()) {
                        this.this$0.bridge.requestLayout();
                    }
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public void setPrefSize(double d, double d2) {
        this.setPrefWidth(d);
        this.setPrefHeight(d2);
    }

    public final void setMaxWidth(double d) {
        this.maxWidthProperty().set(d);
    }

    public final double getMaxWidth() {
        return this.maxWidth == null ? -1.0 : this.maxWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new DoublePropertyBase(this, -1.0){
                final /* synthetic */ PopupControl this$0;
                {
                    PopupControl popupControl2 = popupControl;
                    Objects.requireNonNull(popupControl2);
                    this.this$0 = popupControl2;
                    super(d);
                }

                public void invalidated() {
                    if (this.this$0.isShowing()) {
                        this.this$0.bridge.requestLayout();
                    }
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxHeight(double d) {
        this.maxHeightProperty().set(d);
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? -1.0 : this.maxHeight.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new DoublePropertyBase(this, -1.0){
                final /* synthetic */ PopupControl this$0;
                {
                    PopupControl popupControl2 = popupControl;
                    Objects.requireNonNull(popupControl2);
                    this.this$0 = popupControl2;
                    super(d);
                }

                public void invalidated() {
                    if (this.this$0.isShowing()) {
                        this.this$0.bridge.requestLayout();
                    }
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public void setMaxSize(double d, double d2) {
        this.setMaxWidth(d);
        this.setMaxHeight(d2);
    }

    public final double minWidth(double d) {
        double d2 = this.getMinWidth();
        if (d2 == -1.0) {
            if (this.minWidthCache == -1.0) {
                this.minWidthCache = this.recalculateMinWidth(d);
            }
            return this.minWidthCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    public final double minHeight(double d) {
        double d2 = this.getMinHeight();
        if (d2 == -1.0) {
            if (this.minHeightCache == -1.0) {
                this.minHeightCache = this.recalculateMinHeight(d);
            }
            return this.minHeightCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    public final double prefWidth(double d) {
        double d2 = this.getPrefWidth();
        if (d2 == -1.0) {
            if (this.prefWidthCache == -1.0) {
                this.prefWidthCache = this.recalculatePrefWidth(d);
            }
            return this.prefWidthCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    public final double prefHeight(double d) {
        double d2 = this.getPrefHeight();
        if (d2 == -1.0) {
            if (this.prefHeightCache == -1.0) {
                this.prefHeightCache = this.recalculatePrefHeight(d);
            }
            return this.prefHeightCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    public final double maxWidth(double d) {
        double d2 = this.getMaxWidth();
        if (d2 == -1.0) {
            if (this.maxWidthCache == -1.0) {
                this.maxWidthCache = this.recalculateMaxWidth(d);
            }
            return this.maxWidthCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    public final double maxHeight(double d) {
        double d2 = this.getMaxHeight();
        if (d2 == -1.0) {
            if (this.maxHeightCache == -1.0) {
                this.maxHeightCache = this.recalculateMaxHeight(d);
            }
            return this.maxHeightCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    private double recalculateMinWidth(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().minWidth(d);
    }

    private double recalculateMinHeight(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().minHeight(d);
    }

    private double recalculateMaxWidth(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().maxWidth(d);
    }

    private double recalculateMaxHeight(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().maxHeight(d);
    }

    private double recalculatePrefWidth(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().prefWidth(d);
    }

    private double recalculatePrefHeight(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().prefHeight(d);
    }

    private void recomputeSkinSize() {
        if (!this.skinSizeComputed) {
            this.bridge.applyCss();
            this.skinSizeComputed = true;
        }
    }

    protected Skin<?> createDefaultSkin() {
        return null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return PopupControl.getClassCssMetaData();
    }

    public final void pseudoClassStateChanged(PseudoClass pseudoClass, boolean bl) {
        this.bridge.pseudoClassStateChanged(pseudoClass, bl);
    }

    public String getTypeSelector() {
        return "PopupControl";
    }

    public Styleable getStyleableParent() {
        Scene scene;
        Node node = this.getOwnerNode();
        if (node != null) {
            return node;
        }
        Window window = this.getOwnerWindow();
        if (window != null && (scene = window.getScene()) != null) {
            return scene.getRoot();
        }
        return this.bridge.getParent();
    }

    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return FXCollections.emptyObservableSet();
    }

    public Node getStyleableNode() {
        return this.bridge;
    }

    static {
        if (Application.getUserAgentStylesheet() == null) {
            PlatformImpl.setDefaultPlatformUserAgentStylesheet();
        }
        SKIN = new CssMetaData<CSSBridge, String>("-fx-skin", StringConverter.getInstance()){

            public boolean isSettable(CSSBridge cSSBridge) {
                return !cSSBridge.popupControl.skinProperty().isBound();
            }

            public StyleableProperty<String> getStyleableProperty(CSSBridge cSSBridge) {
                return (StyleableProperty)cSSBridge.popupControl.skinClassNameProperty();
            }
        };
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, SKIN);
        STYLEABLES = Collections.unmodifiableList(arrayList);
    }

    protected class CSSBridge
    extends Pane {
        private final PopupControl popupControl;
        final /* synthetic */ PopupControl this$0;

        protected CSSBridge(PopupControl popupControl) {
            PopupControl popupControl2 = popupControl;
            Objects.requireNonNull(popupControl2);
            this.this$0 = popupControl2;
            this.popupControl = this.this$0;
            CSSBridgeHelper.initHelper(this);
        }

        public void requestLayout() {
            this.this$0.prefWidthCache = -1.0;
            this.this$0.prefHeightCache = -1.0;
            this.this$0.minWidthCache = -1.0;
            this.this$0.minHeightCache = -1.0;
            this.this$0.maxWidthCache = -1.0;
            this.this$0.maxHeightCache = -1.0;
            super.requestLayout();
        }

        public Styleable getStyleableParent() {
            return this.this$0.getStyleableParent();
        }

        public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
            return this.this$0.getCssMetaData();
        }

        private List<String> doGetAllParentStylesheets() {
            Styleable styleable = this.getStyleableParent();
            if (styleable instanceof Parent) {
                return ParentHelper.getAllParentStylesheets((Parent)((Parent)styleable));
            }
            return null;
        }

        private void doProcessCSS() {
            CSSBridgeHelper.superProcessCSS((Node)this);
            if (this.this$0.getSkin() == null) {
                Skin<?> skin = this.this$0.createDefaultSkin();
                if (skin != null) {
                    this.this$0.skinProperty().set(skin);
                    CSSBridgeHelper.superProcessCSS((Node)this);
                } else {
                    String string = "The -fx-skin property has not been defined in CSS for " + String.valueOf((Object)this) + " and createDefaultSkin() returned null.";
                    ObservableList observableList = StyleManager.getErrors();
                    if (observableList != null) {
                        CssParser.ParseError parseError = new CssParser.ParseError(string);
                        observableList.add(parseError);
                    }
                    Logging.getControlsLogger().severe(string);
                }
            }
        }
    }

    static final class CSSBridgeHelper
    extends PaneHelper {
        private static final CSSBridgeHelper theInstance = new CSSBridgeHelper();

        CSSBridgeHelper() {
        }

        private static CSSBridgeHelper getInstance() {
            return theInstance;
        }

        public static void initHelper(CSSBridge cSSBridge) {
            CSSBridgeHelper.setHelper((Node)cSSBridge, (NodeHelper)CSSBridgeHelper.getInstance());
        }

        public static void superProcessCSS(Node node) {
            ((CSSBridgeHelper)CSSBridgeHelper.getHelper((Node)node)).superProcessCSSImpl(node);
        }

        void superProcessCSSImpl(Node node) {
            super.processCSSImpl(node);
        }

        protected void processCSSImpl(Node node) {
            ((CSSBridge)node).doProcessCSS();
        }

        protected List<String> getAllParentStylesheetsImpl(Parent parent) {
            return ((CSSBridge)parent).doGetAllParentStylesheets();
        }
    }
}

