/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.async;

import com.sun.javafx.runtime.async.AbstractAsyncOperation;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Objects;

public abstract class AbstractRemoteResource<T>
extends AbstractAsyncOperation<T> {
    private final SizedStreamSupplier sizedStreamSupplier;

    protected AbstractRemoteResource(SizedStreamSupplier sizedStreamSupplier, AsyncOperationListener<T> asyncOperationListener) {
        super(asyncOperationListener);
        this.sizedStreamSupplier = Objects.requireNonNull(sizedStreamSupplier, "sizedStreamSupplier");
    }

    protected abstract T processStream(InputStream var1);

    @Override
    public T call() throws IOException {
        SizedStream sizedStream = this.sizedStreamSupplier.get();
        this.setProgressMax(sizedStream.size);
        try (ProgressInputStream progressInputStream = new ProgressInputStream(this, sizedStream.stream);){
            T t = this.processStream(progressInputStream);
            return t;
        }
    }

    public static interface SizedStreamSupplier {
        public SizedStream get() throws IOException;
    }

    public record SizedStream(InputStream stream, long size) {
    }

    protected class ProgressInputStream
    extends BufferedInputStream {
        final /* synthetic */ AbstractRemoteResource this$0;

        public ProgressInputStream(AbstractRemoteResource abstractRemoteResource, InputStream inputStream) {
            AbstractRemoteResource abstractRemoteResource2 = abstractRemoteResource;
            Objects.requireNonNull(abstractRemoteResource2);
            this.this$0 = abstractRemoteResource2;
            super(inputStream);
        }

        @Override
        public synchronized int read() throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int n = super.read();
            this.this$0.addProgress(1);
            return n;
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int n3 = super.read(byArray, n, n2);
            this.this$0.addProgress(n3);
            return n3;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int n = super.read(byArray);
            this.this$0.addProgress(n);
            return n;
        }
    }
}

