/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import com.sun.javafx.binding.BindingHelperObserver;
import com.sun.javafx.binding.MapExpressionHelper;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.MapExpression;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;

public abstract class MapBinding<K, V>
extends MapExpression<K, V>
implements Binding<ObservableMap<K, V>> {
    private final MapChangeListener<K, V> mapChangeListener = new MapChangeListener<K, V>(this){
        final /* synthetic */ MapBinding this$0;
        {
            MapBinding mapBinding2 = mapBinding;
            Objects.requireNonNull(mapBinding2);
            this.this$0 = mapBinding2;
        }

        @Override
        public void onChanged(MapChangeListener.Change<? extends K, ? extends V> change) {
            this.this$0.invalidateProperties();
            this.this$0.onInvalidating();
            MapExpressionHelper.fireValueChangedEvent(this.this$0.helper, change);
        }
    };
    private ObservableMap<K, V> value;
    private boolean valid = false;
    private BindingHelperObserver observer;
    private MapExpressionHelper<K, V> helper = null;
    private SizeProperty size0;
    private EmptyProperty empty0;

    @Override
    public ReadOnlyIntegerProperty sizeProperty() {
        if (this.size0 == null) {
            this.size0 = new SizeProperty(this);
        }
        return this.size0;
    }

    @Override
    public ReadOnlyBooleanProperty emptyProperty() {
        if (this.empty0 == null) {
            this.empty0 = new EmptyProperty(this);
        }
        return this.empty0;
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.helper = MapExpressionHelper.addListener(this.helper, this, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.helper = MapExpressionHelper.removeListener(this.helper, invalidationListener);
    }

    @Override
    public void addListener(ChangeListener<? super ObservableMap<K, V>> changeListener) {
        this.helper = MapExpressionHelper.addListener(this.helper, this, changeListener);
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableMap<K, V>> changeListener) {
        this.helper = MapExpressionHelper.removeListener(this.helper, changeListener);
    }

    @Override
    public void addListener(MapChangeListener<? super K, ? super V> mapChangeListener) {
        this.helper = MapExpressionHelper.addListener(this.helper, this, mapChangeListener);
    }

    @Override
    public void removeListener(MapChangeListener<? super K, ? super V> mapChangeListener) {
        this.helper = MapExpressionHelper.removeListener(this.helper, mapChangeListener);
    }

    protected final void bind(Observable ... observableArray) {
        if (observableArray != null && observableArray.length > 0) {
            if (this.observer == null) {
                this.observer = new BindingHelperObserver(this);
            }
            for (Observable observable : observableArray) {
                if (observable == null) continue;
                observable.addListener(this.observer);
            }
        }
    }

    protected final void unbind(Observable ... observableArray) {
        if (this.observer != null) {
            for (Observable observable : observableArray) {
                if (observable == null) continue;
                observable.removeListener(this.observer);
            }
            this.observer = null;
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public ObservableList<?> getDependencies() {
        return FXCollections.emptyObservableList();
    }

    @Override
    public final ObservableMap<K, V> get() {
        if (!this.valid) {
            this.value = this.computeValue();
            this.valid = true;
            if (this.value != null) {
                this.value.addListener(this.mapChangeListener);
            }
        }
        return this.value;
    }

    protected void onInvalidating() {
    }

    private void invalidateProperties() {
        if (this.size0 != null) {
            this.size0.fireValueChangedEvent();
        }
        if (this.empty0 != null) {
            this.empty0.fireValueChangedEvent();
        }
    }

    @Override
    public final void invalidate() {
        if (this.valid) {
            if (this.value != null) {
                this.value.removeListener(this.mapChangeListener);
            }
            this.valid = false;
            this.invalidateProperties();
            this.onInvalidating();
            MapExpressionHelper.fireValueChangedEvent(this.helper);
        }
    }

    @Override
    public final boolean isValid() {
        return this.valid;
    }

    protected abstract ObservableMap<K, V> computeValue();

    public String toString() {
        return this.valid ? "MapBinding [value: " + String.valueOf(this.get()) + "]" : "MapBinding [invalid]";
    }

    private class SizeProperty
    extends ReadOnlyIntegerPropertyBase {
        final /* synthetic */ MapBinding this$0;

        private SizeProperty(MapBinding mapBinding) {
            MapBinding mapBinding2 = mapBinding;
            Objects.requireNonNull(mapBinding2);
            this.this$0 = mapBinding2;
        }

        @Override
        public int get() {
            return this.this$0.size();
        }

        @Override
        public Object getBean() {
            return this.this$0;
        }

        @Override
        public String getName() {
            return "size";
        }

        @Override
        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }

    private class EmptyProperty
    extends ReadOnlyBooleanPropertyBase {
        final /* synthetic */ MapBinding this$0;

        private EmptyProperty(MapBinding mapBinding) {
            MapBinding mapBinding2 = mapBinding;
            Objects.requireNonNull(mapBinding2);
            this.this$0 = mapBinding2;
        }

        @Override
        public boolean get() {
            return this.this$0.isEmpty();
        }

        @Override
        public Object getBean() {
            return this.this$0;
        }

        @Override
        public String getName() {
            return "empty";
        }

        @Override
        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }
}

