/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.CachingStyleResolver;
import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledOutput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;

public class RtfStyledOutput
implements StyledOutput {
    private final LookupTable<Color> colorTable = new LookupTable<Color>(Color.BLACK);
    private final LookupTable<String> fontTable = new LookupTable<String>("system");
    private final StyleResolver resolver;
    private final Writer writer;
    private boolean startOfLine = true;
    private StyleAttributeMap prevStyle;
    private Color color;
    private Color background;
    private boolean bold;
    private boolean italic;
    private boolean under;
    private boolean strike;
    private String fontFamily;
    private Double fontSize;

    public RtfStyledOutput(StyleResolver styleResolver, Writer writer) {
        this.resolver = new CachingStyleResolver(styleResolver);
        this.writer = writer;
    }

    public StyledOutput firstPassBuilder() {
        return new StyledOutput(this){
            final /* synthetic */ RtfStyledOutput this$0;
            {
                RtfStyledOutput rtfStyledOutput2 = rtfStyledOutput;
                Objects.requireNonNull(rtfStyledOutput2);
                this.this$0 = rtfStyledOutput2;
            }

            @Override
            public void consume(StyledSegment styledSegment) throws IOException {
                switch (styledSegment.getType()) {
                    case PARAGRAPH_ATTRIBUTES: {
                        break;
                    }
                    case TEXT: {
                        StyleAttributeMap styleAttributeMap = styledSegment.getStyleAttributeMap(this.this$0.resolver);
                        if (styleAttributeMap == null) break;
                        Color color = RtfStyledOutput.getTextColor(styleAttributeMap);
                        this.this$0.colorTable.add(color);
                        String string = styleAttributeMap.getFontFamily();
                        if (string == null) break;
                        this.this$0.fontTable.add(string);
                    }
                }
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    private String lookupFontFamily(String string) {
        try {
            switch (string.toLowerCase()) {
                case "monospaced": {
                    return "\\fmodern Courier New";
                }
                case "system": 
                case "sans-serif": {
                    return "\\fswiss Helvetica";
                }
                case "serif": {
                    return "\\froman Times New Roman";
                }
                case "cursive": {
                    return "\\fscript Brush Script";
                }
                case "fantasy": {
                    return "\\fdecor ITC Zapf Chancery";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void writePrologue() throws IOException {
        this.write("{\\rtf1\\ansi\\ansicpg1252\\uc1\\sl0\\sb0\\sa0\\deff0");
        this.write("{\\fonttbl");
        int n = 0;
        for (String string : this.fontTable.getItems()) {
            String string2 = this.lookupFontFamily(string);
            this.write("\\f");
            this.write(String.valueOf(n++));
            if (string2 == null) {
                this.write("\\fnil");
                this.write(" ");
                this.write(string);
            } else {
                this.write(string2);
            }
            this.write(";");
        }
        this.write("}\r\n");
        this.write("{\\colortbl ;");
        for (Color color : this.colorTable.getItems()) {
            this.write("\\red");
            this.write(RtfStyledOutput.toInt255(color.getRed()));
            this.write("\\green");
            this.write(RtfStyledOutput.toInt255(color.getGreen()));
            this.write("\\blue");
            this.write(RtfStyledOutput.toInt255(color.getBlue()));
            this.write(";");
        }
        this.write("}\r\n");
    }

    @Override
    public void consume(StyledSegment styledSegment) throws IOException {
        switch (styledSegment.getType()) {
            case LINE_BREAK: {
                this.writeEndOfLine();
                this.writeNewLine();
                break;
            }
            case PARAGRAPH_ATTRIBUTES: {
                break;
            }
            case REGION: {
                Node node = (Node)styledSegment.getParagraphNodeGenerator().get();
                this.writeParagraph(node);
                this.writeNewLine();
                break;
            }
            case TEXT: {
                this.writeTextSegment(styledSegment);
            }
        }
    }

    public void writeEpilogue() throws IOException {
        this.writeEndOfLine();
        this.write("\r\n}\r\n");
    }

    private void writeEndOfLine() throws IOException {
        if (this.color != null) {
            this.write("\\cf0 ");
            this.color = null;
        }
        if (this.background != null) {
            this.write("\\highlight0 ");
            this.background = null;
        }
        if (this.bold) {
            this.write("\\b0 ");
            this.bold = false;
        }
        if (this.italic) {
            this.write("\\i0 ");
            this.italic = false;
        }
        if (this.under) {
            this.write("\\ul0 ");
            this.under = false;
        }
        if (this.strike) {
            this.write("\\strike0 ");
            this.strike = false;
        }
    }

    private void writeNewLine() throws IOException {
        this.write("\\par\r\n");
        this.startOfLine = true;
    }

    private void writeTextSegment(StyledSegment styledSegment) throws IOException {
        String string;
        Object object;
        StyleAttributeMap styleAttributeMap;
        RtfStyledOutput.checkCancelled();
        if (this.startOfLine) {
            this.write("\\fi0\\ql ");
            this.prevStyle = null;
            this.startOfLine = false;
        }
        if (RichUtils.notEquals(styleAttributeMap = styledSegment.getStyleAttributeMap(this.resolver), this.prevStyle) || RichUtils.notEquals(RtfStyledOutput.getTextColor(styleAttributeMap), RtfStyledOutput.getTextColor(this.prevStyle))) {
            int n;
            Double d;
            String string2;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            if (styleAttributeMap == null) {
                object = null;
                string = null;
                bl4 = false;
                bl3 = false;
                bl2 = false;
                bl = false;
                string2 = null;
                d = null;
            } else {
                object = RtfStyledOutput.getTextColor(styleAttributeMap);
                string = null;
                bl4 = styleAttributeMap.isBold();
                bl3 = styleAttributeMap.isItalic();
                bl2 = styleAttributeMap.isUnderline();
                bl = styleAttributeMap.isStrikeThrough();
                string2 = styleAttributeMap.getFontFamily();
                d = styleAttributeMap.getFontSize();
            }
            this.prevStyle = styleAttributeMap;
            if (RichUtils.notEquals(this.fontFamily, string2)) {
                n = this.fontTable.getIndexFor(string2);
                this.write("\\f");
                this.write(String.valueOf(n));
                this.fontFamily = string2;
            }
            if (RichUtils.notEquals(this.fontSize, d)) {
                this.write("\\fs");
                double d2 = d == null ? 24.0 : d * 2.0;
                this.write(String.valueOf((int)Math.round(d2)));
                this.fontSize = d;
            }
            if (RichUtils.notEquals(object, this.color)) {
                if (object == null) {
                    this.write("\\cf0 ");
                } else {
                    n = this.colorTable.getIndexFor((Color)object);
                    if (n > 0) {
                        ++n;
                    }
                    this.write("\\cf");
                    this.write(String.valueOf(n));
                    this.write(" ");
                }
                this.color = object;
            }
            if (RichUtils.notEquals(string, this.background)) {
                if (string == null) {
                    this.write("\\highlight0 ");
                } else {
                    n = this.colorTable.getIndexFor((Color)string);
                    if (n > 0) {
                        ++n;
                    }
                    this.write("\\highlight");
                    this.write(String.valueOf(n));
                    this.write(" ");
                }
                this.background = string;
            }
            if (bl4 != this.bold) {
                this.write(bl4 ? "\\b " : "\\b0 ");
                this.bold = bl4;
            }
            if (bl3 != this.italic) {
                this.write(bl3 ? "\\i " : "\\i0 ");
                this.italic = bl3;
            }
            if (bl2 != this.under) {
                this.write(bl2 ? "\\ul " : "\\ul0 ");
                this.under = bl2;
            }
            if (bl != this.strike) {
                this.write(bl ? "\\strike " : "\\strike0 ");
                this.strike = bl;
            }
        }
        object = styledSegment.getText();
        string = RtfStyledOutput.encode((String)object);
        this.write(string);
    }

    private void writeParagraph(Node node) throws IOException {
        WritableImage writableImage = this.resolver.snapshot(node);
        byte[] byArray = RichUtils.writePNG((Image)writableImage);
        int n = (int)writableImage.getWidth();
        int n2 = (int)writableImage.getHeight();
        this.write("{\\*\\shppict {\\pict \\pngblip");
        this.write("\\picscalex100\\picscaley100\\piccropl10\\piccropr0\\piccropt0\\piccropb0");
        this.write("\\picw");
        this.write(String.valueOf(n));
        this.write("\\pich");
        this.write(String.valueOf(n2));
        this.write("\\picwgoal");
        int n3 = 864;
        this.write(String.valueOf(n3));
        int n4 = n2 * n3 / n;
        this.write("\\pichgoal");
        this.write(String.valueOf(n4));
        this.write("\r\n");
        StringBuilder stringBuilder = new StringBuilder(2);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            RtfStyledOutput.hex2(stringBuilder, by);
            this.write(stringBuilder.toString());
            if (i % 80 != 79) continue;
            this.write("\r\n");
        }
        this.write("\r\n}}\r\n");
    }

    private static void hex2(StringBuilder stringBuilder, byte by) {
        stringBuilder.setLength(0);
        String string = "0123456789abcdef";
        stringBuilder.append(string.charAt(by >> 4 & 0xF));
        stringBuilder.append(string.charAt(by & 0xF));
    }

    private static String encode(String string) {
        if (string == null) {
            return "";
        }
        int n = RtfStyledOutput.indexOfSpecialChar(string);
        if (n < 0) {
            return string;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 32);
        stringBuilder.append(string, 0, n);
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    case '\t': {
                        stringBuilder.append(c);
                    }
                }
                continue;
            }
            if (c < '\u0080') {
                switch (c) {
                    case '\\': {
                        stringBuilder.append("\\\\");
                        break;
                    }
                    case '{': {
                        stringBuilder.append("\\{");
                        break;
                    }
                    case '}': {
                        stringBuilder.append("\\}");
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                        break;
                    }
                }
                continue;
            }
            stringBuilder.append("\\u");
            stringBuilder.append(String.valueOf((short)c));
            stringBuilder.append("?");
        }
        return stringBuilder.toString();
    }

    private static int indexOfSpecialChar(String string) {
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                switch (c) {
                    case '\t': {
                        continue block6;
                    }
                    default: {
                        return i;
                    }
                }
            }
            if (c < '\u0080') {
                switch (c) {
                    case '\\': 
                    case '{': 
                    case '}': {
                        return i;
                    }
                }
                continue;
            }
            return i;
        }
        return -1;
    }

    private static String toInt255(double d) {
        int n = (int)Math.round(255.0 * d);
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return String.valueOf(n);
    }

    private static void checkCancelled() throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            throw new IOException(new InterruptedException());
        }
    }

    private void write(String string) throws IOException {
        this.writer.write(string);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static Color getTextColor(StyleAttributeMap styleAttributeMap) {
        Color color;
        if (styleAttributeMap != null && (color = styleAttributeMap.getTextColor()) != null) {
            return color;
        }
        return Color.BLACK;
    }

    protected static class LookupTable<T> {
        private final ArrayList<T> items = new ArrayList();
        private final HashMap<T, Integer> indexes = new HashMap();

        public LookupTable(T t) {
            if (t != null) {
                this.add(t);
            }
        }

        public void add(T t) {
            if (!this.indexes.containsKey(t)) {
                Integer n = this.items.size();
                this.items.add(t);
                this.indexes.put(t, n);
            }
        }

        public int getIndexFor(T t) {
            Integer n = this.indexes.get(t);
            if (n == null) {
                return 0;
            }
            return n;
        }

        public List<T> getItems() {
            return this.items;
        }
    }
}

