/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.FxPathBuilder;
import com.sun.jfx.incubator.scene.control.richtext.HighlightShape;
import com.sun.jfx.incubator.scene.control.richtext.RangeInfo;
import com.sun.jfx.incubator.scene.control.richtext.VFlow;
import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public final class TextCell
extends BorderPane {
    private final int index;
    private final Region content;
    private double width;
    private double height;
    private double y;
    private boolean embedsNode;

    public TextCell(int n, Region region, boolean bl) {
        Objects.nonNull(region);
        this.index = n;
        this.content = region;
        this.embedsNode = bl;
        this.setManaged(false);
        this.setCenter((Node)region);
    }

    public TextCell(int n) {
        this(n, (Region)TextCell.textFlow(), false);
    }

    private static TextFlow textFlow() {
        TextFlow textFlow = new TextFlow();
        textFlow.setMinHeight(0.0);
        return textFlow;
    }

    public final Region getContent() {
        return this.content;
    }

    public void add(Node node) {
        this.flow().getChildren().add((Object)node);
        this.embedsNode = true;
    }

    public void addTextSegment(Text text) {
        this.flow().getChildren().add((Object)text);
    }

    public final int getIndex() {
        return this.index;
    }

    public int getTextLength() {
        Region region = this.content;
        if (region instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region;
            return RichUtils.getTextLength(textFlow);
        }
        return 0;
    }

    private TextFlow flow() {
        Region region = this.content;
        if (region instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region;
            return textFlow;
        }
        throw new IllegalArgumentException("Not a TextFlow: " + String.valueOf(this.content.getClass()));
    }

    void setPosition(double d, double d2) {
        this.y = d;
        this.height = d2;
    }

    public double getY() {
        return this.y;
    }

    public double getCellHeight() {
        return this.height;
    }

    public void setCellWidth(double d) {
        this.width = d;
    }

    public double getCellWidth() {
        return this.width;
    }

    public void addBoxOutline(FxPathBuilder fxPathBuilder, double d, double d2, double d3) {
        double d4 = this.getLayoutY();
        double d5 = d4 + d3;
        fxPathBuilder.moveto(d, d4);
        fxPathBuilder.lineto(d2, d4);
        fxPathBuilder.lineto(d2, d5);
        fxPathBuilder.lineto(d, d5);
        fxPathBuilder.lineto(d, d4);
    }

    public PathElement[] getCaretShape(Region region, int n, boolean bl) {
        PathElement[] pathElementArray;
        Region region2 = this.content;
        if (region2 instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region2;
            pathElementArray = textFlow.getCaretShape(n, bl);
            if (pathElementArray.length == 2) {
                region2 = pathElementArray[0];
                PathElement pathElement = pathElementArray[1];
                if (region2 instanceof MoveTo) {
                    MoveTo moveTo = (MoveTo)region2;
                    if (pathElement instanceof LineTo) {
                        LineTo lineTo = (LineTo)pathElement;
                        if (Math.abs(moveTo.getY() - lineTo.getY()) < 0.01) {
                            double d = moveTo.getX();
                            double d2 = moveTo.getY();
                            pathElementArray[1] = new LineTo(d, d2 + textFlow.getHeight());
                        }
                    }
                }
            }
        } else {
            pathElementArray = new PathElement[]{new MoveTo(0.0, 0.0), new LineTo(0.0, this.content.getHeight())};
        }
        return RichUtils.translatePath(region, this.content, pathElementArray);
    }

    public PathElement[] getUnderlineShape(Region region, int n, int n2) {
        PathElement[] pathElementArray;
        Region region2 = this.content;
        if (region2 instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region2;
            pathElementArray = textFlow.getUnderlineShape(n, n2);
        } else {
            double d = this.getWidth();
            double d2 = this.getHeight();
            pathElementArray = new PathElement[]{new MoveTo(0.0, d2), new LineTo(d, d2)};
        }
        return RichUtils.translatePath(region, this.content, pathElementArray);
    }

    public PathElement[] getRangeShape(Region region, int n, int n2) {
        PathElement[] pathElementArray;
        Region region2 = this.content;
        if (region2 instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region2;
            pathElementArray = textFlow.getRangeShape(n, n2, true);
            if (pathElementArray.length == 0) {
                pathElementArray = new PathElement[]{new MoveTo(0.0, 0.0), new LineTo(0.0, textFlow.getHeight())};
            }
        } else {
            double d = this.getWidth();
            double d2 = this.getHeight();
            pathElementArray = new PathElement[]{new MoveTo(0.0, 0.0), new LineTo(d, 0.0), new LineTo(d, d2), new LineTo(0.0, d2), new LineTo(0.0, 0.0)};
        }
        return RichUtils.translatePath(region, this.content, pathElementArray);
    }

    public void addHighlight(int n, int n2, Color color) {
        HighlightShape.addTo(this.content, HighlightShape.Type.HIGHLIGHT, n, n2, color);
    }

    public void addHighlight(int n, int n2, String ... stringArray) {
        HighlightShape.addTo(this.content, HighlightShape.Type.HIGHLIGHT, n, n2, stringArray);
    }

    public void addSquiggly(int n, int n2, Color color) {
        HighlightShape.addTo(this.content, HighlightShape.Type.SQUIGGLY, n, n2, color);
    }

    public void addSquiggly(int n, int n2, String ... stringArray) {
        HighlightShape.addTo(this.content, HighlightShape.Type.SQUIGGLY, n, n2, stringArray);
    }

    public void setBullet(String string) {
        Label label = new Label(string);
        label.setAlignment(Pos.TOP_CENTER);
        this.setLeft((Node)label);
    }

    public double getLineSpacing() {
        Region region = this.content;
        if (region instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region;
            return textFlow.getLineSpacing();
        }
        return 0.0;
    }

    public Integer lineForOffset(int n) {
        Region region = this.content;
        if (region instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region;
            return RichUtils.lineForOffset(textFlow, n);
        }
        return null;
    }

    public Integer lineStart(int n) {
        Region region = this.content;
        if (region instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region;
            return RichUtils.lineStart(textFlow, n);
        }
        return null;
    }

    public Integer lineEnd(int n) {
        Region region = this.content;
        if (region instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region;
            return RichUtils.lineEnd(textFlow, n);
        }
        return null;
    }

    private RangeInfo getTextRange() {
        int n;
        TextFlow textFlow;
        PathElement[] pathElementArray;
        Region region = this.content;
        if (region instanceof TextFlow && (pathElementArray = (textFlow = (TextFlow)region).getRangeShape(0, n = this.getTextLength(), true)).length > 0) {
            double d = textFlow.getLineSpacing();
            return RangeInfo.of(pathElementArray, d);
        }
        return RangeInfo.of(this.width, this.height);
    }

    public boolean isInsideText(double d, double d2, boolean bl) {
        d2 -= this.snappedTopInset();
        d2 -= this.content.snappedTopInset();
        RangeInfo rangeInfo = this.getTextRange();
        int n = rangeInfo.getSegmentCount();
        for (int i = 0; i < n; ++i) {
            if (!rangeInfo.contains(i, d, d2)) continue;
            return true;
        }
        return rangeInfo.insideY(d2);
    }

    public double findHitCandidate(double d, boolean bl) {
        int n;
        double d2 = this.snappedTopInset() + this.content.snappedTopInset();
        double d3 = d - d2;
        RangeInfo rangeInfo = this.getTextRange();
        int n2 = rangeInfo.getSegmentCount();
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                if (!(rangeInfo.getMaxY(i) >= d3)) continue;
                return rangeInfo.midPointY(i) + d2;
            }
            return rangeInfo.midPointY(0) + d2;
        }
        for (n = n2 - 1; n >= 0; --n) {
            if (!(rangeInfo.getMinY(n) <= d3)) continue;
            return rangeInfo.midPointY(n) + d2;
        }
        n = rangeInfo.getSegmentCount() - 1;
        return rangeInfo.midPointY(n) + d2;
    }

    public Integer lineEdge(boolean bl, int n, int n2) {
        Region region = this.content;
        if (region instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region;
            int n3 = RichUtils.lineForOffset(textFlow, n2);
            if (bl) {
                return RichUtils.lineStart(textFlow, n3);
            }
            return RichUtils.lineEnd(textFlow, n3);
        }
        return null;
    }

    public void requestLayout() {
        VFlow vFlow;
        super.requestLayout();
        if (this.embedsNode && (vFlow = RichUtils.getParentOfClass(VFlow.class, (Node)this)) != null) {
            vFlow.requestLayout();
        }
    }
}

