/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.model;

import java.util.Objects;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import jfx.incubator.scene.control.richtext.SyntaxDecorator;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.BasicTextModel;
import jfx.incubator.scene.control.richtext.model.RichParagraph;
import jfx.incubator.scene.control.richtext.model.StyleAttribute;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;

public class CodeTextModel
extends BasicTextModel {
    private SimpleObjectProperty<SyntaxDecorator> decorator;
    private static final Set<StyleAttribute<?>> SUPPORTED = CodeTextModel.initSupportedAttributes();

    public CodeTextModel() {
    }

    public CodeTextModel(BasicTextModel.Content content) {
        super(content);
    }

    private static Set<StyleAttribute<?>> initSupportedAttributes() {
        return Set.of(StyleAttributeMap.BOLD, StyleAttributeMap.ITALIC, StyleAttributeMap.STRIKE_THROUGH, StyleAttributeMap.TEXT_COLOR, StyleAttributeMap.UNDERLINE);
    }

    @Override
    protected Set<StyleAttribute<?>> getSupportedAttributes() {
        return SUPPORTED;
    }

    @Override
    public final RichParagraph getParagraph(int n) {
        SyntaxDecorator syntaxDecorator = this.getDecorator();
        if (syntaxDecorator == null) {
            return super.getParagraph(n);
        }
        return syntaxDecorator.createRichParagraph(this, n);
    }

    public final ObjectProperty<SyntaxDecorator> decoratorProperty() {
        if (this.decorator == null) {
            this.decorator = new SimpleObjectProperty<SyntaxDecorator>(this){
                final /* synthetic */ CodeTextModel this$0;
                {
                    CodeTextModel codeTextModel2 = codeTextModel;
                    Objects.requireNonNull(codeTextModel2);
                    this.this$0 = codeTextModel2;
                }

                protected void invalidated() {
                    TextPos textPos = this.this$0.getDocumentEnd();
                    SyntaxDecorator syntaxDecorator = (SyntaxDecorator)this.get();
                    if (syntaxDecorator != null) {
                        syntaxDecorator.handleChange(this.this$0, TextPos.ZERO, textPos, 0, 0, 0);
                    }
                    this.this$0.fireStyleChangeEvent(TextPos.ZERO, textPos);
                }
            };
        }
        return this.decorator;
    }

    public final SyntaxDecorator getDecorator() {
        return this.decorator == null ? null : (SyntaxDecorator)this.decorator.get();
    }

    public final void setDecorator(SyntaxDecorator syntaxDecorator) {
        this.decoratorProperty().set((Object)syntaxDecorator);
    }

    @Override
    public void fireChangeEvent(TextPos textPos, TextPos textPos2, int n, int n2, int n3) {
        SyntaxDecorator syntaxDecorator = this.getDecorator();
        if (syntaxDecorator != null) {
            syntaxDecorator.handleChange(this, textPos, textPos2, n, n2, n3);
        }
        super.fireChangeEvent(textPos, textPos2, n, n2, n3);
    }
}

