/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.embed.swing.newimpl;

import com.sun.javafx.embed.swing.CachingTransferable;
import com.sun.javafx.embed.swing.FXDnD;
import com.sun.javafx.embed.swing.SwingDnD;
import com.sun.javafx.embed.swing.SwingEvents;
import com.sun.javafx.embed.swing.SwingNodeHelper;
import com.sun.javafx.tk.Toolkit;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.SecondaryLoop;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import javafx.embed.swing.SwingNode;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import jdk.swing.interop.DragSourceContextWrapper;
import jdk.swing.interop.DropTargetContextWrapper;
import jdk.swing.interop.LightweightFrameWrapper;

public class FXDnDInteropN {
    private WeakReference<SwingNode> nodeRef = null;
    private boolean isDragSourceListenerInstalled = false;
    private javafx.scene.input.MouseEvent pressEvent = null;
    private long pressTime = 0L;
    private volatile SecondaryLoop loop;
    private final Map<Component, FXDragGestureRecognizer> recognizers = new HashMap<Component, FXDragGestureRecognizer>();
    private final EventHandler<javafx.scene.input.MouseEvent> onMousePressHandler = mouseEvent -> {
        this.pressEvent = mouseEvent;
        this.pressTime = System.currentTimeMillis();
    };
    private volatile FXDragSourceContextPeer activeDSContextPeer;
    private final EventHandler<javafx.scene.input.MouseEvent> onDragStartHandler = mouseEvent -> {
        this.activeDSContextPeer = null;
        javafx.scene.input.MouseEvent mouseEvent2 = this.getInitialGestureEvent();
        SwingNodeHelper.runOnEDTAndWait(this, () -> this.fireEvent((int)mouseEvent2.getX(), (int)mouseEvent2.getY(), this.pressTime, SwingEvents.fxMouseModsToMouseMods(mouseEvent2)));
        if (this.activeDSContextPeer == null) {
            return;
        }
        mouseEvent.consume();
        SwingNode swingNode = this.getNode();
        if (swingNode != null) {
            Dragboard dragboard = swingNode.startDragAndDrop(SwingDnD.dropActionsToTransferModes(this.activeDSContextPeer.sourceActions).toArray(new TransferMode[1]));
            HashMap<DataFormat, Object> hashMap = new HashMap<DataFormat, Object>();
            for (String string : this.activeDSContextPeer.transferable.getMimeTypes()) {
                DataFormat dataFormat = DataFormat.lookupMimeType((String)string);
                if (dataFormat == null) continue;
                hashMap.put(dataFormat, this.activeDSContextPeer.transferable.getData(string));
            }
            boolean bl = dragboard.setContent(hashMap);
            if (!bl && !FXDnD.fxAppThreadIsDispatchThread) {
                this.loop.exit();
            }
        }
    };
    private final EventHandler<DragEvent> onDragDoneHandler = dragEvent -> {
        dragEvent.consume();
        if (!FXDnD.fxAppThreadIsDispatchThread) {
            this.loop.exit();
        }
        if (this.activeDSContextPeer != null) {
            TransferMode transferMode = dragEvent.getTransferMode();
            this.activeDSContextPeer.dragDone(transferMode == null ? 0 : SwingDnD.transferModeToDropAction(transferMode), (int)dragEvent.getX(), (int)dragEvent.getY());
        }
    };
    private boolean isDropTargetListenerInstalled = false;
    private volatile FXDropTargetContextPeer activeDTContextPeer = null;
    private final Map<Component, DropTarget> dropTargets = new HashMap<Component, DropTarget>();
    private final EventHandler<DragEvent> onDragEnteredHandler = dragEvent -> {
        int n;
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer(this);
        }
        if ((n = this.activeDTContextPeer.postDropTargetEvent((DragEvent)dragEvent)) != 0) {
            dragEvent.consume();
        }
    };
    private final EventHandler<DragEvent> onDragExitedHandler = dragEvent -> {
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer(this);
        }
        this.activeDTContextPeer.postDropTargetEvent((DragEvent)dragEvent);
        this.activeDTContextPeer = null;
    };
    private final EventHandler<DragEvent> onDragOverHandler = dragEvent -> {
        int n;
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer(this);
        }
        if ((n = this.activeDTContextPeer.postDropTargetEvent((DragEvent)dragEvent)) != 0) {
            dragEvent.acceptTransferModes(SwingDnD.dropActionsToTransferModes(n).toArray(new TransferMode[1]));
            dragEvent.consume();
        }
    };
    private final EventHandler<DragEvent> onDragDroppedHandler = dragEvent -> {
        int n;
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer(this);
        }
        if ((n = this.activeDTContextPeer.postDropTargetEvent((DragEvent)dragEvent)) != 0) {
            dragEvent.setDropCompleted(this.activeDTContextPeer.success);
            dragEvent.consume();
        }
        this.activeDTContextPeer = null;
    };

    public Component findComponentAt(Object object, int n, int n2, boolean bl) {
        LightweightFrameWrapper lightweightFrameWrapper = (LightweightFrameWrapper)object;
        return lightweightFrameWrapper.findComponentAt(lightweightFrameWrapper, n, n2, false);
    }

    public boolean isCompEqual(Component component, Object object) {
        LightweightFrameWrapper lightweightFrameWrapper = (LightweightFrameWrapper)object;
        return lightweightFrameWrapper.isCompEqual(component, lightweightFrameWrapper);
    }

    public int convertModifiersToDropAction(int n, int n2) {
        return DragSourceContextWrapper.convertModifiersToDropAction(n, n2);
    }

    public Object createDragSourceContext(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        return new FXDragSourceContextPeer(this, dragGestureEvent);
    }

    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        return (T)new FXDragGestureRecognizer(this, dragSource, component, n, dragGestureListener);
    }

    private void runOnFxThread(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public SwingNode getNode() {
        return (SwingNode)((Object)this.nodeRef.get());
    }

    public void setNode(SwingNode swingNode) {
        this.nodeRef = new WeakReference<SwingNode>(swingNode);
    }

    public <T> ComponentMapper<T> mapComponent(Map<Component, T> map, int n, int n2) {
        return new ComponentMapper<T>(this, map, n, n2);
    }

    private void fireEvent(int n, int n2, long l, int n3) {
        ComponentMapper<FXDragGestureRecognizer> componentMapper = this.mapComponent(this.recognizers, n, n2);
        FXDragGestureRecognizer fXDragGestureRecognizer = (FXDragGestureRecognizer)componentMapper.object;
        if (fXDragGestureRecognizer != null) {
            fXDragGestureRecognizer.fireEvent(componentMapper.x, componentMapper.y, l, n3);
        } else {
            SwingNodeHelper.leaveFXNestedLoop(this);
        }
    }

    private javafx.scene.input.MouseEvent getInitialGestureEvent() {
        return this.pressEvent;
    }

    public void addDropTarget(DropTarget dropTarget, SwingNode swingNode) {
        this.dropTargets.put(dropTarget.getComponent(), dropTarget);
        Platform.runLater(() -> {
            if (!this.isDropTargetListenerInstalled) {
                swingNode.addEventHandler(DragEvent.DRAG_ENTERED, this.onDragEnteredHandler);
                swingNode.addEventHandler(DragEvent.DRAG_EXITED, this.onDragExitedHandler);
                swingNode.addEventHandler(DragEvent.DRAG_OVER, this.onDragOverHandler);
                swingNode.addEventHandler(DragEvent.DRAG_DROPPED, this.onDragDroppedHandler);
                this.isDropTargetListenerInstalled = true;
            }
        });
    }

    public void removeDropTarget(DropTarget dropTarget, SwingNode swingNode) {
        this.dropTargets.remove(dropTarget.getComponent());
        Platform.runLater(() -> {
            if (this.isDropTargetListenerInstalled && this.dropTargets.isEmpty()) {
                swingNode.removeEventHandler(DragEvent.DRAG_ENTERED, this.onDragEnteredHandler);
                swingNode.removeEventHandler(DragEvent.DRAG_EXITED, this.onDragExitedHandler);
                swingNode.removeEventHandler(DragEvent.DRAG_OVER, this.onDragOverHandler);
                swingNode.removeEventHandler(DragEvent.DRAG_DROPPED, this.onDragDroppedHandler);
                this.isDropTargetListenerInstalled = false;
            }
        });
    }

    private final class FXDropTargetContextPeer
    extends DropTargetContextWrapper {
        private int targetActions;
        private int currentAction;
        private DropTarget dt;
        private DropTargetContext ctx;
        private final CachingTransferable transferable;
        private boolean success;
        private int dropAction;
        final /* synthetic */ FXDnDInteropN this$0;

        private FXDropTargetContextPeer(FXDnDInteropN fXDnDInteropN) {
            FXDnDInteropN fXDnDInteropN2 = fXDnDInteropN;
            Objects.requireNonNull(fXDnDInteropN2);
            this.this$0 = fXDnDInteropN2;
            this.targetActions = 0;
            this.currentAction = 0;
            this.dt = null;
            this.ctx = null;
            this.transferable = new CachingTransferable();
            this.success = false;
            this.dropAction = 0;
        }

        @Override
        public synchronized void setTargetActions(int n) {
            this.targetActions = n;
        }

        @Override
        public synchronized int getTargetActions() {
            return this.targetActions;
        }

        @Override
        public synchronized DropTarget getDropTarget() {
            return this.dt;
        }

        @Override
        public synchronized boolean isTransferableJVMLocal() {
            return false;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.transferable.getTransferDataFlavors();
        }

        @Override
        public synchronized Transferable getTransferable() {
            return this.transferable;
        }

        @Override
        public synchronized void acceptDrag(int n) {
            this.currentAction = n;
        }

        @Override
        public synchronized void rejectDrag() {
            this.currentAction = 0;
        }

        @Override
        public synchronized void acceptDrop(int n) {
            this.dropAction = n;
        }

        @Override
        public synchronized void rejectDrop() {
            this.dropAction = 0;
        }

        @Override
        public synchronized void dropComplete(boolean bl) {
            this.success = bl;
        }

        private int postDropTargetEvent(DragEvent dragEvent) {
            ComponentMapper<DropTarget> componentMapper = this.this$0.mapComponent(this.this$0.dropTargets, (int)dragEvent.getX(), (int)dragEvent.getY());
            EventType eventType = dragEvent.getEventType();
            Dragboard dragboard = dragEvent.getDragboard();
            this.transferable.updateData((Clipboard)dragboard, DragEvent.DRAG_DROPPED.equals(eventType));
            int n = SwingDnD.transferModesToDropActions(dragboard.getTransferModes());
            int n2 = dragEvent.getTransferMode() == null ? 0 : SwingDnD.transferModeToDropAction(dragEvent.getTransferMode());
            DropTarget dropTarget = componentMapper.object != null ? (DropTarget)componentMapper.object : this.dt;
            SwingNodeHelper.runOnEDTAndWait(this.this$0, () -> {
                if (dropTarget != this.dt) {
                    if (this.ctx != null) {
                        this.reset(this.ctx);
                    }
                    this.ctx = null;
                    this.dropAction = 0;
                    this.currentAction = 0;
                }
                if (dropTarget != null) {
                    if (this.ctx == null) {
                        this.ctx = dropTarget.getDropTargetContext();
                        this.setDropTargetContext(this.ctx, this);
                    }
                    DropTarget dropTarget2 = dropTarget;
                    if (DragEvent.DRAG_DROPPED.equals(eventType)) {
                        DropTargetDropEvent dropTargetDropEvent = new DropTargetDropEvent(this.ctx, new Point(componentMapper.x, componentMapper.y), n2, n);
                        dropTarget2.drop(dropTargetDropEvent);
                    } else {
                        DropTargetDragEvent dropTargetDragEvent = new DropTargetDragEvent(this.ctx, new Point(componentMapper.x, componentMapper.y), n2, n);
                        if (DragEvent.DRAG_OVER.equals(eventType)) {
                            dropTarget2.dragOver(dropTargetDragEvent);
                        } else if (DragEvent.DRAG_ENTERED.equals(eventType)) {
                            dropTarget2.dragEnter(dropTargetDragEvent);
                        } else if (DragEvent.DRAG_EXITED.equals(eventType)) {
                            dropTarget2.dragExit(dropTargetDragEvent);
                        }
                    }
                }
                this.dt = (DropTarget)componentMapper.object;
                if (this.dt == null) {
                    this.ctx = null;
                    this.dropAction = 0;
                    this.currentAction = 0;
                }
                if (DragEvent.DRAG_DROPPED.equals(eventType) || DragEvent.DRAG_EXITED.equals(eventType)) {
                    this.ctx = null;
                }
                SwingNodeHelper.leaveFXNestedLoop(this.this$0);
            });
            if (DragEvent.DRAG_DROPPED.equals(eventType)) {
                return this.dropAction;
            }
            return this.currentAction;
        }
    }

    private final class FXDragSourceContextPeer
    extends DragSourceContextWrapper {
        private volatile int sourceActions;
        private final CachingTransferable transferable;
        final /* synthetic */ FXDnDInteropN this$0;

        @Override
        public void startSecondaryEventLoop() {
            Toolkit.getToolkit().enterNestedEventLoop((Object)this);
        }

        @Override
        public void quitSecondaryEventLoop() {
            assert (!Platform.isFxApplicationThread());
            Platform.runLater(() -> Toolkit.getToolkit().exitNestedEventLoop((Object)this, null));
        }

        @Override
        protected void setNativeCursor(Cursor cursor, int n) {
        }

        private void dragDone(int n, int n2, int n3) {
            this.dragDropFinished(n != 0, n, n2, n3);
        }

        FXDragSourceContextPeer(FXDnDInteropN fXDnDInteropN, DragGestureEvent dragGestureEvent) {
            FXDnDInteropN fXDnDInteropN2 = fXDnDInteropN;
            Objects.requireNonNull(fXDnDInteropN2);
            this.this$0 = fXDnDInteropN2;
            super(dragGestureEvent);
            this.sourceActions = 0;
            this.transferable = new CachingTransferable();
        }

        protected void startDrag(Transferable transferable, long[] lArray, Map map) {
            this.this$0.activeDSContextPeer = this;
            this.transferable.updateData(transferable, true);
            this.sourceActions = this.getDragSourceContext().getSourceActions();
            if (!FXDnD.fxAppThreadIsDispatchThread) {
                this.this$0.loop = java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
                SwingNodeHelper.leaveFXNestedLoop(this.this$0);
                if (!this.this$0.loop.enter()) {
                    // empty if block
                }
            }
        }
    }

    private class FXDragGestureRecognizer
    extends MouseDragGestureRecognizer {
        final /* synthetic */ FXDnDInteropN this$0;

        FXDragGestureRecognizer(FXDnDInteropN fXDnDInteropN, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
            FXDnDInteropN fXDnDInteropN2 = fXDnDInteropN;
            Objects.requireNonNull(fXDnDInteropN2);
            this.this$0 = fXDnDInteropN2;
            super(dragSource, component, n, dragGestureListener);
            if (component != null) {
                fXDnDInteropN.recognizers.put(component, this);
            }
        }

        @Override
        public synchronized void setComponent(Component component) {
            Component component2 = this.getComponent();
            if (component2 != null) {
                this.this$0.recognizers.remove(component2);
            }
            super.setComponent(component);
            if (component != null) {
                this.this$0.recognizers.put(component, this);
            }
        }

        @Override
        protected void registerListeners() {
            this.this$0.runOnFxThread(() -> {
                if (!this.this$0.isDragSourceListenerInstalled) {
                    SwingNode swingNode = this.this$0.getNode();
                    if (swingNode != null) {
                        swingNode.addEventHandler(javafx.scene.input.MouseEvent.MOUSE_PRESSED, this.this$0.onMousePressHandler);
                        swingNode.addEventHandler(javafx.scene.input.MouseEvent.DRAG_DETECTED, this.this$0.onDragStartHandler);
                        swingNode.addEventHandler(DragEvent.DRAG_DONE, this.this$0.onDragDoneHandler);
                    }
                    this.this$0.isDragSourceListenerInstalled = true;
                }
            });
        }

        @Override
        protected void unregisterListeners() {
            this.this$0.runOnFxThread(() -> {
                if (this.this$0.isDragSourceListenerInstalled) {
                    SwingNode swingNode = this.this$0.getNode();
                    if (swingNode != null) {
                        swingNode.removeEventHandler(javafx.scene.input.MouseEvent.MOUSE_PRESSED, this.this$0.onMousePressHandler);
                        swingNode.removeEventHandler(javafx.scene.input.MouseEvent.DRAG_DETECTED, this.this$0.onDragStartHandler);
                        swingNode.removeEventHandler(DragEvent.DRAG_DONE, this.this$0.onDragDoneHandler);
                    }
                    this.this$0.isDragSourceListenerInstalled = false;
                }
            });
        }

        private void fireEvent(int n, int n2, long l, int n3) {
            this.appendEvent(new MouseEvent(this.getComponent(), 501, l, n3, n, n2, 0, false));
            int n4 = DragSourceContextWrapper.convertModifiersToDropAction(n3, this.getSourceActions());
            this.fireDragGestureRecognized(n4, new Point(n, n2));
        }
    }

    private class ComponentMapper<T> {
        public int x;
        public int y;
        public T object;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ComponentMapper(FXDnDInteropN fXDnDInteropN, Map<Component, T> map, int n, int n2) {
            Objects.requireNonNull(fXDnDInteropN);
            this.object = null;
            this.x = n;
            this.y = n2;
            SwingNode swingNode = fXDnDInteropN.getNode();
            if (swingNode != null) {
                LightweightFrameWrapper lightweightFrameWrapper = (LightweightFrameWrapper)SwingNodeHelper.getLightweightFrame(swingNode);
                Component component = lightweightFrameWrapper.findComponentAt(lightweightFrameWrapper, this.x, this.y, false);
                if (component == null) {
                    return;
                }
                Object object = component.getTreeLock();
                synchronized (object) {
                    do {
                        this.object = map.get(component);
                    } while (this.object == null && (component = component.getParent()) != null);
                    if (this.object != null) {
                        while (lightweightFrameWrapper.isCompEqual(component, lightweightFrameWrapper) && component != null) {
                            this.x -= component.getX();
                            this.y -= component.getY();
                            component = component.getParent();
                        }
                    }
                }
            }
        }
    }
}

