/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.beans.DefaultProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.SplitPaneSkin;

@DefaultProperty(value="items")
public class SplitPane
extends Control {
    private static final String RESIZABLE_WITH_PARENT = "resizable-with-parent";
    private ObjectProperty<Orientation> orientation;
    private final ObservableList<Node> items = FXCollections.observableArrayList();
    private final ObservableList<Divider> dividers = FXCollections.observableArrayList();
    private final ObservableList<Divider> unmodifiableDividers = FXCollections.unmodifiableObservableList(this.dividers);
    private final Map<Integer, Double> dividerCache = new HashMap<Integer, Double>();
    private static final String DEFAULT_STYLE_CLASS = "split-pane";
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"horizontal");

    public static void setResizableWithParent(Node node, Boolean bl) {
        if (bl == null) {
            node.getProperties().remove((Object)RESIZABLE_WITH_PARENT);
        } else {
            node.getProperties().put((Object)RESIZABLE_WITH_PARENT, (Object)bl);
        }
    }

    public static Boolean isResizableWithParent(Node node) {
        Object object;
        if (node.hasProperties() && (object = node.getProperties().get((Object)RESIZABLE_WITH_PARENT)) != null) {
            return (Boolean)object;
        }
        return true;
    }

    public SplitPane() {
        this(null);
    }

    public SplitPane(Node ... nodeArray) {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        ((StyleableProperty)this.focusTraversableProperty()).applyStyle(null, (Object)Boolean.FALSE);
        this.getItems().addListener((ListChangeListener)new ListChangeListener<Node>(this){
            final /* synthetic */ SplitPane this$0;
            {
                SplitPane splitPane2 = splitPane;
                Objects.requireNonNull(splitPane2);
                this.this$0 = splitPane2;
            }

            public void onChanged(ListChangeListener.Change<? extends Node> change) {
                int n;
                while (change.next()) {
                    int n2;
                    int n3 = n = change.getFrom();
                    for (n2 = 0; n2 < change.getRemovedSize(); ++n2) {
                        if (n3 < this.this$0.dividers.size()) {
                            this.this$0.dividerCache.put(n3, (Double)Double.MAX_VALUE);
                        } else if (n3 == this.this$0.dividers.size() && !this.this$0.dividers.isEmpty()) {
                            if (change.wasReplaced()) {
                                this.this$0.dividerCache.put(n3 - 1, ((Divider)this.this$0.dividers.get(n3 - 1)).getPosition());
                            } else {
                                this.this$0.dividerCache.put(n3 - 1, (Double)Double.MAX_VALUE);
                            }
                        }
                        ++n3;
                    }
                    for (n2 = 0; n2 < this.this$0.dividers.size(); ++n2) {
                        if (this.this$0.dividerCache.get(n2) != null) continue;
                        this.this$0.dividerCache.put(n2, ((Divider)this.this$0.dividers.get(n2)).getPosition());
                    }
                }
                this.this$0.dividers.clear();
                for (n = 0; n < this.this$0.getItems().size() - 1; ++n) {
                    if (this.this$0.dividerCache.containsKey(n) && this.this$0.dividerCache.get(n) != Double.MAX_VALUE) {
                        Divider divider = new Divider();
                        divider.setPosition(this.this$0.dividerCache.get(n));
                        this.this$0.dividers.add((Object)divider);
                    } else {
                        this.this$0.dividers.add((Object)new Divider());
                    }
                    this.this$0.dividerCache.remove(n);
                }
            }
        });
        if (nodeArray != null) {
            this.getItems().addAll((Object[])nodeArray);
        }
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, true);
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set((Object)orientation);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)this.orientation.get();
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty<Orientation>(this, Orientation.HORIZONTAL){
                final /* synthetic */ SplitPane this$0;
                {
                    SplitPane splitPane2 = splitPane;
                    Objects.requireNonNull(splitPane2);
                    this.this$0 = splitPane2;
                    super((Object)orientation);
                }

                public void invalidated() {
                    boolean bl = this.get() == Orientation.VERTICAL;
                    this.this$0.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, bl);
                    this.this$0.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, !bl);
                }

                public CssMetaData<SplitPane, Orientation> getCssMetaData() {
                    return StyleableProperties.ORIENTATION;
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public ObservableList<Node> getItems() {
        return this.items;
    }

    public ObservableList<Divider> getDividers() {
        return this.unmodifiableDividers;
    }

    public void setDividerPosition(int n, double d) {
        if (this.getDividers().size() <= n) {
            this.dividerCache.put(n, d);
            return;
        }
        if (n >= 0) {
            ((Divider)this.getDividers().get(n)).setPosition(d);
        }
    }

    public void setDividerPositions(double ... dArray) {
        if (this.dividers.isEmpty()) {
            for (int i = 0; i < dArray.length; ++i) {
                this.dividerCache.put(i, dArray[i]);
            }
            return;
        }
        for (int i = 0; i < dArray.length && i < this.dividers.size(); ++i) {
            ((Divider)this.dividers.get(i)).setPosition(dArray[i]);
        }
    }

    public double[] getDividerPositions() {
        double[] dArray = new double[this.dividers.size()];
        for (int i = 0; i < this.dividers.size(); ++i) {
            dArray[i] = ((Divider)this.dividers.get(i)).getPosition();
        }
        return dArray;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new SplitPaneSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return SplitPane.getClassCssMetaData();
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }

    public static class Divider {
        private DoubleProperty position;

        public final void setPosition(double d) {
            this.positionProperty().set(d);
        }

        public final double getPosition() {
            return this.position == null ? 0.5 : this.position.get();
        }

        public final DoubleProperty positionProperty() {
            if (this.position == null) {
                this.position = new SimpleDoubleProperty((Object)this, "position", 0.5);
            }
            return this.position;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<SplitPane, Orientation> ORIENTATION = new CssMetaData<SplitPane, Orientation>("-fx-orientation", (StyleConverter)new EnumConverter(Orientation.class), Orientation.HORIZONTAL){

            public Orientation getInitialValue(SplitPane splitPane) {
                return splitPane.getOrientation();
            }

            public boolean isSettable(SplitPane splitPane) {
                return splitPane.orientation == null || !splitPane.orientation.isBound();
            }

            public StyleableProperty<Orientation> getStyleableProperty(SplitPane splitPane) {
                return (StyleableProperty)splitPane.orientationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(Control.getClassCssMetaData());
            arrayList.add(ORIENTATION);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

