/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Pos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Skin;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.skin.ToggleButtonSkin;

public class ToggleButton
extends ButtonBase
implements Toggle {
    private BooleanProperty selected;
    private ObjectProperty<ToggleGroup> toggleGroup;
    private static final String DEFAULT_STYLE_CLASS = "toggle-button";
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");

    public ToggleButton() {
        this.initialize();
    }

    public ToggleButton(String string) {
        this.setText(string);
        this.initialize();
    }

    public ToggleButton(String string, Node node) {
        this.setText(string);
        this.setGraphic(node);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TOGGLE_BUTTON);
        ((StyleableProperty)this.alignmentProperty()).applyStyle(null, (Object)Pos.CENTER);
        this.setMnemonicParsing(true);
    }

    @Override
    public final void setSelected(boolean bl) {
        this.selectedProperty().set(bl);
    }

    @Override
    public final boolean isSelected() {
        return this.selected == null ? false : this.selected.get();
    }

    @Override
    public final BooleanProperty selectedProperty() {
        if (this.selected == null) {
            this.selected = new BooleanPropertyBase(this){
                final /* synthetic */ ToggleButton this$0;
                {
                    ToggleButton toggleButton2 = toggleButton;
                    Objects.requireNonNull(toggleButton2);
                    this.this$0 = toggleButton2;
                }

                protected void invalidated() {
                    boolean bl = this.get();
                    ToggleGroup toggleGroup = this.this$0.getToggleGroup();
                    this.this$0.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, bl);
                    this.this$0.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTED);
                    if (toggleGroup != null) {
                        if (bl) {
                            toggleGroup.selectToggle(this.this$0);
                        } else if (toggleGroup.getSelectedToggle() == this.this$0) {
                            toggleGroup.clearSelectedToggle();
                        }
                    }
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    @Override
    public final void setToggleGroup(ToggleGroup toggleGroup) {
        this.toggleGroupProperty().set((Object)toggleGroup);
    }

    @Override
    public final ToggleGroup getToggleGroup() {
        return this.toggleGroup == null ? null : (ToggleGroup)this.toggleGroup.get();
    }

    @Override
    public final ObjectProperty<ToggleGroup> toggleGroupProperty() {
        if (this.toggleGroup == null) {
            this.toggleGroup = new ObjectPropertyBase<ToggleGroup>(this){
                private ToggleGroup old;
                private ChangeListener<Toggle> listener;
                final /* synthetic */ ToggleButton this$0;
                {
                    ToggleButton toggleButton2 = toggleButton;
                    Objects.requireNonNull(toggleButton2);
                    this.this$0 = toggleButton2;
                    this.listener = (observableValue, toggle, toggle2) -> ParentHelper.getTraversalEngine((Parent)this.this$0).setOverriddenFocusTraversability(toggle2 != null ? Boolean.valueOf(this.this$0.isSelected()) : null);
                }

                protected void invalidated() {
                    ToggleGroup toggleGroup = (ToggleGroup)this.get();
                    if (toggleGroup != null && !toggleGroup.getToggles().contains((Object)this.this$0)) {
                        if (this.old != null) {
                            this.old.getToggles().remove((Object)this.this$0);
                        }
                        toggleGroup.getToggles().add((Object)this.this$0);
                        ParentTraversalEngine parentTraversalEngine = new ParentTraversalEngine((Parent)this.this$0);
                        ParentHelper.setTraversalEngine((Parent)this.this$0, (ParentTraversalEngine)parentTraversalEngine);
                        parentTraversalEngine.setOverriddenFocusTraversability(toggleGroup.getSelectedToggle() != null ? Boolean.valueOf(this.this$0.isSelected()) : null);
                        toggleGroup.selectedToggleProperty().addListener(this.listener);
                    } else if (toggleGroup == null) {
                        this.old.selectedToggleProperty().removeListener(this.listener);
                        this.old.getToggles().remove((Object)this.this$0);
                        ParentHelper.setTraversalEngine((Parent)this.this$0, null);
                    }
                    this.old = toggleGroup;
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "toggleGroup";
                }
            };
        }
        return this.toggleGroup;
    }

    @Override
    public void fire() {
        if (!this.isDisabled()) {
            this.setSelected(!this.isSelected());
            this.fireEvent((Event)new ActionEvent());
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ToggleButtonSkin(this);
    }

    @Override
    protected Pos getInitialAlignment() {
        return Pos.CENTER;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case SELECTED: {
                return this.isSelected();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }
}

