/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ToolBarSkin;

@DefaultProperty(value="items")
public class ToolBar
extends Control {
    private final ObservableList<Node> items = FXCollections.observableArrayList();
    private ObjectProperty<Orientation> orientation;
    private static final String DEFAULT_STYLE_CLASS = "tool-bar";
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"horizontal");

    public ToolBar() {
        this.initialize();
    }

    public ToolBar(Node ... nodeArray) {
        this.initialize();
        this.items.addAll((Object[])nodeArray);
    }

    private void initialize() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TOOL_BAR);
        ((StyleableProperty)this.focusTraversableProperty()).applyStyle(null, (Object)Boolean.FALSE);
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, true);
    }

    public final ObservableList<Node> getItems() {
        return this.items;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set((Object)orientation);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)this.orientation.get();
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty<Orientation>(this, Orientation.HORIZONTAL){
                final /* synthetic */ ToolBar this$0;
                {
                    ToolBar toolBar2 = toolBar;
                    Objects.requireNonNull(toolBar2);
                    this.this$0 = toolBar2;
                    super((Object)orientation);
                }

                public void invalidated() {
                    boolean bl = this.get() == Orientation.VERTICAL;
                    this.this$0.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, bl);
                    this.this$0.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, !bl);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "orientation";
                }

                public CssMetaData<ToolBar, Orientation> getCssMetaData() {
                    return StyleableProperties.ORIENTATION;
                }
            };
        }
        return this.orientation;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ToolBarSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return ToolBar.getClassCssMetaData();
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }

    private static class StyleableProperties {
        private static final CssMetaData<ToolBar, Orientation> ORIENTATION = new CssMetaData<ToolBar, Orientation>("-fx-orientation", (StyleConverter)new EnumConverter(Orientation.class), Orientation.HORIZONTAL){

            public Orientation getInitialValue(ToolBar toolBar) {
                return toolBar.getOrientation();
            }

            public boolean isSettable(ToolBar toolBar) {
                return toolBar.orientation == null || !toolBar.orientation.isBound();
            }

            public StyleableProperty<Orientation> getStyleableProperty(ToolBar toolBar) {
                return (StyleableProperty)toolBar.orientationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(Control.getClassCssMetaData());
            arrayList.add(ORIENTATION);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

