/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application.preferences;

import com.sun.javafx.application.preferences.ChangedValue;
import com.sun.javafx.application.preferences.PreferenceMapping;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javafx.application.ColorScheme;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.ReadOnlyProperty;
import javafx.scene.paint.Color;

final class PreferenceProperties {
    private final Object mutex = new Object();
    private final Object bean;
    private final Map<String, DeferredProperty<?>> deferredProperties = new HashMap();
    private final DeferredProperty<Color> backgroundColor = new DeferredProperty<Color>(this, "backgroundColor", Color.WHITE);
    private final DeferredProperty<Color> foregroundColor = new DeferredProperty<Color>(this, "foregroundColor", Color.BLACK);
    private final DeferredProperty<Color> accentColor = new DeferredProperty<Color>(this, "accentColor", Color.rgb(21, 126, 251));
    private final ColorSchemeProperty colorScheme = new ColorSchemeProperty(this);
    private final DeferredProperty<Boolean> reducedMotion = new DeferredProperty<Boolean>(this, "reducedMotion", false);
    private final DeferredProperty<Boolean> reducedTransparency = new DeferredProperty<Boolean>(this, "reducedTransparency", false);
    private final DeferredProperty<Boolean> reducedData = new DeferredProperty<Boolean>(this, "reducedData", false);
    private final DeferredProperty<Boolean> persistentScrollBars = new DeferredProperty<Boolean>(this, "persistentScrollBars", false);
    private final ReadOnlyBooleanWrapperImpl reducedMotionFlag = new ReadOnlyBooleanWrapperImpl((ReadOnlyProperty<Boolean>)this.reducedMotion);
    private final ReadOnlyBooleanWrapperImpl reducedTransparencyFlag = new ReadOnlyBooleanWrapperImpl((ReadOnlyProperty<Boolean>)this.reducedTransparency);
    private final ReadOnlyBooleanWrapperImpl reducedDataFlag = new ReadOnlyBooleanWrapperImpl((ReadOnlyProperty<Boolean>)this.reducedData);
    private final ReadOnlyBooleanWrapperImpl persistentScrollBarsFlag = new ReadOnlyBooleanWrapperImpl((ReadOnlyProperty<Boolean>)this.persistentScrollBars);

    PreferenceProperties(Object object) {
        this.bean = object;
    }

    public ReadOnlyBooleanProperty reducedMotionProperty() {
        return this.reducedMotionFlag;
    }

    public boolean isReducedMotion() {
        return this.reducedMotion.get();
    }

    public void setReducedMotion(boolean bl) {
        this.reducedMotion.setValueOverride(bl);
    }

    public ReadOnlyBooleanProperty reducedTransparencyProperty() {
        return this.reducedTransparencyFlag;
    }

    public boolean isReducedTransparency() {
        return this.reducedTransparency.get();
    }

    public void setReducedTransparency(boolean bl) {
        this.reducedTransparency.setValueOverride(bl);
    }

    public ReadOnlyBooleanProperty reducedDataProperty() {
        return this.reducedDataFlag;
    }

    public boolean isReducedData() {
        return this.reducedData.get();
    }

    public void setReducedData(boolean bl) {
        this.reducedData.setValueOverride(bl);
    }

    public ReadOnlyBooleanProperty persistentScrollBarsProperty() {
        return this.persistentScrollBarsFlag;
    }

    public boolean isPersistentScrollBars() {
        return this.persistentScrollBars.get();
    }

    public void setPersistentScrollBars(boolean bl) {
        this.persistentScrollBars.setValueOverride(bl);
    }

    public ReadOnlyObjectProperty<ColorScheme> colorSchemeProperty() {
        return this.colorScheme;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme.get();
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme.setValueOverride(colorScheme);
    }

    public ReadOnlyObjectProperty<Color> backgroundColorProperty() {
        return this.backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor.setValueOverride(color);
    }

    public ReadOnlyObjectProperty<Color> foregroundColorProperty() {
        return this.foregroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor.get();
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor.setValueOverride(color);
    }

    public ReadOnlyObjectProperty<Color> accentColorProperty() {
        return this.accentColor;
    }

    public Color getAccentColor() {
        return this.accentColor.get();
    }

    public void setAccentColor(Color color) {
        this.accentColor.setValueOverride(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Map<String, ChangedValue> map, Map<String, PreferenceMapping<?, ?>> map2) {
        Iterator<DeferredProperty<?>> iterator = this.mutex;
        synchronized (iterator) {
            for (Map.Entry<String, ChangedValue> entry : map.entrySet()) {
                PreferenceMapping<?, ?> preferenceMapping;
                Object object = map2.get(entry.getKey());
                if (!(object instanceof PreferenceMapping) || !((object = this.deferredProperties.get((preferenceMapping = object).keyName())) instanceof DeferredProperty)) continue;
                DeferredProperty deferredProperty = (DeferredProperty)((Object)object);
                deferredProperty.setPlatformValue(preferenceMapping.map(entry.getValue().newValue()));
            }
            this.colorScheme.updateEffectiveValue();
        }
        for (DeferredProperty<?> deferredProperty : this.deferredProperties.values()) {
            deferredProperty.fireValueChangedIfNecessary();
        }
        this.colorScheme.fireValueChangeIfNecessary();
    }

    private final class DeferredProperty<T>
    extends ReadOnlyObjectPropertyBase<T> {
        private final String name;
        private final T defaultValue;
        private T overrideValue;
        private T platformValue;
        private T effectiveValue;
        private T lastEffectiveValue;
        final /* synthetic */ PreferenceProperties this$0;

        DeferredProperty(PreferenceProperties preferenceProperties, String string, T t) {
            PreferenceProperties preferenceProperties2 = preferenceProperties;
            Objects.requireNonNull(preferenceProperties2);
            this.this$0 = preferenceProperties2;
            Objects.requireNonNull(t);
            preferenceProperties.deferredProperties.put(string, this);
            this.name = string;
            this.defaultValue = t;
            this.platformValue = t;
            this.effectiveValue = t;
            this.lastEffectiveValue = t;
        }

        public Object getBean() {
            return this.this$0.bean;
        }

        public String getName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            Object object = this.this$0.mutex;
            synchronized (object) {
                return this.effectiveValue;
            }
        }

        public void setPlatformValue(Object object) {
            Class<?> clazz = this.defaultValue.getClass();
            this.platformValue = clazz.isInstance(object) ? object : null;
            this.updateEffectiveValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValueOverride(T t) {
            Toolkit.getToolkit().checkFxUserThread();
            Object object = this.this$0.mutex;
            synchronized (object) {
                this.overrideValue = t;
                this.updateEffectiveValue();
            }
            this.fireValueChangedIfNecessary();
        }

        public void fireValueChangedIfNecessary() {
            if (!Objects.equals(this.lastEffectiveValue, this.effectiveValue)) {
                this.lastEffectiveValue = this.effectiveValue;
                this.fireValueChangedEvent();
            }
        }

        private void updateEffectiveValue() {
            this.effectiveValue = Objects.requireNonNullElse(this.overrideValue != null ? this.overrideValue : this.platformValue, this.defaultValue);
        }
    }

    private final class ColorSchemeProperty
    extends ReadOnlyObjectPropertyBase<ColorScheme> {
        private ColorScheme overrideValue;
        private ColorScheme effectiveValue;
        private ColorScheme lastEffectiveValue;
        final /* synthetic */ PreferenceProperties this$0;

        private ColorSchemeProperty(PreferenceProperties preferenceProperties) {
            PreferenceProperties preferenceProperties2 = preferenceProperties;
            Objects.requireNonNull(preferenceProperties2);
            this.this$0 = preferenceProperties2;
            this.effectiveValue = ColorScheme.LIGHT;
            this.lastEffectiveValue = ColorScheme.LIGHT;
        }

        public Object getBean() {
            return this.this$0.bean;
        }

        public String getName() {
            return "colorScheme";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ColorScheme get() {
            Object object = this.this$0.mutex;
            synchronized (object) {
                return this.effectiveValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValueOverride(ColorScheme colorScheme) {
            Toolkit.getToolkit().checkFxUserThread();
            Object object = this.this$0.mutex;
            synchronized (object) {
                this.overrideValue = colorScheme;
                this.updateEffectiveValue();
            }
            this.fireValueChangeIfNecessary();
        }

        public void updateEffectiveValue() {
            if (this.overrideValue != null) {
                this.effectiveValue = this.overrideValue;
            } else {
                Color color = this.this$0.backgroundColor.get();
                Color color2 = this.this$0.foregroundColor.get();
                boolean bl = Utils.calculateBrightness(color) < Utils.calculateBrightness(color2);
                this.effectiveValue = bl ? ColorScheme.DARK : ColorScheme.LIGHT;
            }
        }

        public void fireValueChangeIfNecessary() {
            if (this.lastEffectiveValue != this.effectiveValue) {
                this.lastEffectiveValue = this.effectiveValue;
                this.fireValueChangedEvent();
            }
        }
    }

    private static final class ReadOnlyBooleanWrapperImpl
    extends ReadOnlyBooleanPropertyBase {
        private final ReadOnlyProperty<Boolean> observable;

        ReadOnlyBooleanWrapperImpl(ReadOnlyProperty<Boolean> readOnlyProperty) {
            this.observable = readOnlyProperty;
            readOnlyProperty.addListener((observableValue, bl, bl2) -> this.fireValueChangedEvent());
        }

        public Object getBean() {
            return this.observable.getBean();
        }

        public String getName() {
            return this.observable.getName();
        }

        public boolean get() {
            return (Boolean)this.observable.getValue();
        }
    }
}

