/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.StyleablePropertyHelper;
import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import java.util.Objects;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableBooleanProperty
extends BooleanPropertyBase
implements StyleableProperty<Boolean> {
    private StyleOrigin origin;
    private TransitionMediatorImpl mediator;

    public StyleableBooleanProperty() {
    }

    public StyleableBooleanProperty(boolean bl) {
        super(bl);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Boolean bl) {
        boolean bl2;
        Node node;
        Object object = this.getBean();
        TransitionDefinition transitionDefinition = object instanceof Node && !NodeHelper.isInitialCssState(node = (Node)object) ? NodeHelper.findTransitionDefinition(node, this.getCssMetaData()) : null;
        boolean bl3 = bl2 = bl != null && bl != false;
        if (transitionDefinition == null) {
            this.set(bl2);
        } else if (this.mediator == null || this.mediator.endValue != bl2) {
            this.mediator = new TransitionMediatorImpl(this, this.get(), bl2);
            this.mediator.run(transitionDefinition, this.getCssMetaData().getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
        this.origin = styleOrigin;
    }

    public void bind(ObservableValue<? extends Boolean> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    public void set(boolean bl) {
        super.set(bl);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel();
        }
    }

    private boolean equalsEndValue(Object object) {
        if (!(object instanceof Boolean)) {
            return false;
        }
        Boolean bl = (Boolean)object;
        boolean bl2 = this.mediator != null ? this.mediator.endValue : this.get();
        return bl == bl2;
    }

    static {
        StyleablePropertyHelper.setBooleanAccessor(new StyleablePropertyHelper.Accessor(){

            @Override
            public boolean equalsEndValue(StyleableProperty<?> styleableProperty, Object object) {
                return ((StyleableBooleanProperty)styleableProperty).equalsEndValue(object);
            }
        });
    }

    private class TransitionMediatorImpl
    extends TransitionMediator {
        private final boolean startValue;
        private final boolean endValue;
        private boolean reversingAdjustedStartValue;
        final /* synthetic */ StyleableBooleanProperty this$0;

        public TransitionMediatorImpl(StyleableBooleanProperty styleableBooleanProperty, boolean bl, boolean bl2) {
            StyleableBooleanProperty styleableBooleanProperty2 = styleableBooleanProperty;
            Objects.requireNonNull(styleableBooleanProperty2);
            this.this$0 = styleableBooleanProperty2;
            this.startValue = bl;
            this.endValue = bl2;
            this.reversingAdjustedStartValue = bl;
        }

        @Override
        public void onUpdate(double d) {
            StyleableBooleanProperty.super.set(d < 0.5 ? this.startValue : this.endValue);
        }

        @Override
        public void onStop() {
            this.this$0.mediator = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return this.this$0;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionMediatorImpl transitionMediatorImpl = (TransitionMediatorImpl)transitionMediator;
            if (transitionMediatorImpl.reversingAdjustedStartValue == this.endValue) {
                this.reversingAdjustedStartValue = transitionMediatorImpl.endValue;
                return true;
            }
            return false;
        }
    }
}

