/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.StyleablePropertyHelper;
import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.util.Objects;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableLongProperty
extends LongPropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin;
    private TransitionMediatorImpl mediator;

    public StyleableLongProperty() {
    }

    public StyleableLongProperty(long l) {
        super(l);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        long l;
        Node node;
        Object object = this.getBean();
        TransitionDefinition transitionDefinition = object instanceof Node && !NodeHelper.isInitialCssState(node = (Node)object) ? NodeHelper.findTransitionDefinition(node, this.getCssMetaData()) : null;
        long l2 = l = number != null ? number.longValue() : 0L;
        if (transitionDefinition == null) {
            this.set(l);
        } else if (this.mediator == null || this.mediator.endValue != l) {
            this.mediator = new TransitionMediatorImpl(this, this.get(), l);
            this.mediator.run(transitionDefinition, this.getCssMetaData().getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
        this.origin = styleOrigin;
    }

    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    public void set(long l) {
        super.set(l);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel();
        }
    }

    private boolean equalsEndValue(Object object) {
        if (!(object instanceof Long)) {
            return false;
        }
        Long l = (Long)object;
        long l2 = this.mediator != null ? this.mediator.endValue : this.get();
        return l == l2;
    }

    static {
        StyleablePropertyHelper.setLongAccessor(new StyleablePropertyHelper.Accessor(){

            @Override
            public boolean equalsEndValue(StyleableProperty<?> styleableProperty, Object object) {
                return ((StyleableLongProperty)styleableProperty).equalsEndValue(object);
            }
        });
    }

    private final class TransitionMediatorImpl
    extends TransitionMediator {
        private final long startValue;
        private final long endValue;
        private long reversingAdjustedStartValue;
        final /* synthetic */ StyleableLongProperty this$0;

        public TransitionMediatorImpl(StyleableLongProperty styleableLongProperty, long l, long l2) {
            StyleableLongProperty styleableLongProperty2 = styleableLongProperty;
            Objects.requireNonNull(styleableLongProperty2);
            this.this$0 = styleableLongProperty2;
            this.startValue = l;
            this.endValue = l2;
            this.reversingAdjustedStartValue = l;
        }

        @Override
        public void onUpdate(double d) {
            long l = this.endValue - this.startValue;
            long l2 = this.startValue + Math.round(d * (double)l);
            StyleableLongProperty.super.set(d != 1.0 ? Utils.clamp(this.startValue, l2, this.endValue) : this.endValue);
        }

        @Override
        public void onStop() {
            this.this$0.mediator = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return this.this$0;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionMediatorImpl transitionMediatorImpl = (TransitionMediatorImpl)transitionMediator;
            if (transitionMediatorImpl.reversingAdjustedStartValue == this.endValue) {
                this.reversingAdjustedStartValue = transitionMediatorImpl.endValue;
                return true;
            }
            return false;
        }
    }
}

