/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.StyleablePropertyHelper;
import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import java.util.Objects;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableStringProperty
extends StringPropertyBase
implements StyleableProperty<String> {
    private StyleOrigin origin;
    private TransitionMediatorImpl mediator;

    public StyleableStringProperty() {
    }

    public StyleableStringProperty(String string) {
        super(string);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, String string) {
        Node node;
        TransitionDefinition transitionDefinition;
        Object object = this.getBean();
        TransitionDefinition transitionDefinition2 = transitionDefinition = object instanceof Node && !NodeHelper.isInitialCssState(node = (Node)object) ? NodeHelper.findTransitionDefinition(node, this.getCssMetaData()) : null;
        if (transitionDefinition == null) {
            this.set(string);
        } else if (this.mediator == null || !Objects.equals(string, this.mediator.endValue)) {
            this.mediator = new TransitionMediatorImpl(this, this.get(), string);
            this.mediator.run(transitionDefinition, this.getCssMetaData().getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
        this.origin = styleOrigin;
    }

    public void bind(ObservableValue<? extends String> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    public void set(String string) {
        super.set(string);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel();
        }
    }

    private boolean equalsEndValue(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        return Objects.equals(string, this.mediator != null ? this.mediator.endValue : this.get());
    }

    static {
        StyleablePropertyHelper.setStringAccessor(new StyleablePropertyHelper.Accessor(){

            @Override
            public boolean equalsEndValue(StyleableProperty<?> styleableProperty, Object object) {
                return ((StyleableStringProperty)styleableProperty).equalsEndValue(object);
            }
        });
    }

    private final class TransitionMediatorImpl
    extends TransitionMediator {
        final String startValue;
        final String endValue;
        private String reversingAdjustedStartValue;
        final /* synthetic */ StyleableStringProperty this$0;

        TransitionMediatorImpl(StyleableStringProperty styleableStringProperty, String string, String string2) {
            StyleableStringProperty styleableStringProperty2 = styleableStringProperty;
            Objects.requireNonNull(styleableStringProperty2);
            this.this$0 = styleableStringProperty2;
            this.startValue = string;
            this.endValue = string2;
            this.reversingAdjustedStartValue = string;
        }

        @Override
        public void onUpdate(double d) {
            StyleableStringProperty.super.set(d < 0.5 ? this.startValue : this.endValue);
        }

        @Override
        public void onStop() {
            this.this$0.mediator = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return this.this$0;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionMediatorImpl transitionMediatorImpl = (TransitionMediatorImpl)transitionMediator;
            if (Objects.equals(transitionMediatorImpl.reversingAdjustedStartValue, this.endValue)) {
                this.reversingAdjustedStartValue = transitionMediatorImpl.endValue;
                return true;
            }
            return false;
        }
    }
}

