/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SpotLightHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGSpotLight;
import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.PointLight;
import javafx.scene.paint.Color;

public class SpotLight
extends PointLight {
    private ObjectProperty<Point3D> direction;
    private static final Point3D DEFAULT_DIRECTION;
    private DoubleProperty innerAngle;
    private static final double DEFAULT_INNER_ANGLE;
    private DoubleProperty outerAngle;
    private static final double DEFAULT_OUTER_ANGLE;
    private DoubleProperty falloff;
    private static final double DEFAULT_FALLOFF;

    public SpotLight() {
        SpotLightHelper.initHelper(this);
    }

    public SpotLight(Color color) {
        super(color);
        SpotLightHelper.initHelper(this);
    }

    public final void setDirection(Point3D point3D) {
        this.directionProperty().set((Object)point3D);
    }

    public final Point3D getDirection() {
        return this.direction == null ? DEFAULT_DIRECTION : (Point3D)this.direction.get();
    }

    public final ObjectProperty<Point3D> directionProperty() {
        if (this.direction == null) {
            this.direction = new SimpleObjectProperty<Point3D>(this, (Object)this, "direction", DEFAULT_DIRECTION){
                final /* synthetic */ SpotLight this$0;
                {
                    SpotLight spotLight2 = spotLight;
                    Objects.requireNonNull(spotLight2);
                    this.this$0 = spotLight2;
                    super(object, string, (Object)point3D);
                }

                protected void invalidated() {
                    NodeHelper.markDirty(this.this$0, DirtyBits.NODE_LIGHT);
                }
            };
        }
        return this.direction;
    }

    public final void setInnerAngle(double d) {
        this.innerAngleProperty().set(d);
    }

    public final double getInnerAngle() {
        return this.innerAngle == null ? DEFAULT_INNER_ANGLE : this.innerAngle.get();
    }

    public final DoubleProperty innerAngleProperty() {
        if (this.innerAngle == null) {
            this.innerAngle = this.getLightDoubleProperty("innerAngle", DEFAULT_INNER_ANGLE);
        }
        return this.innerAngle;
    }

    public final void setOuterAngle(double d) {
        this.outerAngleProperty().set(d);
    }

    public final double getOuterAngle() {
        return this.outerAngle == null ? DEFAULT_OUTER_ANGLE : this.outerAngle.get();
    }

    public final DoubleProperty outerAngleProperty() {
        if (this.outerAngle == null) {
            this.outerAngle = this.getLightDoubleProperty("outerAngle", DEFAULT_OUTER_ANGLE);
        }
        return this.outerAngle;
    }

    public final void setFalloff(double d) {
        this.falloffProperty().set(d);
    }

    public final double getFalloff() {
        return this.falloff == null ? DEFAULT_FALLOFF : this.falloff.get();
    }

    public final DoubleProperty falloffProperty() {
        if (this.falloff == null) {
            this.falloff = this.getLightDoubleProperty("falloff", DEFAULT_FALLOFF);
        }
        return this.falloff;
    }

    private NGNode doCreatePeer() {
        return new NGSpotLight();
    }

    private void doUpdatePeer() {
        if (this.isDirty(DirtyBits.NODE_LIGHT)) {
            NGSpotLight nGSpotLight = (NGSpotLight)this.getPeer();
            nGSpotLight.setDirection(this.getDirection());
            nGSpotLight.setInnerAngle((float)this.getInnerAngle());
            nGSpotLight.setOuterAngle((float)this.getOuterAngle());
            nGSpotLight.setFalloff((float)this.getFalloff());
        }
    }

    static {
        SpotLightHelper.setSpotLightAccessor(new SpotLightHelper.SpotLightAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((SpotLight)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((SpotLight)node).doUpdatePeer();
            }
        });
        DEFAULT_DIRECTION = NGSpotLight.getDefaultDirection();
        DEFAULT_INNER_ANGLE = NGSpotLight.getDefaultInnerAngle();
        DEFAULT_OUTER_ANGLE = NGSpotLight.getDefaultOuterAngle();
        DEFAULT_FALLOFF = NGSpotLight.getDefaultFalloff();
    }
}

