/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.scene.paint.MaterialHelper;
import com.sun.javafx.sg.prism.NGPhongMaterial;
import com.sun.javafx.tk.Toolkit;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;

public non-sealed class PhongMaterial
extends Material {
    private boolean diffuseColorDirty = true;
    private boolean specularColorDirty = true;
    private boolean specularPowerDirty = true;
    private boolean diffuseMapDirty = true;
    private boolean specularMapDirty = true;
    private boolean bumpMapDirty = true;
    private boolean selfIlluminationMapDirty = true;
    private ObjectProperty<Color> diffuseColor;
    private ObjectProperty<Color> specularColor;
    private DoubleProperty specularPower;
    private final AbstractNotifyListener platformImageChangeListener = new AbstractNotifyListener(this){
        final /* synthetic */ PhongMaterial this$0;
        {
            PhongMaterial phongMaterial2 = phongMaterial;
            Objects.requireNonNull(phongMaterial2);
            this.this$0 = phongMaterial2;
        }

        public void invalidated(Observable observable) {
            if (this.this$0.oldDiffuseMap != null && observable == Toolkit.getImageAccessor().getImageProperty(this.this$0.oldDiffuseMap)) {
                this.this$0.diffuseMapDirty = true;
            } else if (this.this$0.oldSpecularMap != null && observable == Toolkit.getImageAccessor().getImageProperty(this.this$0.oldSpecularMap)) {
                this.this$0.specularMapDirty = true;
            } else if (this.this$0.oldBumpMap != null && observable == Toolkit.getImageAccessor().getImageProperty(this.this$0.oldBumpMap)) {
                this.this$0.bumpMapDirty = true;
            } else if (this.this$0.oldSelfIlluminationMap != null && observable == Toolkit.getImageAccessor().getImageProperty(this.this$0.oldSelfIlluminationMap)) {
                this.this$0.selfIlluminationMapDirty = true;
            }
            this.this$0.setDirty(true);
        }
    };
    private ObjectProperty<Image> diffuseMap;
    private Image oldDiffuseMap;
    private ObjectProperty<Image> specularMap;
    private Image oldSpecularMap;
    private ObjectProperty<Image> bumpMap;
    private Image oldBumpMap;
    private ObjectProperty<Image> selfIlluminationMap;
    private Image oldSelfIlluminationMap;
    private NGPhongMaterial peer;

    public PhongMaterial() {
        this.setDiffuseColor(Color.WHITE);
    }

    public PhongMaterial(Color color) {
        this.setDiffuseColor(color);
    }

    public PhongMaterial(Color color, Image image, Image image2, Image image3, Image image4) {
        this.setDiffuseColor(color);
        this.setDiffuseMap(image);
        this.setSpecularMap(image2);
        this.setBumpMap(image3);
        this.setSelfIlluminationMap(image4);
    }

    public final void setDiffuseColor(Color color) {
        this.diffuseColorProperty().set((Object)color);
    }

    public final Color getDiffuseColor() {
        return this.diffuseColor == null ? null : (Color)this.diffuseColor.get();
    }

    public final ObjectProperty<Color> diffuseColorProperty() {
        if (this.diffuseColor == null) {
            this.diffuseColor = new SimpleObjectProperty<Color>(this, (Object)this, "diffuseColor"){
                final /* synthetic */ PhongMaterial this$0;
                {
                    PhongMaterial phongMaterial2 = phongMaterial;
                    Objects.requireNonNull(phongMaterial2);
                    this.this$0 = phongMaterial2;
                    super(object, string);
                }

                protected void invalidated() {
                    this.this$0.diffuseColorDirty = true;
                    this.this$0.setDirty(true);
                }
            };
        }
        return this.diffuseColor;
    }

    public final void setSpecularColor(Color color) {
        this.specularColorProperty().set((Object)color);
    }

    public final Color getSpecularColor() {
        return this.specularColor == null ? null : (Color)this.specularColor.get();
    }

    public final ObjectProperty<Color> specularColorProperty() {
        if (this.specularColor == null) {
            this.specularColor = new SimpleObjectProperty<Color>(this, (Object)this, "specularColor"){
                final /* synthetic */ PhongMaterial this$0;
                {
                    PhongMaterial phongMaterial2 = phongMaterial;
                    Objects.requireNonNull(phongMaterial2);
                    this.this$0 = phongMaterial2;
                    super(object, string);
                }

                protected void invalidated() {
                    this.this$0.specularColorDirty = true;
                    this.this$0.setDirty(true);
                }
            };
        }
        return this.specularColor;
    }

    public final void setSpecularPower(double d) {
        this.specularPowerProperty().set(d);
    }

    public final double getSpecularPower() {
        return this.specularPower == null ? 32.0 : this.specularPower.get();
    }

    public final DoubleProperty specularPowerProperty() {
        if (this.specularPower == null) {
            this.specularPower = new SimpleDoubleProperty(this, this, "specularPower", 32.0){
                final /* synthetic */ PhongMaterial this$0;
                {
                    PhongMaterial phongMaterial2 = phongMaterial;
                    Objects.requireNonNull(phongMaterial2);
                    this.this$0 = phongMaterial2;
                    super(object, string, d);
                }

                public void invalidated() {
                    this.this$0.specularPowerDirty = true;
                    this.this$0.setDirty(true);
                }
            };
        }
        return this.specularPower;
    }

    public final void setDiffuseMap(Image image) {
        this.diffuseMapProperty().set((Object)image);
    }

    public final Image getDiffuseMap() {
        return this.diffuseMap == null ? null : (Image)this.diffuseMap.get();
    }

    public final ObjectProperty<Image> diffuseMapProperty() {
        if (this.diffuseMap == null) {
            this.diffuseMap = new SimpleObjectProperty<Image>(this, (Object)this, "diffuseMap"){
                private boolean needsListeners;
                final /* synthetic */ PhongMaterial this$0;
                {
                    PhongMaterial phongMaterial2 = phongMaterial;
                    Objects.requireNonNull(phongMaterial2);
                    this.this$0 = phongMaterial2;
                    super(object, string);
                    this.needsListeners = false;
                }

                public void invalidated() {
                    Image image = (Image)this.get();
                    if (this.needsListeners) {
                        Toolkit.getImageAccessor().getImageProperty(this.this$0.oldDiffuseMap).removeListener(this.this$0.platformImageChangeListener.getWeakListener());
                    }
                    boolean bl = this.needsListeners = image != null && (Toolkit.getImageAccessor().isAnimation(image) || image.getProgress() < 1.0);
                    if (this.needsListeners) {
                        Toolkit.getImageAccessor().getImageProperty(image).addListener(this.this$0.platformImageChangeListener.getWeakListener());
                    }
                    this.this$0.oldDiffuseMap = image;
                    this.this$0.diffuseMapDirty = true;
                    this.this$0.setDirty(true);
                }
            };
        }
        return this.diffuseMap;
    }

    public final void setSpecularMap(Image image) {
        this.specularMapProperty().set((Object)image);
    }

    public final Image getSpecularMap() {
        return this.specularMap == null ? null : (Image)this.specularMap.get();
    }

    public final ObjectProperty<Image> specularMapProperty() {
        if (this.specularMap == null) {
            this.specularMap = new SimpleObjectProperty<Image>(this, (Object)this, "specularMap"){
                private boolean needsListeners;
                final /* synthetic */ PhongMaterial this$0;
                {
                    PhongMaterial phongMaterial2 = phongMaterial;
                    Objects.requireNonNull(phongMaterial2);
                    this.this$0 = phongMaterial2;
                    super(object, string);
                    this.needsListeners = false;
                }

                public void invalidated() {
                    Image image = (Image)this.get();
                    if (this.needsListeners) {
                        Toolkit.getImageAccessor().getImageProperty(this.this$0.oldSpecularMap).removeListener(this.this$0.platformImageChangeListener.getWeakListener());
                    }
                    boolean bl = this.needsListeners = image != null && (Toolkit.getImageAccessor().isAnimation(image) || image.getProgress() < 1.0);
                    if (this.needsListeners) {
                        Toolkit.getImageAccessor().getImageProperty(image).addListener(this.this$0.platformImageChangeListener.getWeakListener());
                    }
                    this.this$0.oldSpecularMap = image;
                    this.this$0.specularMapDirty = true;
                    this.this$0.setDirty(true);
                }
            };
        }
        return this.specularMap;
    }

    public final void setBumpMap(Image image) {
        this.bumpMapProperty().set((Object)image);
    }

    public final Image getBumpMap() {
        return this.bumpMap == null ? null : (Image)this.bumpMap.get();
    }

    public final ObjectProperty<Image> bumpMapProperty() {
        if (this.bumpMap == null) {
            this.bumpMap = new SimpleObjectProperty<Image>(this, (Object)this, "bumpMap"){
                private boolean needsListeners;
                final /* synthetic */ PhongMaterial this$0;
                {
                    PhongMaterial phongMaterial2 = phongMaterial;
                    Objects.requireNonNull(phongMaterial2);
                    this.this$0 = phongMaterial2;
                    super(object, string);
                    this.needsListeners = false;
                }

                public void invalidated() {
                    Image image = (Image)this.get();
                    if (this.needsListeners) {
                        Toolkit.getImageAccessor().getImageProperty(this.this$0.oldBumpMap).removeListener(this.this$0.platformImageChangeListener.getWeakListener());
                    }
                    boolean bl = this.needsListeners = image != null && (Toolkit.getImageAccessor().isAnimation(image) || image.getProgress() < 1.0);
                    if (this.needsListeners) {
                        Toolkit.getImageAccessor().getImageProperty(image).addListener(this.this$0.platformImageChangeListener.getWeakListener());
                    }
                    this.this$0.oldBumpMap = image;
                    this.this$0.bumpMapDirty = true;
                    this.this$0.setDirty(true);
                }
            };
        }
        return this.bumpMap;
    }

    public final void setSelfIlluminationMap(Image image) {
        this.selfIlluminationMapProperty().set((Object)image);
    }

    public final Image getSelfIlluminationMap() {
        return this.selfIlluminationMap == null ? null : (Image)this.selfIlluminationMap.get();
    }

    public final ObjectProperty<Image> selfIlluminationMapProperty() {
        if (this.selfIlluminationMap == null) {
            this.selfIlluminationMap = new SimpleObjectProperty<Image>(this, (Object)this, "selfIlluminationMap"){
                private boolean needsListeners;
                final /* synthetic */ PhongMaterial this$0;
                {
                    PhongMaterial phongMaterial2 = phongMaterial;
                    Objects.requireNonNull(phongMaterial2);
                    this.this$0 = phongMaterial2;
                    super(object, string);
                    this.needsListeners = false;
                }

                public void invalidated() {
                    Image image = (Image)this.get();
                    if (this.needsListeners) {
                        Toolkit.getImageAccessor().getImageProperty(this.this$0.oldSelfIlluminationMap).removeListener(this.this$0.platformImageChangeListener.getWeakListener());
                    }
                    boolean bl = this.needsListeners = image != null && (Toolkit.getImageAccessor().isAnimation(image) || image.getProgress() < 1.0);
                    if (this.needsListeners) {
                        Toolkit.getImageAccessor().getImageProperty(image).addListener(this.this$0.platformImageChangeListener.getWeakListener());
                    }
                    this.this$0.oldSelfIlluminationMap = image;
                    this.this$0.selfIlluminationMapDirty = true;
                    this.this$0.setDirty(true);
                }
            };
        }
        return this.selfIlluminationMap;
    }

    @Override
    void setDirty(boolean bl) {
        super.setDirty(bl);
        if (!bl) {
            this.diffuseColorDirty = false;
            this.specularColorDirty = false;
            this.specularPowerDirty = false;
            this.diffuseMapDirty = false;
            this.specularMapDirty = false;
            this.bumpMapDirty = false;
            this.selfIlluminationMapDirty = false;
        }
    }

    @Override
    NGPhongMaterial getNGMaterial() {
        if (this.peer == null) {
            this.peer = new NGPhongMaterial();
        }
        return this.peer;
    }

    @Override
    void updatePG() {
        if (!this.isDirty()) {
            return;
        }
        NGPhongMaterial nGPhongMaterial = MaterialHelper.getNGMaterial(this);
        if (this.diffuseColorDirty) {
            nGPhongMaterial.setDiffuseColor(this.getDiffuseColor() == null ? null : Toolkit.getPaintAccessor().getPlatformPaint(this.getDiffuseColor()));
        }
        if (this.specularColorDirty) {
            nGPhongMaterial.setSpecularColor(this.getSpecularColor() == null ? null : Toolkit.getPaintAccessor().getPlatformPaint(this.getSpecularColor()));
        }
        if (this.specularPowerDirty) {
            nGPhongMaterial.setSpecularPower((float)this.getSpecularPower());
        }
        if (this.diffuseMapDirty) {
            nGPhongMaterial.setDiffuseMap(this.getDiffuseMap() == null ? null : Toolkit.getImageAccessor().getPlatformImage(this.getDiffuseMap()));
        }
        if (this.specularMapDirty) {
            nGPhongMaterial.setSpecularMap(this.getSpecularMap() == null ? null : Toolkit.getImageAccessor().getPlatformImage(this.getSpecularMap()));
        }
        if (this.bumpMapDirty) {
            nGPhongMaterial.setBumpMap(this.getBumpMap() == null ? null : Toolkit.getImageAccessor().getPlatformImage(this.getBumpMap()));
        }
        if (this.selfIlluminationMapDirty) {
            nGPhongMaterial.setSelfIllumMap(this.getSelfIlluminationMap() == null ? null : Toolkit.getImageAccessor().getPlatformImage(this.getSelfIlluminationMap()));
        }
        this.setDirty(false);
    }

    public String toString() {
        return "PhongMaterial[diffuseColor=" + String.valueOf(this.getDiffuseColor()) + ", specularColor=" + String.valueOf(this.getSpecularColor()) + ", specularPower=" + this.getSpecularPower() + ", diffuseMap=" + String.valueOf(this.getDiffuseMap()) + ", specularMap=" + String.valueOf(this.getSpecularMap()) + ", bumpMap=" + String.valueOf(this.getBumpMap()) + ", selfIlluminationMap=" + String.valueOf(this.getSelfIlluminationMap()) + "]";
    }
}

