/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext.rtf;

import com.sun.jfx.incubator.scene.control.richtext.SegmentStyledInput;
import com.sun.jfx.incubator.scene.control.richtext.rtf.AttrSet;
import com.sun.jfx.incubator.scene.control.richtext.rtf.RTFAttribute;
import com.sun.jfx.incubator.scene.control.richtext.rtf.RTFAttributes;
import com.sun.jfx.incubator.scene.control.richtext.rtf.RTFParser;
import com.sun.jfx.incubator.scene.control.richtext.rtf.Style;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledInput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;

public class RTFReader
extends RTFParser {
    private static final Object STYLE_TYPE = new Object();
    private static final Object STYLE_SECTION = new Object();
    private static final Object STYLE_PARAGRAPH = new Object();
    private static final Object STYLE_CHARACTER = new Object();
    private static final Object STYLE_NEXT = new Object();
    private static final Object STYLE_ADDITIVE = new Object();
    private static final Object STYLE_HIDDEN = new Object();
    private final String text;
    private ArrayList<StyledSegment> segments;
    private HashMap<Object, Object> parserState;
    private Destination rtfDestination;
    private AttrSet documentAttributes;
    private HashMap<Integer, String> fontTable;
    private Color[] colorTable;
    private HashMap<Integer, Style> characterStyles;
    private HashMap<Integer, Style> paragraphStyles;
    private HashMap<Integer, Style> sectionStyles;
    private boolean ignoreGroupIfUnknownKeyword;
    private int skippingCharacters;
    private final AttrSet.Holder holder = new AttrSet.Holder();
    private static final String DEFAULT_STYLE = "default";
    private final HashMap<String, Style> styles = this.initStyles();
    private static final HashMap<String, RTFAttribute> straightforwardAttributes = RTFAttributes.attributesByKeyword();
    private static final HashMap<String, String> textKeywords = RTFReader.initTextKeywords();
    private static final HashMap<String, char[]> characterSets = RTFReader.initCharacterSets();
    private static HashMap<String, String> fcharsetToCP = RTFReader.initFCharsetToCP();
    private HashMap<Integer, Charset> fcharsetTable = new HashMap();
    private static final int ANSI_CHARSET = 0;
    private static final int DEFAULT_CHARSET = 1;
    private static final int SYMBOL_CHARSET = 2;
    private static final int MAC_CHARSET = 77;
    private static final int SHIFTJIS_CHARSET = 128;
    private static final int HANGUL_CHARSET = 129;
    private static final int JOHAB_CHARSET = 130;
    private static final int GB2312_CHARSET = 134;
    private static final int CHINESEBIG5_CHARSET = 136;
    private static final int GREEK_CHARSET = 161;
    private static final int TURKISH_CHARSET = 162;
    private static final int VIETNAMESE_CHARSET = 163;
    private static final int HEBREW_CHARSET = 177;
    private static final int ARABIC_CHARSET = 178;
    private static final int BALTIC_CHARSET = 186;
    private static final int RUSSIAN_CHARSET = 204;
    private static final int THAI_CHARSET = 222;
    private static final int EASTEUROPE_CHARSET = 238;
    private static final int OEM_CHARSET = 255;
    private static final String REPLACEMENT_CHAR = "\ufffd";

    public RTFReader(String string) {
        this.text = string;
        this.parserState = new HashMap();
        this.fontTable = new HashMap();
        this.documentAttributes = new AttrSet();
    }

    public StyledInput generateStyledInput() throws IOException {
        if (this.segments == null) {
            this.segments = new ArrayList();
            this.readFromReader(new StringReader(this.text));
        }
        return SegmentStyledInput.of(this.segments);
    }

    private static HashMap<String, String> initTextKeywords() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("\\", "\\");
        hashMap.put("{", "{");
        hashMap.put("}", "}");
        hashMap.put(" ", "\u00a0");
        hashMap.put("~", "\u00a0");
        hashMap.put("_", "\u2011");
        hashMap.put("bullet", "\u2022");
        hashMap.put("emdash", "\u2014");
        hashMap.put("emspace", "\u2003");
        hashMap.put("endash", "\u2013");
        hashMap.put("enspace", "\u2002");
        hashMap.put("line", "\n");
        hashMap.put("ldblquote", "\u201c");
        hashMap.put("lquote", "\u2018");
        hashMap.put("ltrmark", "\u200e");
        hashMap.put("rdblquote", "\u201d");
        hashMap.put("rquote", "\u2019");
        hashMap.put("rtlmark", "\u200f");
        hashMap.put("tab", "\t");
        hashMap.put("zwj", "\u200d");
        hashMap.put("zwnj", "\u200c");
        hashMap.put("-", "\u2027");
        return hashMap;
    }

    private static HashMap<String, String> initFCharsetToCP() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("fcharset0", "windows-1252");
        hashMap.put("fcharset128", "ms932");
        hashMap.put("fcharset129", "ms949");
        hashMap.put("fcharset130", "ms1361");
        hashMap.put("fcharset134", "ms936");
        hashMap.put("fcharset136", "ms950");
        hashMap.put("fcharset161", "windows-1253");
        hashMap.put("fcharset162", "windows-1254");
        hashMap.put("fcharset163", "windows-1258");
        hashMap.put("fcharset177", "windows-1255");
        hashMap.put("fcharset178", "windows-1256");
        hashMap.put("fcharset186", "windows-1257");
        hashMap.put("fcharset204", "windows-1251");
        hashMap.put("fcharset222", "ms874");
        hashMap.put("fcharset238", "windows-1250");
        return hashMap;
    }

    private static HashMap<String, char[]> initCharacterSets() {
        HashMap<String, char[]> hashMap = new HashMap<String, char[]>();
        hashMap.put("ansicpg", latin1TranslationTable);
        return hashMap;
    }

    private HashMap<String, Style> initStyles() {
        HashMap<String, Style> hashMap = new HashMap<String, Style>();
        hashMap.put(DEFAULT_STYLE, new Style());
        return hashMap;
    }

    private Style addStyle(String string, Style style) {
        Style style2 = new Style();
        style2.setResolveParent(style);
        this.styles.put(string, style2);
        return style2;
    }

    private Style getDefaultStyle() {
        return this.styles.get(DEFAULT_STYLE);
    }

    @Override
    public void handleBinaryBlob(byte[] byArray) {
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return;
        }
    }

    @Override
    public void handleText(String string) {
        if (this.skippingCharacters > 0) {
            if (this.skippingCharacters >= string.length()) {
                this.skippingCharacters -= string.length();
                return;
            }
            string = string.substring(this.skippingCharacters);
            this.skippingCharacters = 0;
        }
        if (this.rtfDestination != null) {
            this.rtfDestination.handleText(string);
            return;
        }
    }

    @Override
    public void begingroup() {
        Object object;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((object = this.parserState.get("_savedState")) != null) {
            this.parserState.remove("_savedState");
        }
        HashMap hashMap = (HashMap)this.parserState.clone();
        if (object != null) {
            hashMap.put("_savedState", object);
        }
        this.parserState.put("_savedState", hashMap);
        if (this.rtfDestination != null) {
            this.rtfDestination.begingroup();
        }
    }

    @Override
    public void endgroup() {
        HashMap hashMap;
        Destination destination;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((destination = (Destination)(hashMap = (HashMap)this.parserState.get("_savedState")).get("dst")) != this.rtfDestination) {
            this.rtfDestination.close();
            this.rtfDestination = destination;
        }
        HashMap<Object, Object> hashMap2 = this.parserState;
        this.parserState = hashMap;
        if (this.rtfDestination != null) {
            this.rtfDestination.endgroup(hashMap2);
        }
    }

    protected void setRTFDestination(Destination destination) {
        HashMap hashMap = (HashMap)this.parserState.get("_savedState");
        if (hashMap != null && this.rtfDestination != hashMap.get("dst")) {
            this.rtfDestination.close();
        }
        this.rtfDestination = destination;
        this.parserState.put("dst", this.rtfDestination);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public boolean handleKeyword(String string) {
        boolean bl = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        String string2 = textKeywords.get(string);
        if (string2 != null) {
            this.handleText(string2);
            return true;
        }
        if (string.equals("fonttbl")) {
            this.setRTFDestination(new FonttblDestination(this));
            return true;
        }
        if (string.equals("colortbl")) {
            this.setRTFDestination(new ColortblDestination(this));
            return true;
        }
        if (string.equals("stylesheet")) {
            this.setRTFDestination(new StylesheetDestination(this));
            return true;
        }
        if (string.equals("info")) {
            this.setRTFDestination(new Destination());
            return false;
        }
        if (string.equals("mac")) {
            this.setCharacterSet("mac");
            return true;
        }
        if (string.equals("ansi")) {
            this.setCharacterSet("ansi");
            return true;
        }
        if (string.equals("next")) {
            this.setCharacterSet("NeXT");
            return true;
        }
        if (string.equals("pc")) {
            this.setCharacterSet("cpg437");
            return true;
        }
        if (string.equals("pca")) {
            this.setCharacterSet("cpg850");
            return true;
        }
        if (string.equals("*")) {
            this.ignoreGroupIfUnknownKeyword = true;
            return true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(string)) {
            return true;
        }
        switch (string) {
            case "aftncn": 
            case "aftnsep": 
            case "aftnsepc": 
            case "annotation": 
            case "atnauthor": 
            case "atnicn": 
            case "atnid": 
            case "atnref": 
            case "atntime": 
            case "atrfend": 
            case "atrfstart": 
            case "bkmkend": 
            case "bkmkstart": 
            case "datafield": 
            case "do": 
            case "dptxbxtext": 
            case "falt": 
            case "field": 
            case "file": 
            case "filetbl": 
            case "fname": 
            case "fontemb": 
            case "fontfile": 
            case "footer": 
            case "footerf": 
            case "footerl": 
            case "footerr": 
            case "footnote": 
            case "ftncn": 
            case "ftnsep": 
            case "ftnsepc": 
            case "header": 
            case "headerf": 
            case "headerl": 
            case "headerr": 
            case "keycode": 
            case "nextfile": 
            case "object": 
            case "pict": 
            case "pn": 
            case "pnseclvl": 
            case "pntxtb": 
            case "pntxta": 
            case "revtbl": 
            case "rxe": 
            case "tc": 
            case "template": 
            case "txe": 
            case "xe": {
                bl = true;
            }
        }
        if (bl) {
            this.setRTFDestination(new Destination());
        }
        return false;
    }

    @Override
    public boolean handleKeyword(String string, int n) {
        boolean bl = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        if (string.equals("uc")) {
            this.parserState.put("UnicodeSkip", n);
            return true;
        }
        if (string.equals("u")) {
            if (n < 0) {
                n += 65536;
            }
            this.handleText((char)n);
            Number number = (Number)this.parserState.get("UnicodeSkip");
            this.skippingCharacters = number != null ? number.intValue() : 1;
            return true;
        }
        if (string.equals("rtf")) {
            this.setRTFDestination(new DocumentDestination(this));
            return true;
        }
        if (string.startsWith("NeXT") || string.equals("private")) {
            bl = true;
        }
        if (string.contains("ansicpg")) {
            this.setCharacterSet("ansicpg");
            return true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(string, n)) {
            return true;
        }
        if (bl) {
            this.setRTFDestination(new Destination());
        }
        return false;
    }

    public void setCharacterSet(String string) {
        Object object;
        try {
            object = RTFReader.getCharacterSet(string);
        }
        catch (Exception exception) {
            object = null;
        }
        if (object != null) {
            this.translationTable = (char[])object;
        } else if (!string.equals("ansi")) {
            try {
                this.translationTable = (char[])RTFReader.getCharacterSet("ansi");
            }
            catch (IOException iOException) {
                throw new InternalError("RTFReader: Unable to find character set resources (" + String.valueOf(iOException) + ")", iOException);
            }
        }
    }

    private static void defineCharacterSet(String string, char[] cArray) {
        if (cArray.length < 256) {
            throw new IllegalArgumentException("Translation table must have 256 entries.");
        }
        characterSets.put(string, cArray);
    }

    public static Object getCharacterSet(String string) throws IOException {
        char[] cArray = characterSets.get(string);
        if (cArray == null) {
            try (InputStream inputStream = RTFReader.class.getResourceAsStream("charsets/" + string + ".txt");){
                cArray = RTFReader.readCharset(inputStream);
                RTFReader.defineCharacterSet(string, cArray);
            }
        }
        return cArray;
    }

    static char[] readCharset(InputStream inputStream) throws IOException {
        char[] cArray = new char[256];
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.ISO_8859_1));){
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.commentChar(35);
            streamTokenizer.slashSlashComments(true);
            streamTokenizer.slashStarComments(true);
            for (int i = 0; i < 256; ++i) {
                int n;
                try {
                    n = streamTokenizer.nextToken();
                }
                catch (Exception exception) {
                    throw new IOException("Unable to read from character set file (" + String.valueOf(exception) + ")");
                }
                if (n != -2) {
                    throw new IOException("Unexpected token in character set file");
                }
                cArray[i] = (char)streamTokenizer.nval;
            }
        }
        return cArray;
    }

    static class Destination {
        Destination() {
        }

        public void handleBinaryBlob(byte[] byArray) {
        }

        public void handleText(String string) {
        }

        public boolean handleKeyword(String string) {
            return true;
        }

        public boolean handleKeyword(String string, int n) {
            return true;
        }

        public void begingroup() {
        }

        public void endgroup(Map<Object, Object> map) {
        }

        public void close() {
        }
    }

    class FonttblDestination
    extends Destination {
        private int nextFontNumber;
        private Integer fontNumberKey;
        private String nextFontFamily;
        final /* synthetic */ RTFReader this$0;

        FonttblDestination(RTFReader rTFReader) {
            RTFReader rTFReader2 = rTFReader;
            Objects.requireNonNull(rTFReader2);
            this.this$0 = rTFReader2;
        }

        @Override
        public void handleText(String string) {
            int n = string.indexOf(59);
            Object object = n > -1 ? string.substring(0, n) : string;
            if (this.nextFontNumber == -1 && this.fontNumberKey != null) {
                object = this.this$0.fontTable.get(this.fontNumberKey) + (String)object;
            } else {
                this.fontNumberKey = this.nextFontNumber;
            }
            this.this$0.fontTable.put(this.fontNumberKey, (String)object);
            this.nextFontNumber = -1;
            this.nextFontFamily = null;
        }

        @Override
        public boolean handleKeyword(String string) {
            if (string.charAt(0) == 'f') {
                this.nextFontFamily = string.substring(1);
                return true;
            }
            return false;
        }

        @Override
        public boolean handleKeyword(String string, int n) {
            if (string.equals("f")) {
                this.nextFontNumber = n;
                return true;
            }
            if (string.equals("fcharset")) {
                Charset charset;
                String string2 = string + n;
                String string3 = fcharsetToCP.get(string2);
                if (string3 != null) {
                    try {
                        charset = Charset.forName(string3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        charset = StandardCharsets.ISO_8859_1;
                    }
                } else {
                    charset = StandardCharsets.ISO_8859_1;
                }
                this.this$0.fcharsetTable.put(this.nextFontNumber, charset);
                return true;
            }
            return false;
        }
    }

    class ColortblDestination
    extends Destination {
        private int red;
        private int green;
        private int blue;
        private final ArrayList<Color> colors;
        final /* synthetic */ RTFReader this$0;

        public ColortblDestination(RTFReader rTFReader) {
            RTFReader rTFReader2 = rTFReader;
            Objects.requireNonNull(rTFReader2);
            this.this$0 = rTFReader2;
            this.colors = new ArrayList();
        }

        @Override
        public void handleText(String string) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ';') continue;
                Color color = Color.rgb((int)this.red, (int)this.green, (int)this.blue);
                this.colors.add(color);
            }
        }

        @Override
        public void close() {
            int n = this.colors.size();
            this.this$0.colorTable = this.colors.toArray(new Color[n]);
        }

        @Override
        public boolean handleKeyword(String string, int n) {
            switch (string) {
                case "red": {
                    this.red = n;
                    return true;
                }
                case "green": {
                    this.green = n;
                    return true;
                }
                case "blue": {
                    this.blue = n;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean handleKeyword(String string) {
            return false;
        }
    }

    class StylesheetDestination
    extends Destination {
        private HashMap<Integer, StyleDefiningDestination> definedStyles;
        final /* synthetic */ RTFReader this$0;

        public StylesheetDestination(RTFReader rTFReader) {
            RTFReader rTFReader2 = rTFReader;
            Objects.requireNonNull(rTFReader2);
            this.this$0 = rTFReader2;
            this.definedStyles = new HashMap();
        }

        @Override
        public void begingroup() {
            this.this$0.setRTFDestination(new StyleDefiningDestination(this));
        }

        @Override
        public void close() {
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashMap<Integer, Style> hashMap3 = new HashMap<Integer, Style>();
            for (StyleDefiningDestination styleDefiningDestination : this.definedStyles.values()) {
                Style style = styleDefiningDestination.realize();
                Object object = style.getAttribute(STYLE_TYPE);
                HashMap<Integer, Style> hashMap4 = object == STYLE_SECTION ? hashMap3 : (object == STYLE_CHARACTER ? hashMap : hashMap2);
                hashMap4.put(styleDefiningDestination.number, style);
            }
            if (!hashMap.isEmpty()) {
                this.this$0.characterStyles = hashMap;
            }
            if (!hashMap2.isEmpty()) {
                this.this$0.paragraphStyles = hashMap2;
            }
            if (!hashMap3.isEmpty()) {
                this.this$0.sectionStyles = hashMap3;
            }
        }

        class StyleDefiningDestination
        extends AttributeTrackingDestination {
            private static final int STYLENUMBER_NONE = 222;
            private boolean additive;
            private boolean characterStyle;
            private boolean sectionStyle;
            public String styleName;
            public int number;
            private int basedOn;
            private int nextStyle;
            private boolean hidden;
            private Style realizedStyle;
            final /* synthetic */ StylesheetDestination this$1;

            StyleDefiningDestination(StylesheetDestination stylesheetDestination) {
                StylesheetDestination stylesheetDestination2 = stylesheetDestination;
                Objects.requireNonNull(stylesheetDestination2);
                this.this$1 = stylesheetDestination2;
                super(stylesheetDestination.this$0);
                this.basedOn = 222;
                this.nextStyle = 222;
            }

            @Override
            public void handleText(String string) {
                this.styleName = this.styleName != null ? this.styleName + string : string;
            }

            @Override
            public void close() {
                int n;
                int n2 = n = this.styleName == null ? 0 : this.styleName.indexOf(59);
                if (n > 0) {
                    this.styleName = this.styleName.substring(0, n);
                }
                this.this$1.definedStyles.put(this.number, this);
                super.close();
            }

            @Override
            public boolean handleKeyword(String string) {
                switch (string) {
                    case "additive": {
                        this.additive = true;
                        return true;
                    }
                    case "shidden": {
                        this.hidden = true;
                        return true;
                    }
                }
                return super.handleKeyword(string);
            }

            @Override
            public boolean handleKeyword(String string, int n) {
                if (n > Short.MAX_VALUE) {
                    n = Short.MAX_VALUE;
                } else if (n < -32767) {
                    n = -32767;
                }
                switch (string) {
                    case "s": {
                        this.characterStyle = false;
                        this.sectionStyle = false;
                        this.number = n;
                        return true;
                    }
                    case "cs": {
                        this.characterStyle = true;
                        this.sectionStyle = false;
                        this.number = n;
                        return true;
                    }
                    case "ds": {
                        this.characterStyle = false;
                        this.sectionStyle = true;
                        this.number = n;
                        return true;
                    }
                    case "sbasedon": {
                        this.basedOn = n;
                        return true;
                    }
                    case "snext": {
                        this.nextStyle = n;
                        return true;
                    }
                }
                return super.handleKeyword(string, n);
            }

            public Style realize() {
                return this.realize(null);
            }

            private Style realize(Set<Integer> set) {
                StyleDefiningDestination styleDefiningDestination;
                Style style = null;
                Style style2 = null;
                if (set == null) {
                    set = new HashSet<Integer>();
                }
                if (this.realizedStyle != null) {
                    return this.realizedStyle;
                }
                if (this.basedOn != 222 && set.add(this.basedOn) && (styleDefiningDestination = this.this$1.definedStyles.get(this.basedOn)) != null && styleDefiningDestination != this) {
                    style = styleDefiningDestination.realize(set);
                }
                this.realizedStyle = this.this$1.this$0.addStyle(this.styleName, style);
                if (this.characterStyle) {
                    this.realizedStyle.addAttributes(this.currentTextAttributes());
                    this.realizedStyle.addAttribute(STYLE_TYPE, STYLE_CHARACTER);
                } else if (this.sectionStyle) {
                    this.realizedStyle.addAttributes(this.currentSectionAttributes());
                    this.realizedStyle.addAttribute(STYLE_TYPE, STYLE_SECTION);
                } else {
                    this.realizedStyle.addAttributes(this.currentParagraphAttributes());
                    this.realizedStyle.addAttribute(STYLE_TYPE, STYLE_PARAGRAPH);
                }
                if (this.nextStyle != 222 && (styleDefiningDestination = this.this$1.definedStyles.get(this.nextStyle)) != null) {
                    style2 = styleDefiningDestination.realize();
                }
                if (style2 != null) {
                    this.realizedStyle.addAttribute(STYLE_NEXT, style2);
                }
                this.realizedStyle.addAttribute(STYLE_ADDITIVE, this.additive);
                this.realizedStyle.addAttribute(STYLE_HIDDEN, this.hidden);
                return this.realizedStyle;
            }
        }
    }

    class DocumentDestination
    extends AttributeTrackingDestination {
        private boolean inParagraph;
        final /* synthetic */ RTFReader this$0;

        public DocumentDestination(RTFReader rTFReader) {
            RTFReader rTFReader2 = rTFReader;
            Objects.requireNonNull(rTFReader2);
            this.this$0 = rTFReader2;
            super(rTFReader);
        }

        public void deliverText(String string, AttrSet attrSet) {
            StyleAttributeMap styleAttributeMap = attrSet.getStyleAttributeMap();
            StyledSegment styledSegment = StyledSegment.of(string, styleAttributeMap);
            this.this$0.segments.add(styledSegment);
        }

        public void finishParagraph(AttrSet attrSet, AttrSet attrSet2) {
            this.this$0.segments.add(StyledSegment.LINE_BREAK);
        }

        protected void endSection() {
        }

        @Override
        public void handleText(String string) {
            if (!this.inParagraph) {
                this.beginParagraph();
            }
            this.deliverText(string, this.currentTextAttributes());
        }

        @Override
        public void close() {
            if (this.inParagraph) {
                this.endParagraph();
            }
            super.close();
        }

        @Override
        public boolean handleKeyword(String string) {
            switch (string) {
                case "\r": 
                case "\n": 
                case "par": {
                    if (this.this$0.decoderBB.position() == 1) {
                        this.handleText(RTFReader.REPLACEMENT_CHAR);
                        this.this$0.decoderBB.clear();
                        this.this$0.decoderBB.limit(1);
                    }
                    this.endParagraph();
                    return true;
                }
                case "sect": {
                    this.endSection();
                    return true;
                }
            }
            return super.handleKeyword(string);
        }

        protected void beginParagraph() {
            this.inParagraph = true;
        }

        protected void endParagraph() {
            AttrSet attrSet = this.currentParagraphAttributes();
            AttrSet attrSet2 = this.currentTextAttributes();
            this.finishParagraph(attrSet, attrSet2);
            this.inParagraph = false;
        }
    }

    abstract class AttributeTrackingDestination
    extends Destination {
        private AttrSet characterAttributes;
        private AttrSet paragraphAttributes;
        private AttrSet sectionAttributes;
        final /* synthetic */ RTFReader this$0;

        @Override
        public abstract void handleText(String var1);

        public AttributeTrackingDestination(RTFReader rTFReader) {
            RTFReader rTFReader2 = rTFReader;
            Objects.requireNonNull(rTFReader2);
            this.this$0 = rTFReader2;
            this.characterAttributes = this.rootCharacterAttributes();
            rTFReader.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = this.rootParagraphAttributes();
            rTFReader.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = this.rootSectionAttributes();
            rTFReader.parserState.put("sec", this.sectionAttributes);
        }

        @Override
        public void begingroup() {
            AttrSet attrSet = this.currentTextAttributes();
            AttrSet attrSet2 = this.currentParagraphAttributes();
            AttrSet attrSet3 = this.currentSectionAttributes();
            this.characterAttributes = new AttrSet();
            this.characterAttributes.addAttributes(attrSet);
            this.this$0.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = new AttrSet();
            this.paragraphAttributes.addAttributes(attrSet2);
            this.this$0.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = new AttrSet();
            this.sectionAttributes.addAttributes(attrSet3);
            this.this$0.parserState.put("sec", this.sectionAttributes);
        }

        @Override
        public void endgroup(Map<Object, Object> map) {
            this.characterAttributes = (AttrSet)this.this$0.parserState.get("chr");
            this.paragraphAttributes = (AttrSet)this.this$0.parserState.get("pgf");
            this.sectionAttributes = (AttrSet)this.this$0.parserState.get("sec");
        }

        @Override
        public boolean handleKeyword(String string) {
            if (string.equals("ulnone")) {
                return this.handleKeyword("ul", 0);
            }
            Object object = straightforwardAttributes.get(string);
            if (object != null) {
                int n;
                switch (((RTFAttribute)object).domain()) {
                    case 0: {
                        n = ((RTFAttribute)object).set(this.characterAttributes) ? 1 : 0;
                        break;
                    }
                    case 1: {
                        n = ((RTFAttribute)object).set(this.paragraphAttributes) ? 1 : 0;
                        break;
                    }
                    case 2: {
                        n = ((RTFAttribute)object).set(this.sectionAttributes) ? 1 : 0;
                        break;
                    }
                    case 4: {
                        this.this$0.holder.backing = this.this$0.parserState;
                        n = ((RTFAttribute)object).set(this.this$0.holder) ? 1 : 0;
                        this.this$0.holder.backing = null;
                        break;
                    }
                    case 3: {
                        n = ((RTFAttribute)object).set(this.this$0.documentAttributes) ? 1 : 0;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                if (n != 0) {
                    return true;
                }
            }
            switch (string) {
                case "plain": {
                    this.resetCharacterAttributes();
                    return true;
                }
                case "pard": {
                    this.resetParagraphAttributes();
                    return true;
                }
                case "sectd": {
                    this.resetSectionAttributes();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean handleKeyword(String string, int n) {
            if (string.equals("fc")) {
                string = "cf";
            }
            switch (string) {
                case "f": {
                    this.this$0.parserState.put(string, n);
                    if (this.this$0.decoderBB.position() == 1) {
                        this.handleText(RTFReader.REPLACEMENT_CHAR);
                    }
                    this.this$0.decoderBB.clear();
                    this.this$0.decoderBB.limit(1);
                    Charset charset = this.this$0.fcharsetTable.get(n);
                    if (charset != null) {
                        this.this$0.decoder = charset.newDecoder();
                        this.this$0.decoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                    } else {
                        this.this$0.decoder = null;
                    }
                    return true;
                }
                case "cf": {
                    this.this$0.parserState.put(string, n);
                    return true;
                }
                case "cb": {
                    this.this$0.parserState.put(string, n);
                    return true;
                }
            }
            Object object = straightforwardAttributes.get(string);
            if (object != null) {
                int n2;
                switch (((RTFAttribute)object).domain()) {
                    case 0: {
                        n2 = ((RTFAttribute)object).set(this.characterAttributes, n) ? 1 : 0;
                        break;
                    }
                    case 1: {
                        n2 = ((RTFAttribute)object).set(this.paragraphAttributes, n) ? 1 : 0;
                        break;
                    }
                    case 2: {
                        n2 = ((RTFAttribute)object).set(this.sectionAttributes, n) ? 1 : 0;
                        break;
                    }
                    case 4: {
                        this.this$0.holder.backing = this.this$0.parserState;
                        n2 = ((RTFAttribute)object).set(this.this$0.holder, n) ? 1 : 0;
                        this.this$0.holder.backing = null;
                        break;
                    }
                    case 3: {
                        n2 = ((RTFAttribute)object).set(this.this$0.documentAttributes, n) ? 1 : 0;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
                if (n2 != 0) {
                    return true;
                }
            }
            switch (string) {
                case "fs": {
                    this.characterAttributes.addAttribute(StyleAttributeMap.FONT_SIZE, (double)n / 2.0);
                    return true;
                }
            }
            if (string.equals("s") && this.this$0.paragraphStyles != null) {
                this.this$0.parserState.put("paragraphStyle", this.this$0.paragraphStyles.get(n));
                return true;
            }
            if (string.equals("cs") && this.this$0.characterStyles != null) {
                this.this$0.parserState.put("characterStyle", this.this$0.characterStyles.get(n));
                return true;
            }
            if (string.equals("ds") && this.this$0.sectionStyles != null) {
                this.this$0.parserState.put("sectionStyle", this.this$0.sectionStyles.get(n));
                return true;
            }
            return false;
        }

        protected AttrSet rootCharacterAttributes() {
            AttrSet attrSet = new AttrSet();
            attrSet.setItalic(false);
            attrSet.setBold(false);
            attrSet.setUnderline(false);
            attrSet.setForeground(Color.BLACK);
            return attrSet;
        }

        protected AttrSet rootParagraphAttributes() {
            AttrSet attrSet = new AttrSet();
            attrSet.setLeftIndent(0.0);
            attrSet.setRightIndent(0.0);
            attrSet.setFirstLineIndent(0.0);
            attrSet.setResolveParent(this.this$0.getDefaultStyle());
            return attrSet;
        }

        protected AttrSet rootSectionAttributes() {
            AttrSet attrSet = new AttrSet();
            return attrSet;
        }

        AttrSet currentTextAttributes() {
            Color color;
            Object object;
            AttrSet attrSet = new AttrSet(this.characterAttributes);
            Integer n = (Integer)this.this$0.parserState.get("f");
            String string = n != null ? this.this$0.fontTable.get(n) : null;
            attrSet.setFontFamily(string);
            if (this.this$0.colorTable != null) {
                object = (Integer)this.this$0.parserState.get("cf");
                if (object != null) {
                    color = this.this$0.colorTable[(Integer)object];
                    attrSet.setForeground(color);
                } else {
                    attrSet.setForeground(null);
                }
            }
            if (this.this$0.colorTable != null) {
                object = (Integer)this.this$0.parserState.get("cb");
                if (object != null) {
                    color = this.this$0.colorTable[(Integer)object];
                    attrSet.setBackground(color);
                } else {
                    attrSet.setBackground(null);
                }
            }
            if ((object = (Style)this.this$0.parserState.get("characterStyle")) != null) {
                attrSet.setResolveParent((AttrSet)object);
            }
            return attrSet;
        }

        AttrSet currentParagraphAttributes() {
            AttrSet attrSet = new AttrSet(this.paragraphAttributes);
            Style style = (Style)this.this$0.parserState.get("paragraphStyle");
            if (style != null) {
                attrSet.setResolveParent(style);
            }
            return attrSet;
        }

        public AttrSet currentSectionAttributes() {
            AttrSet attrSet = new AttrSet(this.sectionAttributes);
            Style style = (Style)this.this$0.parserState.get("sectionStyle");
            if (style != null) {
                attrSet.setResolveParent(style);
            }
            return attrSet;
        }

        protected void resetCharacterAttributes() {
            this.handleKeyword("f", 0);
            this.handleKeyword("cf", 0);
            this.handleKeyword("fs", 24);
            for (RTFAttribute rTFAttribute : straightforwardAttributes.values()) {
                if (rTFAttribute.domain() != 0) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
            this.handleKeyword("sl", 1000);
            this.this$0.parserState.remove("characterStyle");
        }

        protected void resetParagraphAttributes() {
            this.this$0.parserState.remove("_tabs");
            this.this$0.parserState.remove("_tabs_immutable");
            this.this$0.parserState.remove("paragraphStyle");
            this.paragraphAttributes.setAlignment(TextAlignment.LEFT);
            for (RTFAttribute rTFAttribute : straightforwardAttributes.values()) {
                if (rTFAttribute.domain() != 1) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
        }

        protected void resetSectionAttributes() {
            for (RTFAttribute rTFAttribute : straightforwardAttributes.values()) {
                if (rTFAttribute.domain() != 2) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
            this.this$0.parserState.remove("sectionStyle");
        }
    }
}

