/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ContextMenuContent;
import com.sun.javafx.scene.control.EmbeddedTextContextMenuContent;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusPopupBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.WindowEvent;

public class ContextMenuSkin
implements Skin<ContextMenu> {
    private ContextMenu popupMenu;
    private final Region root;
    private TwoLevelFocusPopupBehavior tlFocus;
    private double prefHeight;
    private double shiftY;
    private double prefWidth;
    private double shiftX;
    private final EventHandler<KeyEvent> keyListener = new EventHandler<KeyEvent>(this){
        final /* synthetic */ ContextMenuSkin this$0;
        {
            ContextMenuSkin contextMenuSkin2 = contextMenuSkin;
            Objects.requireNonNull(contextMenuSkin2);
            this.this$0 = contextMenuSkin2;
        }

        public void handle(KeyEvent keyEvent) {
            if (keyEvent.getEventType() != KeyEvent.KEY_PRESSED) {
                return;
            }
            if (!this.this$0.root.isFocused()) {
                return;
            }
            KeyCode keyCode = keyEvent.getCode();
            switch (keyCode) {
                case ENTER: 
                case SPACE: {
                    this.this$0.popupMenu.hide();
                    return;
                }
            }
        }
    };

    public ContextMenuSkin(ContextMenu contextMenu) {
        this.popupMenu = contextMenu;
        this.popupMenu.addEventHandler(Menu.ON_SHOWING, (EventHandler)new EventHandler<Event>(this){
            final /* synthetic */ ContextMenuSkin this$0;
            {
                ContextMenuSkin contextMenuSkin2 = contextMenuSkin;
                Objects.requireNonNull(contextMenuSkin2);
                this.this$0 = contextMenuSkin2;
            }

            public void handle(Event event) {
                this.this$0.prefHeight = this.this$0.root.prefHeight(-1.0);
                this.this$0.prefWidth = this.this$0.root.prefWidth(-1.0);
            }
        });
        this.popupMenu.addEventHandler(Menu.ON_SHOWN, (EventHandler)new EventHandler<Event>(this){
            final /* synthetic */ ContextMenuSkin this$0;
            {
                ContextMenuSkin contextMenuSkin2 = contextMenuSkin;
                Objects.requireNonNull(contextMenuSkin2);
                this.this$0 = contextMenuSkin2;
            }

            public void handle(Event event) {
                Node node = this.this$0.popupMenu.getSkin().getNode();
                if (node != null && node instanceof ContextMenuContent) {
                    VBox vBox = ((ContextMenuContent)node).getItemsContainer();
                    vBox.notifyAccessibleAttributeChanged(AccessibleAttribute.VISIBLE);
                }
                this.this$0.root.addEventHandler(KeyEvent.KEY_PRESSED, this.this$0.keyListener);
                this.this$0.performPopupShifts();
            }
        });
        this.popupMenu.addEventHandler(Menu.ON_HIDDEN, (EventHandler)new EventHandler<Event>(this){
            final /* synthetic */ ContextMenuSkin this$0;
            {
                ContextMenuSkin contextMenuSkin2 = contextMenuSkin;
                Objects.requireNonNull(contextMenuSkin2);
                this.this$0 = contextMenuSkin2;
            }

            public void handle(Event event) {
                Node node = this.this$0.popupMenu.getSkin().getNode();
                if (node != null) {
                    node.requestFocus();
                }
                this.this$0.root.removeEventHandler(KeyEvent.KEY_PRESSED, this.this$0.keyListener);
            }
        });
        this.popupMenu.addEventFilter(WindowEvent.WINDOW_HIDING, (EventHandler)new EventHandler<Event>(this){
            final /* synthetic */ ContextMenuSkin this$0;
            {
                ContextMenuSkin contextMenuSkin2 = contextMenuSkin;
                Objects.requireNonNull(contextMenuSkin2);
                this.this$0 = contextMenuSkin2;
            }

            public void handle(Event event) {
                Node node = this.this$0.popupMenu.getSkin().getNode();
                if (node instanceof ContextMenuContent) {
                    VBox vBox = ((ContextMenuContent)node).getItemsContainer();
                    vBox.notifyAccessibleAttributeChanged(AccessibleAttribute.VISIBLE);
                }
            }
        });
        this.root = Properties.IS_TOUCH_SUPPORTED && this.popupMenu.getStyleClass().contains((Object)"text-input-context-menu") ? new EmbeddedTextContextMenuContent(this.popupMenu) : new ContextMenuContent(this.popupMenu);
        this.root.idProperty().bind((ObservableValue)this.popupMenu.idProperty());
        this.root.styleProperty().bind((ObservableValue)this.popupMenu.styleProperty());
        this.root.getStyleClass().addAll(this.popupMenu.getStyleClass());
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusPopupBehavior(this.popupMenu);
        }
    }

    @Override
    public ContextMenu getSkinnable() {
        return this.popupMenu;
    }

    @Override
    public Node getNode() {
        return this.root;
    }

    @Override
    public void dispose() {
        this.root.idProperty().unbind();
        this.root.styleProperty().unbind();
        Region region = this.root;
        if (region instanceof ContextMenuContent) {
            ContextMenuContent contextMenuContent = (ContextMenuContent)region;
            contextMenuContent.disposeListeners();
        }
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
    }

    private void performPopupShifts() {
        ContextMenu contextMenu = this.getSkinnable();
        Node node = contextMenu.getOwnerNode();
        if (node == null) {
            return;
        }
        Bounds bounds = node.localToScreen(node.getLayoutBounds());
        if (bounds == null) {
            return;
        }
        double d = this.root.prefHeight(-1.0);
        this.shiftY = this.prefHeight - d;
        if (this.shiftY > 0.0 && contextMenu.getY() + d < bounds.getMinY()) {
            contextMenu.setY(contextMenu.getY() + this.shiftY);
        }
        double d2 = this.root.prefWidth(-1.0);
        this.shiftX = this.prefWidth - d2;
        if (this.shiftX > 0.0 && contextMenu.getX() + d2 < bounds.getMinX()) {
            contextMenu.setX(contextMenu.getX() + this.shiftX);
        }
    }
}

