/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.webkit.network.ByteBufferAllocator;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;

final class ByteBufferPool {
    private final Queue<ByteBuffer> byteBuffers = new ConcurrentLinkedQueue<ByteBuffer>();
    private final int bufferSize;

    private ByteBufferPool(int n) {
        this.bufferSize = n;
    }

    static ByteBufferPool newInstance(int n) {
        return new ByteBufferPool(n);
    }

    ByteBufferAllocator newAllocator(int n) {
        return new ByteBufferAllocatorImpl(this, n);
    }

    private final class ByteBufferAllocatorImpl
    implements ByteBufferAllocator {
        private final Semaphore semaphore;
        final /* synthetic */ ByteBufferPool this$0;

        private ByteBufferAllocatorImpl(ByteBufferPool byteBufferPool, int n) {
            ByteBufferPool byteBufferPool2 = byteBufferPool;
            Objects.requireNonNull(byteBufferPool2);
            this.this$0 = byteBufferPool2;
            this.semaphore = new Semaphore(n);
        }

        @Override
        public ByteBuffer allocate() throws InterruptedException {
            this.semaphore.acquire();
            ByteBuffer byteBuffer = this.this$0.byteBuffers.poll();
            if (byteBuffer == null) {
                byteBuffer = ByteBuffer.allocateDirect(this.this$0.bufferSize);
            }
            return byteBuffer;
        }

        @Override
        public void release(ByteBuffer byteBuffer) {
            byteBuffer.clear();
            this.this$0.byteBuffers.add(byteBuffer);
            this.semaphore.release();
        }
    }
}

