/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGDefaultCamera;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.d3d12.D3D12MeshView;
import com.sun.prism.d3d12.D3D12RTTexture;
import com.sun.prism.d3d12.D3D12ResourceFactory;
import com.sun.prism.d3d12.D3D12Texture;
import com.sun.prism.d3d12.ni.D3D12NativeDevice;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.ps.Shader;

class D3D12Context
extends BaseShaderContext {
    public static final int NUM_QUADS = PrismSettings.superShader ? 4096 : 256;
    private D3D12NativeDevice mDevice;
    private D3D12RTTexture mCurrentRT;
    private BaseShaderContext.State mState;
    private Vec3d mCameraPos = new Vec3d();
    private static final Affine3D mScratchAffine3DTx = new Affine3D();
    private GeneralTransform3D mScratchTx = new GeneralTransform3D();
    private GeneralTransform3D mViewProjTx = new GeneralTransform3D();
    private static double[] tempAdjustClipSpaceMat = new double[16];

    D3D12Context(D3D12NativeDevice d3D12NativeDevice, Screen screen, D3D12ResourceFactory d3D12ResourceFactory) {
        super(screen, d3D12ResourceFactory, NUM_QUADS);
        if (!d3D12NativeDevice.isValid()) {
            throw new NullPointerException("D3D12 device is NULL");
        }
        this.mDevice = d3D12NativeDevice;
        this.mState = new BaseShaderContext.State();
    }

    D3D12NativeDevice getDevice() {
        return this.mDevice;
    }

    int getMSAASampleSize(PixelFormat pixelFormat) {
        int n = this.mDevice.getMaximumMSAASampleSize(pixelFormat);
        return n < 2 ? 1 : (n < 4 ? 2 : 4);
    }

    private GeneralTransform3D adjustClipSpace(GeneralTransform3D generalTransform3D) {
        double[] dArray = generalTransform3D.get(tempAdjustClipSpaceMat);
        dArray[8] = (dArray[8] + dArray[12]) / 2.0;
        dArray[9] = (dArray[9] + dArray[13]) / 2.0;
        dArray[10] = (dArray[10] + dArray[14]) / 2.0;
        dArray[11] = (dArray[11] + dArray[15]) / 2.0;
        generalTransform3D.set(dArray);
        return generalTransform3D;
    }

    @Override
    protected BaseShaderContext.State updateRenderTarget(RenderTarget renderTarget, NGCamera nGCamera, boolean bl) {
        if (this.checkDisposed()) {
            return null;
        }
        this.mCurrentRT = (D3D12RTTexture)renderTarget;
        this.mDevice.setRenderTarget(this.mCurrentRT.getNativeRenderTarget(), bl);
        int n = this.mCurrentRT.getWidth();
        int n2 = this.mCurrentRT.getHeight();
        if (nGCamera instanceof NGDefaultCamera) {
            ((NGDefaultCamera)nGCamera).validate(n, n2);
            this.mViewProjTx = this.adjustClipSpace(nGCamera.getProjViewTx(this.mViewProjTx));
        } else if (nGCamera != null) {
            this.mViewProjTx = this.adjustClipSpace(nGCamera.getProjViewTx(this.mViewProjTx));
            double d = nGCamera.getViewWidth();
            double d2 = nGCamera.getViewHeight();
            if ((double)n != d || (double)n2 != d2) {
                this.mViewProjTx.scale(d / (double)n, d2 / (double)n2, 1.0);
            }
        }
        this.mDevice.setViewProjTransform(this.mViewProjTx);
        this.mCameraPos = nGCamera.getPositionInWorld(this.mCameraPos);
        return this.mState;
    }

    @Override
    protected void updateTexture(int n, Texture texture) {
        D3D12Texture d3D12Texture = (D3D12Texture)texture;
        if (d3D12Texture != null) {
            d3D12Texture.getNativeTexture().setSamplerParameters(texture.getWrapMode(), texture.getLinearFiltering());
            this.mDevice.setTexture(n, d3D12Texture.getNativeTexture());
        } else {
            this.mDevice.setTexture(n, null);
        }
    }

    @Override
    protected void updateShaderTransform(Shader shader, BaseTransform baseTransform) {
        if (baseTransform == null) {
            baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        }
        GeneralTransform3D generalTransform3D = this.getPerspectiveTransformNoClone();
        if (baseTransform.isIdentity() && generalTransform3D.isIdentity()) {
            this.mDevice.setWorldTransform(BaseTransform.IDENTITY_TRANSFORM);
        } else if (generalTransform3D.isIdentity()) {
            this.mDevice.setWorldTransform(baseTransform);
        } else {
            this.mScratchTx.setIdentity().mul(baseTransform).mul(generalTransform3D);
            this.mDevice.setWorldTransform(this.mScratchTx);
        }
    }

    @Override
    protected void updateWorldTransform(BaseTransform baseTransform) {
        if (baseTransform == null) {
            this.mDevice.setWorldTransform(BaseTransform.IDENTITY_TRANSFORM);
        } else {
            this.mDevice.setWorldTransform(baseTransform);
        }
    }

    @Override
    protected void updateClipRect(Rectangle rectangle) {
        if (rectangle == null || rectangle.isEmpty()) {
            this.mDevice.setScissor(false, 0, 0, this.mCurrentRT.getWidth(), this.mCurrentRT.getHeight());
        } else {
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = n + rectangle.width;
            int n4 = n2 + rectangle.height;
            this.mDevice.setScissor(true, n, n2, n3, n4);
        }
    }

    @Override
    protected void updateCompositeMode(CompositeMode compositeMode) {
        this.mDevice.setCompositeMode(compositeMode);
    }

    @Override
    public void blit(RTTexture rTTexture, RTTexture rTTexture2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        D3D12RTTexture d3D12RTTexture = (D3D12RTTexture)rTTexture;
        D3D12RTTexture d3D12RTTexture2 = (D3D12RTTexture)rTTexture2;
        this.mDevice.blit(d3D12RTTexture.getNativeRenderTarget(), n, n2, n3, n4, d3D12RTTexture2.getNativeRenderTarget(), n5, n6, n7, n8);
    }

    void renderMeshView(D3D12MeshView d3D12MeshView, Graphics graphics) {
        this.mScratchTx = this.mScratchTx.set(this.mViewProjTx);
        float f = graphics.getPixelScaleFactorX();
        float f2 = graphics.getPixelScaleFactorY();
        if ((double)f != 1.0 || (double)f2 != 1.0) {
            this.mScratchTx.scale(f, f2, 1.0);
        }
        this.mDevice.setViewProjTransform(this.mScratchTx);
        this.mDevice.setCameraPos(this.mCameraPos);
        BaseTransform baseTransform = graphics.getTransformNoClone();
        if ((double)f != 1.0 || (double)f2 != 1.0) {
            mScratchAffine3DTx.setToIdentity();
            mScratchAffine3DTx.scale(1.0 / (double)f, 1.0 / (double)f2);
            mScratchAffine3DTx.concatenate(baseTransform);
            this.updateWorldTransform(mScratchAffine3DTx);
        } else {
            this.updateWorldTransform(baseTransform);
        }
        this.mDevice.renderMeshView(d3D12MeshView.getNativeMeshView());
    }

    @Override
    protected void renderQuads(float[] fArray, byte[] byArray, int n) {
        this.mDevice.renderQuads(fArray, byArray, n);
    }

    @Override
    public void dispose() {
        this.mDevice.close();
        super.dispose();
    }
}

