/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.prism.Image;
import com.sun.prism.PhongMaterial;
import com.sun.prism.Texture;
import com.sun.prism.TextureMap;
import com.sun.prism.d3d12.D3D12Context;
import com.sun.prism.d3d12.D3D12Texture;
import com.sun.prism.d3d12.ni.D3D12NativePhongMaterial;
import com.sun.prism.d3d12.ni.D3D12NativeTexture;
import com.sun.prism.impl.BasePhongMaterial;
import com.sun.prism.impl.Disposer;

class D3D12PhongMaterial
extends BasePhongMaterial {
    private final D3D12Context mContext;
    private final D3D12PhongMaterialData mMaterialData;
    private final TextureMap[] maps = new TextureMap[MAX_MAP_TYPE];

    private D3D12PhongMaterial(D3D12Context d3D12Context, D3D12PhongMaterialData d3D12PhongMaterialData) {
        super(d3D12PhongMaterialData);
        this.mContext = d3D12Context;
        this.mMaterialData = d3D12PhongMaterialData;
    }

    public static D3D12PhongMaterial create(D3D12Context d3D12Context) {
        return new D3D12PhongMaterial(d3D12Context, new D3D12PhongMaterialData(d3D12Context.getDevice().createPhongMaterial()));
    }

    D3D12NativePhongMaterial getNative() {
        return this.mMaterialData.getNative();
    }

    @Override
    public void setDiffuseColor(float f, float f2, float f3, float f4) {
        this.mMaterialData.getNative().setDiffuseColor(f, f2, f3, f4);
    }

    @Override
    public void setSpecularColor(boolean bl, float f, float f2, float f3, float f4) {
        this.mMaterialData.getNative().setSpecularColor(bl, f, f2, f3, f4);
    }

    @Override
    public void setTextureMap(TextureMap textureMap) {
        this.maps[textureMap.getType().ordinal()] = textureMap;
    }

    private Texture setupTexture(TextureMap textureMap, boolean bl) {
        Image image = textureMap.getImage();
        Texture texture = image == null ? null : this.mContext.getResourceFactory().getCachedTexture(image, Texture.WrapMode.REPEAT, bl);
        D3D12NativeTexture d3D12NativeTexture = texture == null ? null : ((D3D12Texture)texture).getNativeTexture();
        this.mMaterialData.getNative().setTextureMap(d3D12NativeTexture, textureMap.getType());
        return texture;
    }

    @Override
    public void lockTextureMaps() {
        for (int i = 0; i < MAX_MAP_TYPE; ++i) {
            Texture texture = this.maps[i].getTexture();
            if (!this.maps[i].isDirty() && texture != null) {
                texture.lock();
                if (!texture.isSurfaceLost()) continue;
            }
            boolean bl = i == PhongMaterial.DIFFUSE || i == PhongMaterial.SELF_ILLUM;
            texture = this.setupTexture(this.maps[i], bl);
            this.maps[i].setTexture(texture);
            this.maps[i].setDirty(false);
            if (this.maps[i].getImage() == null || texture != null) continue;
            String string = PhongMaterial.class.getName();
            PlatformLogger.getLogger((String)string).warning("Warning: Low on texture resources. Cannot create texture.");
        }
    }

    @Override
    public void unlockTextureMaps() {
        for (int i = 0; i < MAX_MAP_TYPE; ++i) {
            Texture texture = this.maps[i].getTexture();
            if (texture == null) continue;
            texture.unlock();
        }
    }

    @Override
    public void dispose() {
        this.disposerRecord.dispose();
    }

    static class D3D12PhongMaterialData
    implements Disposer.Record {
        D3D12NativePhongMaterial mMaterial;

        D3D12PhongMaterialData(D3D12NativePhongMaterial d3D12NativePhongMaterial) {
            if (!d3D12NativePhongMaterial.isValid()) {
                throw new NullPointerException("Phong material object is NULL");
            }
            this.mMaterial = d3D12NativePhongMaterial;
        }

        D3D12NativePhongMaterial getNative() {
            return this.mMaterial;
        }

        @Override
        public void dispose() {
            if (this.mMaterial.isValid()) {
                this.mMaterial.close();
            }
        }
    }
}

