/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.prism.d3d12.D3D12Context;
import com.sun.prism.d3d12.D3D12ShaderData;
import com.sun.prism.d3d12.D3D12Utils;
import com.sun.prism.d3d12.ni.D3D12NativeShader;
import com.sun.prism.impl.BaseGraphicsResource;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.ps.Shader;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Map;

public class D3D12Shader
extends BaseGraphicsResource
implements Shader {
    private final IntBuffer mIntBuffer = BufferUtil.newIntBuffer(4);
    private final FloatBuffer mFloatBuffer = BufferUtil.newFloatBuffer(4);
    private final D3D12Context mContext;
    private final D3D12ShaderData mResource;

    D3D12Shader(D3D12ShaderData d3D12ShaderData, D3D12Context d3D12Context) {
        super(d3D12ShaderData);
        this.mContext = d3D12Context;
        this.mResource = d3D12ShaderData;
    }

    public static D3D12Shader create(D3D12Context d3D12Context, String string, InputStream inputStream, Map<String, Integer> map, Map<String, Integer> map2) {
        D3D12NativeShader d3D12NativeShader = d3D12Context.getDevice().createShader(string, D3D12Utils.getShaderCodeBuffer(inputStream));
        return new D3D12Shader(new D3D12ShaderData(d3D12NativeShader), d3D12Context);
    }

    @Override
    public void enable() {
        this.mContext.getDevice().setPixelShader(this.mResource.getShader());
    }

    @Override
    public void disable() {
        this.mContext.getDevice().setPixelShader(null);
    }

    @Override
    public boolean isValid() {
        return this.mResource.isValid();
    }

    @Override
    public void setConstant(String string, int n) {
        this.mIntBuffer.clear();
        this.mIntBuffer.put(n);
        this.setConstants(string, this.mIntBuffer, 0, 1);
    }

    @Override
    public void setConstant(String string, int n, int n2) {
        this.mIntBuffer.clear();
        this.mIntBuffer.put(n);
        this.mIntBuffer.put(n2);
        this.setConstants(string, this.mIntBuffer, 0, 1);
    }

    @Override
    public void setConstant(String string, int n, int n2, int n3) {
        this.mIntBuffer.clear();
        this.mIntBuffer.put(n);
        this.mIntBuffer.put(n2);
        this.mIntBuffer.put(n3);
        this.setConstants(string, this.mIntBuffer, 0, 1);
    }

    @Override
    public void setConstant(String string, int n, int n2, int n3, int n4) {
        this.mIntBuffer.clear();
        this.mIntBuffer.put(n);
        this.mIntBuffer.put(n2);
        this.mIntBuffer.put(n3);
        this.mIntBuffer.put(n4);
        this.setConstants(string, this.mIntBuffer, 0, 1);
    }

    @Override
    public void setConstant(String string, float f) {
        this.mFloatBuffer.clear();
        this.mFloatBuffer.put(f);
        this.setConstants(string, this.mFloatBuffer, 0, 1);
    }

    @Override
    public void setConstant(String string, float f, float f2) {
        this.mFloatBuffer.clear();
        this.mFloatBuffer.put(f);
        this.mFloatBuffer.put(f2);
        this.setConstants(string, this.mFloatBuffer, 0, 1);
    }

    @Override
    public void setConstant(String string, float f, float f2, float f3) {
        this.mFloatBuffer.clear();
        this.mFloatBuffer.put(f);
        this.mFloatBuffer.put(f2);
        this.mFloatBuffer.put(f3);
        this.setConstants(string, this.mFloatBuffer, 0, 1);
    }

    @Override
    public void setConstant(String string, float f, float f2, float f3, float f4) {
        this.mFloatBuffer.clear();
        this.mFloatBuffer.put(f);
        this.mFloatBuffer.put(f2);
        this.mFloatBuffer.put(f3);
        this.mFloatBuffer.put(f4);
        this.setConstants(string, this.mFloatBuffer, 0, 1);
    }

    @Override
    public void setConstants(String string, IntBuffer intBuffer, int n, int n2) {
        this.mContext.getDevice().setShaderConstants(this.mResource.getShader(), string, intBuffer, n, n2 * 4);
    }

    @Override
    public void setConstants(String string, FloatBuffer floatBuffer, int n, int n2) {
        this.mContext.getDevice().setShaderConstants(this.mResource.getShader(), string, floatBuffer, n, n2 * 4);
    }

    @Override
    public void dispose() {
        this.mResource.dispose();
    }
}

