/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.glass.ui.Screen;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.ResourceFactory;
import com.sun.prism.d3d12.D3D12ResourceFactory;
import com.sun.prism.d3d12.D3D12Utils;
import com.sun.prism.d3d12.ni.D3D12AdapterInformation;
import com.sun.prism.d3d12.ni.D3D12DeviceInformation;
import com.sun.prism.d3d12.ni.D3D12NativeInstance;
import com.sun.prism.d3d12.ni.D3D12NativeShader;
import com.sun.prism.impl.PrismSettings;
import java.nio.ByteBuffer;
import java.util.List;

public final class D3D12Pipeline
extends GraphicsPipeline {
    private static final Thread creator;
    private static boolean isEnabled;
    private static D3D12Pipeline theInstance;
    private static D3D12ResourceFactory[] mFactories;
    private D3D12NativeInstance mInstance;
    private D3D12ResourceFactory mDefaultFactory;
    private int mMaxMSAASamples;

    private static native boolean nInit(Class var0);

    public static D3D12Pipeline getInstance() {
        return theInstance;
    }

    private D3D12Pipeline() {
    }

    private void printDeviceErrorInformation(D3D12DeviceInformation d3D12DeviceInformation) {
        if (d3D12DeviceInformation != null && d3D12DeviceInformation.deviceError != 0L) {
            System.out.println(String.format("D3D12 Device " + d3D12DeviceInformation.description + " error: %08X - " + d3D12DeviceInformation.deviceErrorReason, d3D12DeviceInformation.deviceError));
        }
    }

    private void printAdapterInformation(int n) {
        D3D12AdapterInformation d3D12AdapterInformation = this.mInstance.getAdapterInformation(n);
        if (d3D12AdapterInformation != null) {
            System.out.println("OS Information:");
            System.out.println("\t" + d3D12AdapterInformation.getOsVersion() + " build " + d3D12AdapterInformation.osBuildNumber);
            System.out.println("DXGI Adapter Information:");
            System.out.println("\t" + d3D12AdapterInformation.description);
            System.out.println("\tDevice ID: " + d3D12AdapterInformation.getDeviceID());
            System.out.println("\tDevice Memory: " + d3D12AdapterInformation.getDeviceMemory());
        }
    }

    private void printDeviceInformation(int n) {
        D3D12DeviceInformation d3D12DeviceInformation = this.mInstance.getDeviceInformation(n);
        if (d3D12DeviceInformation != null) {
            System.out.println("D3D12 Device Information:");
            System.out.println("\t" + d3D12DeviceInformation.description);
            System.out.println("\tFeature Level: " + d3D12DeviceInformation.featureLevel);
            System.out.println("\tShader Model: " + d3D12DeviceInformation.shaderModel);
        }
    }

    private D3D12ResourceFactory createResourceFactory(int n, Screen screen) {
        return new D3D12ResourceFactory(this.mInstance, n, screen);
    }

    private D3D12ResourceFactory getD3D12ResourceFactory(int n, Screen screen) {
        D3D12ResourceFactory d3D12ResourceFactory = mFactories[n];
        if (d3D12ResourceFactory == null && screen != null) {
            D3D12Pipeline.mFactories[n] = d3D12ResourceFactory = this.createResourceFactory(n, screen);
        }
        return d3D12ResourceFactory;
    }

    private Screen getScreenForAdapter(List<Screen> list, int n) {
        for (Screen screen : list) {
            if (screen.getAdapterOrdinal() != n) continue;
            return screen;
        }
        return Screen.getMainScreen();
    }

    private D3D12ResourceFactory findDefaultResourceFactory(List<Screen> list) {
        for (int i = 0; i < mFactories.length; ++i) {
            D3D12DeviceInformation d3D12DeviceInformation = new D3D12DeviceInformation();
            if (this.mInstance.canCreateDevice(i, d3D12DeviceInformation)) {
                D3D12ResourceFactory d3D12ResourceFactory = this.getD3D12ResourceFactory(i, this.getScreenForAdapter(list, i));
                if (d3D12ResourceFactory == null) continue;
                if (PrismSettings.verbose) {
                    this.printAdapterInformation(i);
                    this.printDeviceInformation(i);
                }
                return d3D12ResourceFactory;
            }
            if (PrismSettings.disableBadDriverWarning) continue;
            this.printDeviceErrorInformation(d3D12DeviceInformation);
        }
        return null;
    }

    private void loadInternalShader(String string, D3D12NativeShader.PipelineMode pipelineMode, D3D12NativeShader.Visibility visibility) throws RuntimeException {
        ByteBuffer byteBuffer = D3D12Utils.getShaderCodeBuffer("hlsl6/Native/" + string + ".cso");
        if (!this.mInstance.loadInternalSahder(string, pipelineMode, visibility, byteBuffer)) {
            throw new RuntimeException("Failed to load " + string + " internal shader");
        }
    }

    private void loadInternalShaders() {
        this.loadInternalShader("PassThroughVS", D3D12NativeShader.PipelineMode.UI_2D, D3D12NativeShader.Visibility.VERTEX);
        this.loadInternalShader("MipmapGenCS", D3D12NativeShader.PipelineMode.COMPUTE, D3D12NativeShader.Visibility.ALL);
        this.loadInternalShader("BlitPS", D3D12NativeShader.PipelineMode.UI_2D, D3D12NativeShader.Visibility.PIXEL);
        this.loadInternalShader("Mtl1VS", D3D12NativeShader.PipelineMode.PHONG_3D, D3D12NativeShader.Visibility.VERTEX);
        this.loadInternalShader("Mtl1PS", D3D12NativeShader.PipelineMode.PHONG_3D, D3D12NativeShader.Visibility.PIXEL);
        this.loadInternalShader("Mtl1PS_i", D3D12NativeShader.PipelineMode.PHONG_3D, D3D12NativeShader.Visibility.PIXEL);
        String[] stringArray = new String[]{"", "i"};
        char[] cArray = new char[]{'s', 'b'};
        char[] cArray2 = new char[]{'1', '2', '3'};
        char[] cArray3 = new char[]{'n', 't', 'c', 'm'};
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < cArray.length; ++j) {
                for (int k = 0; k < cArray3.length; ++k) {
                    for (int i2 = 0; i2 < cArray2.length; ++i2) {
                        String string = "Mtl1PS_" + cArray[j] + cArray2[i2] + cArray3[k] + stringArray[i];
                        this.loadInternalShader(string, D3D12NativeShader.PipelineMode.PHONG_3D, D3D12NativeShader.Visibility.PIXEL);
                    }
                }
            }
        }
    }

    @Override
    public boolean init() {
        if (!isEnabled) {
            return false;
        }
        this.mInstance = new D3D12NativeInstance();
        if (!this.mInstance.Init()) {
            return false;
        }
        this.loadInternalShaders();
        mFactories = new D3D12ResourceFactory[this.mInstance.getAdapterCount()];
        return true;
    }

    @Override
    public void dispose() {
        if (creator != Thread.currentThread()) {
            throw new IllegalStateException("This operation is not permitted on the current thread [" + Thread.currentThread().getName() + "]");
        }
        for (int i = 0; i < mFactories.length; ++i) {
            if (mFactories[i] != null) {
                mFactories[i].dispose();
            }
            D3D12Pipeline.mFactories[i] = null;
        }
        mFactories = null;
        this.mInstance.close();
        theInstance = null;
        super.dispose();
    }

    @Override
    public int getAdapterOrdinal(Screen screen) {
        return this.mInstance.getAdapterOrdinal(screen.getNativeScreen());
    }

    @Override
    public ResourceFactory getResourceFactory(Screen screen) {
        return this.getD3D12ResourceFactory(screen.getAdapterOrdinal(), screen);
    }

    @Override
    public ResourceFactory getDefaultResourceFactory(List<Screen> list) {
        if (this.mDefaultFactory == null) {
            this.mDefaultFactory = this.findDefaultResourceFactory(list);
        }
        return this.mDefaultFactory;
    }

    @Override
    public boolean is3DSupported() {
        return true;
    }

    @Override
    public boolean isMSAASupported() {
        return true;
    }

    @Override
    public boolean isVsyncSupported() {
        return true;
    }

    @Override
    public boolean supportsShaderType(GraphicsPipeline.ShaderType shaderType) {
        switch (shaderType) {
            case HLSL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsShaderModel(GraphicsPipeline.ShaderModel shaderModel) {
        switch (shaderModel) {
            case SM6: {
                return true;
            }
        }
        return false;
    }

    static {
        if (PrismSettings.verbose) {
            System.out.println("Loading D3D12 native library ...");
        }
        NativeLibLoader.loadLibrary("prism_d3d12");
        if (PrismSettings.verbose) {
            System.out.println("\tsucceeded.");
        }
        isEnabled = D3D12Pipeline.nInit(PrismSettings.class);
        creator = Thread.currentThread();
        if (isEnabled) {
            theInstance = new D3D12Pipeline();
        }
    }
}

