/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.prism.MediaFrame;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class D3D12Utils {
    static ByteBuffer getShaderCodeBuffer(InputStream inputStream) {
        ByteBuffer byteBuffer;
        if (inputStream == null) {
            throw new RuntimeException("InputStream must be non-null");
        }
        int n = 4096;
        Object object = new byte[n];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n);
        try {
            Object object2;
            int n2 = 0;
            int n3 = -1;
            while ((n3 = bufferedInputStream.read((byte[])object, n2, n - n2)) != -1) {
                if (n - (n2 += n3) != 0) continue;
                object2 = new byte[n *= 2];
                System.arraycopy(object, 0, object2, 0, ((byte[])object).length);
                object = object2;
            }
            bufferedInputStream.close();
            object2 = ByteBuffer.allocateDirect(n2);
            ((ByteBuffer)object2).put((byte[])object, 0, n2);
            byteBuffer = object2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error loading D3D shader object", iOException);
            }
        }
        bufferedInputStream.close();
        return byteBuffer;
    }

    static ByteBuffer getShaderCodeBuffer(String string) {
        return D3D12Utils.getShaderCodeBuffer(D3D12Utils.class.getResourceAsStream(string));
    }

    static class AutoReleasableMediaFrame
    implements AutoCloseable {
        private MediaFrame mediaFrame;

        public AutoReleasableMediaFrame(MediaFrame mediaFrame) {
            this.mediaFrame = mediaFrame;
            this.mediaFrame.holdFrame();
        }

        @Override
        public void close() {
            this.mediaFrame.releaseFrame();
        }

        public MediaFrame get() {
            return this.mediaFrame;
        }
    }
}

