/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12.ni;

import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.prism.CompositeMode;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.d3d12.ni.D3D12NativeMesh;
import com.sun.prism.d3d12.ni.D3D12NativeMeshView;
import com.sun.prism.d3d12.ni.D3D12NativeObject;
import com.sun.prism.d3d12.ni.D3D12NativePhongMaterial;
import com.sun.prism.d3d12.ni.D3D12NativeRenderTarget;
import com.sun.prism.d3d12.ni.D3D12NativeShader;
import com.sun.prism.d3d12.ni.D3D12NativeSwapChain;
import com.sun.prism.d3d12.ni.D3D12NativeTexture;
import com.sun.prism.d3d12.ni.DXGIFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public final class D3D12NativeDevice
extends D3D12NativeObject {
    D3D12NativeDevice(long l) {
        super(l);
    }

    @Override
    protected native void nReleaseNativeObject(long var1);

    private native boolean nCheckFormatSupport(long var1, int var3);

    private native long nCreateMesh(long var1);

    private native long nCreateMeshView(long var1, long var3);

    private native long nCreatePhongMaterial(long var1);

    private native long nCreateRenderTarget(long var1, long var3);

    private native long nCreateShader(long var1, String var3, ByteBuffer var4);

    private native long nCreateTexture(long var1, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, boolean var10);

    private native int nGetMaximumMSAASampleSize(long var1, int var3);

    private native int nGetMaximumTextureSize(long var1);

    private native void nClear(long var1, float var3, float var4, float var5, float var6, boolean var7);

    private native void nRenderMeshView(long var1, long var3);

    private native void nRenderQuads(long var1, float[] var3, byte[] var4, int var5);

    private native void nSetCompositeMode(long var1, int var3);

    private native void nSetPixelShader(long var1, long var3);

    private native void nSetRenderTarget(long var1, long var3, boolean var5);

    private native void nSetScissor(long var1, boolean var3, int var4, int var5, int var6, int var7);

    private native boolean nSetShaderConstantsF(long var1, long var3, String var5, FloatBuffer var6, int var7, int var8);

    private native boolean nSetShaderConstantsI(long var1, long var3, String var5, IntBuffer var6, int var7, int var8);

    private native void nSetTexture(long var1, int var3, long var4);

    private native void nSetCameraPos(long var1, double var3, double var5, double var7);

    private native void nSetViewProjTransform(long var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, double var33);

    private native void nSetWorldTransform(long var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, double var33);

    private native boolean nBlit(long var1, long var3, int var5, int var6, int var7, int var8, long var9, int var11, int var12, int var13, int var14);

    private native boolean nBlitToSwapChain(long var1, long var3, int var5, int var6, int var7, int var8, long var9, int var11, int var12, int var13, int var14);

    private native boolean nReadTextureB(long var1, long var3, ByteBuffer var5, byte[] var6, int var7, int var8, int var9, int var10);

    private native boolean nReadTextureI(long var1, long var3, IntBuffer var5, int[] var6, int var7, int var8, int var9, int var10);

    private native boolean nUpdateTextureF(long var1, long var3, FloatBuffer var5, float[] var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    private native boolean nUpdateTextureI(long var1, long var3, IntBuffer var5, int[] var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    private native boolean nUpdateTextureB(long var1, long var3, ByteBuffer var5, byte[] var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    private native void nFinishFrame(long var1);

    public boolean checkFormatSupport(PixelFormat pixelFormat) {
        return this.nCheckFormatSupport(this.ptr, DXGIFormat.fromPixelFormat((PixelFormat)pixelFormat).format);
    }

    public D3D12NativeMesh createMesh() {
        return new D3D12NativeMesh(this.nCreateMesh(this.ptr));
    }

    public D3D12NativeMeshView createMeshView(D3D12NativeMesh d3D12NativeMesh) {
        return new D3D12NativeMeshView(this.nCreateMeshView(this.ptr, d3D12NativeMesh.getPtr()));
    }

    public D3D12NativePhongMaterial createPhongMaterial() {
        return new D3D12NativePhongMaterial(this.nCreatePhongMaterial(this.ptr));
    }

    public D3D12NativeRenderTarget createRenderTarget(D3D12NativeTexture d3D12NativeTexture) {
        return new D3D12NativeRenderTarget(this.nCreateRenderTarget(this.ptr, d3D12NativeTexture.getPtr()));
    }

    public D3D12NativeShader createShader(String string, ByteBuffer byteBuffer) {
        return new D3D12NativeShader(this.nCreateShader(this.ptr, string, byteBuffer));
    }

    public D3D12NativeTexture createTexture(int n, int n2, PixelFormat pixelFormat, Texture.Usage usage, Texture.WrapMode wrapMode, int n3, boolean bl, boolean bl2) {
        return new D3D12NativeTexture(this.nCreateTexture(this.ptr, n, n2, DXGIFormat.fromPixelFormat((PixelFormat)pixelFormat).format, usage.ordinal(), wrapMode.ordinal(), n3, bl, bl2));
    }

    public void clear(float f, float f2, float f3, float f4, boolean bl) {
        this.nClear(this.ptr, f, f2, f3, f4, bl);
    }

    public int getMaximumMSAASampleSize(PixelFormat pixelFormat) {
        return this.nGetMaximumMSAASampleSize(this.ptr, DXGIFormat.fromPixelFormat((PixelFormat)pixelFormat).format);
    }

    public int getMaximumTextureSize() {
        return this.nGetMaximumTextureSize(this.ptr);
    }

    public void renderMeshView(D3D12NativeMeshView d3D12NativeMeshView) {
        this.nRenderMeshView(this.ptr, d3D12NativeMeshView.getPtr());
    }

    public void renderQuads(float[] fArray, byte[] byArray, int n) {
        this.nRenderQuads(this.ptr, fArray, byArray, n);
    }

    public void setCompositeMode(CompositeMode compositeMode) {
        this.nSetCompositeMode(this.ptr, compositeMode.ordinal());
    }

    public void setPixelShader(D3D12NativeShader d3D12NativeShader) {
        if (d3D12NativeShader == null) {
            this.nSetPixelShader(this.ptr, 0L);
        } else {
            this.nSetPixelShader(this.ptr, d3D12NativeShader.getPtr());
        }
    }

    public void setRenderTarget(D3D12NativeRenderTarget d3D12NativeRenderTarget, boolean bl) {
        this.nSetRenderTarget(this.ptr, d3D12NativeRenderTarget.getPtr(), bl);
    }

    public void setScissor(boolean bl, int n, int n2, int n3, int n4) {
        this.nSetScissor(this.ptr, bl, n, n2, n3, n4);
    }

    public boolean setShaderConstants(D3D12NativeShader d3D12NativeShader, String string, FloatBuffer floatBuffer, int n, int n2) {
        return this.nSetShaderConstantsF(this.ptr, d3D12NativeShader.getPtr(), string, floatBuffer, n, n2);
    }

    public boolean setShaderConstants(D3D12NativeShader d3D12NativeShader, String string, IntBuffer intBuffer, int n, int n2) {
        return this.nSetShaderConstantsI(this.ptr, d3D12NativeShader.getPtr(), string, intBuffer, n, n2);
    }

    public void setTexture(int n, D3D12NativeTexture d3D12NativeTexture) {
        this.nSetTexture(this.ptr, n, d3D12NativeTexture != null ? d3D12NativeTexture.getPtr() : 0L);
    }

    public void setCameraPos(Vec3d vec3d) {
        this.nSetCameraPos(this.ptr, vec3d.x, vec3d.y, vec3d.z);
    }

    public void setViewProjTransform(GeneralTransform3D generalTransform3D) {
        this.nSetViewProjTransform(this.ptr, generalTransform3D.get(0), generalTransform3D.get(1), generalTransform3D.get(2), generalTransform3D.get(3), generalTransform3D.get(4), generalTransform3D.get(5), generalTransform3D.get(6), generalTransform3D.get(7), generalTransform3D.get(8), generalTransform3D.get(9), generalTransform3D.get(10), generalTransform3D.get(11), generalTransform3D.get(12), generalTransform3D.get(13), generalTransform3D.get(14), generalTransform3D.get(15));
    }

    public void setWorldTransform(GeneralTransform3D generalTransform3D) {
        this.nSetWorldTransform(this.ptr, generalTransform3D.get(0), generalTransform3D.get(1), generalTransform3D.get(2), generalTransform3D.get(3), generalTransform3D.get(4), generalTransform3D.get(5), generalTransform3D.get(6), generalTransform3D.get(7), generalTransform3D.get(8), generalTransform3D.get(9), generalTransform3D.get(10), generalTransform3D.get(11), generalTransform3D.get(12), generalTransform3D.get(13), generalTransform3D.get(14), generalTransform3D.get(15));
    }

    public void setWorldTransform(BaseTransform baseTransform) {
        this.nSetWorldTransform(this.ptr, baseTransform.getMxx(), baseTransform.getMxy(), baseTransform.getMxz(), baseTransform.getMxt(), baseTransform.getMyx(), baseTransform.getMyy(), baseTransform.getMyz(), baseTransform.getMyt(), baseTransform.getMzx(), baseTransform.getMzy(), baseTransform.getMzz(), baseTransform.getMzt(), 0.0, 0.0, 0.0, 1.0);
    }

    public boolean blit(D3D12NativeRenderTarget d3D12NativeRenderTarget, int n, int n2, int n3, int n4, D3D12NativeRenderTarget d3D12NativeRenderTarget2, int n5, int n6, int n7, int n8) {
        return this.nBlit(this.ptr, d3D12NativeRenderTarget.getPtr(), n, n2, n3, n4, d3D12NativeRenderTarget2.getPtr(), n5, n6, n7, n8);
    }

    public boolean blit(D3D12NativeRenderTarget d3D12NativeRenderTarget, int n, int n2, int n3, int n4, D3D12NativeSwapChain d3D12NativeSwapChain, int n5, int n6, int n7, int n8) {
        return this.nBlitToSwapChain(this.ptr, d3D12NativeRenderTarget.getPtr(), n, n2, n3, n4, d3D12NativeSwapChain.getPtr(), n5, n6, n7, n8);
    }

    public boolean readTexture(D3D12NativeTexture d3D12NativeTexture, Buffer buffer, int n, int n2, int n3, int n4) {
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            byte[] byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
            return this.nReadTextureB(this.ptr, d3D12NativeTexture.ptr, byteBuffer, byArray, n, n2, n3, n4);
        }
        if (buffer instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            int[] nArray = intBuffer.hasArray() ? intBuffer.array() : null;
            return this.nReadTextureI(this.ptr, d3D12NativeTexture.ptr, intBuffer, nArray, n, n2, n3, n4);
        }
        throw new IllegalArgumentException("Buffer of this type is not supported: " + String.valueOf(buffer));
    }

    public boolean updateTexture(D3D12NativeTexture d3D12NativeTexture, Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (pixelFormat.getDataType() == PixelFormat.DataType.INT && buffer instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            int[] nArray = intBuffer.hasArray() ? intBuffer.array() : null;
            return this.nUpdateTextureI(this.ptr, d3D12NativeTexture.getPtr(), intBuffer, nArray, pixelFormat.ordinal(), n, n2, n3, n4, n5, n6, n7);
        }
        if (pixelFormat.getDataType() == PixelFormat.DataType.FLOAT && buffer instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)buffer;
            float[] fArray = floatBuffer.hasArray() ? floatBuffer.array() : null;
            return this.nUpdateTextureF(this.ptr, d3D12NativeTexture.getPtr(), floatBuffer, fArray, pixelFormat.ordinal(), n, n2, n3, n4, n5, n6, n7);
        }
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            byteBuffer.rewind();
            byte[] byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
            return this.nUpdateTextureB(this.ptr, d3D12NativeTexture.getPtr(), byteBuffer, byArray, pixelFormat.ordinal(), n, n2, n3, n4, n5, n6, n7);
        }
        throw new IllegalArgumentException("Buffer of this type is not supported: " + String.valueOf(buffer));
    }

    public void finishFrame() {
        this.nFinishFrame(this.ptr);
    }
}

