/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.prism.Graphics;
import com.sun.prism.Material;
import com.sun.prism.d3d12.D3D12Context;
import com.sun.prism.d3d12.D3D12Mesh;
import com.sun.prism.d3d12.D3D12PhongMaterial;
import com.sun.prism.d3d12.ni.D3D12NativeMeshView;
import com.sun.prism.impl.BaseMeshView;
import com.sun.prism.impl.Disposer;

public class D3D12MeshView
extends BaseMeshView {
    private D3D12Context mContext;
    private D3D12MeshViewData mMeshViewData;
    private D3D12PhongMaterial mMaterial;

    protected D3D12MeshView(D3D12Context d3D12Context, D3D12MeshViewData d3D12MeshViewData) {
        super(d3D12MeshViewData);
        this.mContext = d3D12Context;
        this.mMeshViewData = d3D12MeshViewData;
    }

    D3D12NativeMeshView getNativeMeshView() {
        return this.mMeshViewData.mMeshView;
    }

    public static D3D12MeshView create(D3D12Context d3D12Context, D3D12Mesh d3D12Mesh) {
        return new D3D12MeshView(d3D12Context, new D3D12MeshViewData(d3D12Context.getDevice().createMeshView(d3D12Mesh.getNative())));
    }

    @Override
    public void setCullingMode(int n) {
        this.mMeshViewData.getNative().setCullingMode(n);
    }

    @Override
    public void setMaterial(Material material) {
        this.mMaterial = (D3D12PhongMaterial)material;
        this.mMeshViewData.getNative().setMaterial(this.mMaterial.getNative());
    }

    @Override
    public void setWireframe(boolean bl) {
        this.mMeshViewData.getNative().setWireframe(bl);
    }

    @Override
    public void setAmbientLight(float f, float f2, float f3) {
        this.mMeshViewData.getNative().setAmbientLight(f, f2, f3);
    }

    @Override
    public void setLight(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18) {
        if (n >= 0 && n <= 2) {
            this.mMeshViewData.getNative().setLight(n, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18);
        }
    }

    @Override
    public void render(Graphics graphics) {
        this.mMaterial.lockTextureMaps();
        this.mContext.renderMeshView(this, graphics);
        this.mMaterial.unlockTextureMaps();
    }

    @Override
    public void dispose() {
        this.disposerRecord.dispose();
    }

    static class D3D12MeshViewData
    implements Disposer.Record {
        D3D12NativeMeshView mMeshView;

        D3D12MeshViewData(D3D12NativeMeshView d3D12NativeMeshView) {
            if (!d3D12NativeMeshView.isValid()) {
                throw new NullPointerException("Mesh view object is NULL");
            }
            this.mMeshView = d3D12NativeMeshView;
        }

        D3D12NativeMeshView getNative() {
            return this.mMeshView;
        }

        @Override
        public void dispose() {
            if (this.mMeshView.isValid()) {
                this.mMeshView.dispose();
            }
        }
    }
}

