/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.glass.ui.Screen;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackRenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.d3d12.D3D12Context;
import com.sun.prism.d3d12.D3D12Graphics;
import com.sun.prism.d3d12.D3D12Resource;
import com.sun.prism.d3d12.D3D12Texture;
import com.sun.prism.d3d12.D3D12TextureData;
import com.sun.prism.d3d12.ni.D3D12NativeRenderTarget;
import com.sun.prism.d3d12.ni.D3D12NativeTexture;
import java.nio.Buffer;

public class D3D12RTTexture
extends D3D12Texture
implements RTTexture,
ReadbackRenderTarget {
    private boolean mOpaque = false;
    private int mMSAALevel = 1;

    D3D12RTTexture(D3D12Resource<D3D12TextureData> d3D12Resource, D3D12Context d3D12Context, PixelFormat pixelFormat, Texture.WrapMode wrapMode, int n, int n2, int n3) {
        super(d3D12Resource, d3D12Context, pixelFormat, wrapMode, n, n2);
        this.mMSAALevel = n3;
    }

    public static D3D12RTTexture create(D3D12Context d3D12Context, int n, int n2, PixelFormat pixelFormat, Texture.WrapMode wrapMode, int n3) {
        D3D12NativeTexture d3D12NativeTexture = d3D12Context.getDevice().createTexture(n, n2, pixelFormat, Texture.Usage.DEFAULT, wrapMode, n3, false, true);
        D3D12NativeRenderTarget d3D12NativeRenderTarget = d3D12Context.getDevice().createRenderTarget(d3D12NativeTexture);
        return new D3D12RTTexture(new D3D12Resource<D3D12TextureData>(new D3D12TextureData(d3D12NativeTexture, d3D12NativeRenderTarget, n, n2, pixelFormat)), d3D12Context, pixelFormat, wrapMode, n, n2, n3);
    }

    D3D12NativeRenderTarget getNativeRenderTarget() {
        return ((D3D12TextureData)((D3D12Resource)this.resource).getResource()).getRenderTarget();
    }

    boolean resize(int n, int n2) {
        if (!((D3D12TextureData)((D3D12Resource)this.resource).getResource()).getNativeTexture().resize(n, n2)) {
            return false;
        }
        return ((D3D12TextureData)((D3D12Resource)this.resource).getResource()).getRenderTarget().refresh();
    }

    public int getWidth() {
        return ((D3D12TextureData)((D3D12Resource)this.resource).getResource()).getRenderTarget().getWidth();
    }

    public int getHeight() {
        return ((D3D12TextureData)((D3D12Resource)this.resource).getResource()).getRenderTarget().getHeight();
    }

    public boolean isValid() {
        return ((D3D12TextureData)((D3D12Resource)this.resource).getResource()).isValid();
    }

    @Override
    public void update(Image image) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2, int n3, int n4, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(MediaFrame mediaFrame, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.mContext.getAssociatedScreen();
    }

    @Override
    public Graphics createGraphics() {
        return new D3D12Graphics(this.mContext, this);
    }

    @Override
    public boolean isOpaque() {
        return this.mOpaque;
    }

    @Override
    public void setOpaque(boolean bl) {
        this.mOpaque = bl;
    }

    @Override
    public boolean isMSAA() {
        return this.mMSAALevel > 1;
    }

    @Override
    public int[] getPixels() {
        return null;
    }

    @Override
    public boolean readPixels(Buffer buffer) {
        return this.readPixels(buffer, 0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public boolean readPixels(Buffer buffer, int n, int n2, int n3, int n4) {
        if (this.mContext.isDisposed()) {
            return false;
        }
        this.mContext.flushVertexBuffer();
        return this.mContext.getDevice().readTexture(((D3D12TextureData)((D3D12Resource)this.resource).getResource()).getNativeTexture(), buffer, n, n2, n3, n4);
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    public Texture getBackBuffer() {
        return this;
    }
}

