/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.prism.PixelFormat;
import com.sun.prism.d3d12.ni.D3D12NativeRenderTarget;
import com.sun.prism.d3d12.ni.D3D12NativeTexture;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.PrismTrace;

class D3D12TextureData
implements Disposer.Record {
    private D3D12NativeTexture mTexture;
    private D3D12NativeRenderTarget mRenderTarget;
    private final long mSize;

    static long estimateSize(int n, int n2, PixelFormat pixelFormat) {
        return (long)n * (long)n2 * (long)pixelFormat.getBytesPerPixelUnit();
    }

    static long estimateRTSize(int n, int n2, boolean bl) {
        return 4L * (long)n * (long)n2;
    }

    D3D12TextureData(D3D12NativeTexture d3D12NativeTexture, D3D12NativeRenderTarget d3D12NativeRenderTarget, int n, int n2, PixelFormat pixelFormat) {
        this.mTexture = d3D12NativeTexture;
        this.mRenderTarget = d3D12NativeRenderTarget;
        long l = this.mSize = this.isRTT() ? D3D12TextureData.estimateRTSize(n, n2, false) : D3D12TextureData.estimateSize(n, n2, pixelFormat);
        if (this.isRTT()) {
            PrismTrace.rttCreated(this.mRenderTarget.getPtr(), n, n2, this.mSize);
        } else {
            PrismTrace.textureCreated(this.mTexture.getPtr(), n, n2, this.mSize);
        }
    }

    @Override
    public void dispose() {
        if (this.isRTT()) {
            PrismTrace.rttDisposed(this.mRenderTarget.getPtr());
            this.mRenderTarget.dispose();
            this.mTexture.dispose();
        } else {
            PrismTrace.textureDisposed(this.mTexture.getPtr());
            this.mTexture.dispose();
        }
    }

    public boolean isValid() {
        if (this.isRTT()) {
            return this.mRenderTarget.isValid() && this.mTexture.isValid();
        }
        return this.mTexture.isValid();
    }

    public final boolean isRTT() {
        return this.mRenderTarget != null;
    }

    public long getSize() {
        if (this.isRTT()) {
            return this.mRenderTarget.getHeight() * this.mRenderTarget.getHeight() * 4;
        }
        return this.mTexture.getSize();
    }

    D3D12NativeTexture getNativeTexture() {
        return this.mTexture;
    }

    D3D12NativeRenderTarget getRenderTarget() {
        return this.mRenderTarget;
    }
}

