/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media;

import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.MediaQueryContext;
import com.sun.javafx.css.media.MediaQuerySerializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import javafx.css.StyleConverter;

public final class MediaRule {
    private final List<MediaQuery> queries;
    private final MediaRule parent;

    public MediaRule(List<MediaQuery> list, MediaRule mediaRule) {
        this.queries = List.copyOf(list);
        this.parent = mediaRule;
    }

    public List<MediaQuery> getQueries() {
        return this.queries;
    }

    public MediaRule getParent() {
        return this.parent;
    }

    public boolean evaluate(MediaQueryContext mediaQueryContext) {
        if (this.parent != null && !this.parent.evaluate(mediaQueryContext)) {
            return false;
        }
        if (this.queries.isEmpty()) {
            return true;
        }
        int n = this.queries.size();
        for (int i = 0; i < n; ++i) {
            if (!this.queries.get(i).evaluate(mediaQueryContext)) continue;
            return true;
        }
        return false;
    }

    public void writeBinary(DataOutputStream dataOutputStream, StyleConverter.StringStore stringStore) throws IOException {
        dataOutputStream.writeInt(this.queries.size());
        for (MediaQuery mediaQuery : this.queries) {
            MediaQuerySerializer.writeBinary(mediaQuery, dataOutputStream, stringStore);
        }
        dataOutputStream.writeBoolean(this.parent != null);
        if (this.parent != null) {
            this.parent.writeBinary(dataOutputStream, stringStore);
        }
    }

    public static MediaRule readBinary(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        int n;
        int n2 = dataInputStream.readInt();
        MediaQuery[] mediaQueryArray = new MediaQuery[n2];
        for (n = 0; n < n2; ++n) {
            mediaQueryArray[n] = MediaQuerySerializer.readBinary(dataInputStream, stringArray);
        }
        n = dataInputStream.readBoolean() ? 1 : 0;
        MediaRule mediaRule = n != 0 ? MediaRule.readBinary(dataInputStream, stringArray) : null;
        return new MediaRule(List.of(mediaQueryArray), mediaRule);
    }
}

