/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media.expression;

import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.MediaQueryContext;
import java.util.Objects;
import java.util.function.Function;

public record FunctionExpression<T>(String featureName, String featureValue, Function<MediaQueryContext, T> function, T value) implements MediaQuery
{
    public FunctionExpression {
        Objects.requireNonNull(string, "featureName cannot be null");
        Objects.requireNonNull(function, "function cannot be null");
    }

    @Override
    public boolean evaluate(MediaQueryContext mediaQueryContext) {
        return Objects.equals(this.function.apply(mediaQueryContext), this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FunctionExpression)) return false;
        FunctionExpression functionExpression = (FunctionExpression)object;
        if (!functionExpression.featureName.equals(this.featureName)) return false;
        if (!Objects.equals(functionExpression.featureValue, this.featureValue)) return false;
        if (!Objects.equals(functionExpression.value, this.value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.featureName, this.featureValue, this.value);
    }

    @Override
    public String toString() {
        return "(" + (String)(this.featureValue != null ? this.featureName + ": " + this.featureValue : this.featureName) + ")";
    }
}

