/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.async;

import com.sun.javafx.runtime.async.AsyncOperation;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.runtime.async.BackgroundExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;

public abstract class AbstractAsyncOperation<V>
implements AsyncOperation,
Callable<V> {
    protected final FutureTask<V> future;
    protected final AsyncOperationListener<V> listener;
    private long progressGranularity = 100L;
    private long progressMax;
    private long lastProgress;
    private long progressIncrement;
    private long nextProgress;
    private long bytesRead;

    protected AbstractAsyncOperation(final AsyncOperationListener<V> asyncOperationListener) {
        this.listener = asyncOperationListener;
        Callable<Object> callable = () -> this.call();
        final Runnable runnable = new Runnable(){
            final /* synthetic */ AbstractAsyncOperation this$0;
            {
                this.this$0 = abstractAsyncOperation;
            }

            @Override
            public void run() {
                if (this.this$0.future.isCancelled()) {
                    asyncOperationListener.onCancel();
                } else {
                    try {
                        asyncOperationListener.onCompletion(this.this$0.future.get());
                    }
                    catch (InterruptedException interruptedException) {
                        asyncOperationListener.onCancel();
                    }
                    catch (ExecutionException executionException) {
                        asyncOperationListener.onException(executionException);
                    }
                }
            }
        };
        this.future = new FutureTask<V>(this, callable){

            @Override
            protected void done() {
                try {
                    Platform.runLater(runnable);
                }
                finally {
                    super.done();
                }
            }
        };
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public void cancel() {
        this.future.cancel(true);
    }

    @Override
    public void start() {
        BackgroundExecutor.getExecutor().execute(this.future);
    }

    protected void notifyProgress() {
        long l = this.lastProgress;
        long l2 = this.progressMax;
        Platform.runLater(() -> this.listener.onProgress(l, l2));
    }

    protected void addProgress(int n) {
        this.bytesRead += (long)n;
        if (this.bytesRead > this.nextProgress) {
            this.lastProgress = this.bytesRead;
            this.notifyProgress();
            this.nextProgress = (this.lastProgress / this.progressIncrement + 1L) * this.progressIncrement;
        }
    }

    protected long getProgressMax() {
        return this.progressMax;
    }

    protected void setProgressMax(long l) {
        if (l == 0L) {
            this.progressIncrement = this.progressGranularity;
        } else if (l == -1L) {
            this.progressIncrement = this.progressGranularity;
        } else {
            this.progressMax = l;
            this.progressIncrement = l / this.progressGranularity;
            if (this.progressIncrement < 1L) {
                this.progressIncrement = 1L;
            }
        }
        this.nextProgress = (this.lastProgress / this.progressIncrement + 1L) * this.progressIncrement;
        this.notifyProgress();
    }

    protected long getProgressGranularity() {
        return this.progressGranularity;
    }

    protected void setProgressGranularity(long l) {
        this.progressGranularity = l;
        this.progressIncrement = this.progressMax / l;
        this.nextProgress = (this.lastProgress / this.progressIncrement + 1L) * this.progressIncrement;
        this.notifyProgress();
    }
}

