/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.prism.d3d12.D3D12Context;
import com.sun.prism.d3d12.ni.D3D12NativeMesh;
import com.sun.prism.impl.BaseMesh;
import com.sun.prism.impl.Disposer;

class D3D12Mesh
extends BaseMesh {
    static int count = 0;
    D3D12Context mContext;
    D3D12MeshData mMeshData;

    private D3D12Mesh(D3D12Context d3D12Context, D3D12MeshData d3D12MeshData) {
        super(d3D12MeshData);
        this.mContext = d3D12Context;
        this.mMeshData = d3D12MeshData;
        ++count;
    }

    public static D3D12Mesh create(D3D12Context d3D12Context) {
        return new D3D12Mesh(d3D12Context, new D3D12MeshData(d3D12Context.getDevice().createMesh()));
    }

    D3D12NativeMesh getNative() {
        return this.mMeshData.getResource();
    }

    @Override
    public int getCount() {
        return count;
    }

    @Override
    public boolean buildNativeGeometry(float[] fArray, int n, int[] nArray, int n2) {
        return this.mMeshData.getResource().buildGeometryBuffers(fArray, n, nArray, n2);
    }

    @Override
    public boolean buildNativeGeometry(float[] fArray, int n, short[] sArray, int n2) {
        return this.mMeshData.getResource().buildGeometryBuffers(fArray, n, sArray, n2);
    }

    @Override
    public void dispose() {
        this.disposerRecord.dispose();
        --count;
    }

    static class D3D12MeshData
    implements Disposer.Record {
        private D3D12NativeMesh mMesh;

        D3D12MeshData(D3D12NativeMesh d3D12NativeMesh) {
            if (!d3D12NativeMesh.isValid()) {
                throw new NullPointerException("Mesh object is NULL");
            }
            this.mMesh = d3D12NativeMesh;
        }

        D3D12NativeMesh getResource() {
            return this.mMesh;
        }

        @Override
        public void dispose() {
            this.mMesh.dispose();
        }

        public boolean isValid() {
            return this.mMesh.isValid();
        }
    }
}

