/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.glass.ui.Screen;
import com.sun.prism.MediaFrame;
import com.sun.prism.Mesh;
import com.sun.prism.MeshView;
import com.sun.prism.MultiTexture;
import com.sun.prism.PhongMaterial;
import com.sun.prism.PixelFormat;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.d3d12.D3D12Context;
import com.sun.prism.d3d12.D3D12Mesh;
import com.sun.prism.d3d12.D3D12MeshView;
import com.sun.prism.d3d12.D3D12PhongMaterial;
import com.sun.prism.d3d12.D3D12RTTexture;
import com.sun.prism.d3d12.D3D12ResourcePool;
import com.sun.prism.d3d12.D3D12Shader;
import com.sun.prism.d3d12.D3D12SwapChain;
import com.sun.prism.d3d12.D3D12Texture;
import com.sun.prism.d3d12.D3D12TextureData;
import com.sun.prism.d3d12.D3D12Utils;
import com.sun.prism.d3d12.ni.D3D12NativeInstance;
import com.sun.prism.d3d12.ni.D3D12NativeTexture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;
import com.sun.prism.impl.ps.BaseShaderFactory;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;

class D3D12ResourceFactory
extends BaseShaderFactory {
    private final D3D12NativeInstance mInstance;
    private final D3D12Context mContext;
    private int mMaximumTextureSize;

    D3D12ResourceFactory(D3D12NativeInstance d3D12NativeInstance, int n, Screen screen) {
        this.mInstance = d3D12NativeInstance;
        this.mContext = new D3D12Context(this.mInstance.createDevice(n), screen, this);
        this.mMaximumTextureSize = this.mContext.getDevice().getMaximumTextureSize();
    }

    D3D12Context getContext() {
        return this.mContext;
    }

    D3D12NativeInstance getNativeInstance() {
        return this.mInstance;
    }

    @Override
    public Shader createShader(String string, InputStream inputStream, Map<String, Integer> map, Map<String, Integer> map2, int n, boolean bl, boolean bl2) {
        if (this.checkDisposed()) {
            return null;
        }
        try {
            return D3D12Shader.create(this.mContext, string, inputStream, map, map2);
        }
        catch (Exception exception) {
            throw new InternalError("Failed to create shader: " + exception.getMessage());
        }
    }

    @Override
    public Shader createShader(String string, Map<String, Integer> map, Map<String, Integer> map2, int n, boolean bl, boolean bl2) {
        throw new UnsupportedOperationException("Not supported on D3D12 backend");
    }

    @Override
    public Shader createStockShader(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Shader name must be non-null");
        }
        try {
            Class<?> clazz = Class.forName("com.sun.prism.shader." + string + "_Loader");
            InputStream inputStream = D3D12ResourceFactory.class.getResourceAsStream("hlsl6/" + string + ".cso");
            Method method = clazz.getMethod("loadShader", ShaderFactory.class, String.class, InputStream.class);
            return (Shader)method.invoke(null, this, string, inputStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new InternalError("Error loading stock shader " + string);
        }
    }

    @Override
    public TextureResourcePool<D3D12TextureData> getTextureResourcePool() {
        return D3D12ResourcePool.instance;
    }

    static int nextPowerOfTwo(int n, int n2) {
        int n3;
        if (n > n2) {
            return 0;
        }
        for (n3 = 1; n3 < n; n3 *= 2) {
        }
        return n3;
    }

    @Override
    public Texture createTexture(PixelFormat pixelFormat, Texture.Usage usage, Texture.WrapMode wrapMode, int n, int n2) {
        return this.createTexture(pixelFormat, usage, wrapMode, n, n2, false);
    }

    @Override
    public Texture createTexture(PixelFormat pixelFormat, Texture.Usage usage, Texture.WrapMode wrapMode, int n, int n2, boolean bl) {
        int n3;
        int n4;
        if (this.checkDisposed()) {
            return null;
        }
        if (!this.isFormatSupported(pixelFormat)) {
            throw new UnsupportedOperationException("Pixel format " + String.valueOf((Object)pixelFormat) + " not supported on this device");
        }
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new UnsupportedOperationException("MULTI_YCbCr_420 textures require a MediaFrame");
        }
        if (PrismSettings.forcePow2) {
            n4 = D3D12ResourceFactory.nextPowerOfTwo(n, Integer.MAX_VALUE);
            n3 = D3D12ResourceFactory.nextPowerOfTwo(n2, Integer.MAX_VALUE);
        } else {
            n4 = n;
            n3 = n2;
        }
        if (n4 <= 0 || n3 <= 0) {
            throw new RuntimeException("Illegal texture dimensions (" + n4 + "x" + n3 + ")");
        }
        int n5 = pixelFormat.getBytesPerPixelUnit();
        if (n4 >= Integer.MAX_VALUE / n3 / n5) {
            throw new RuntimeException("Illegal texture dimensions (" + n4 + "x" + n3 + ")");
        }
        D3D12ResourcePool d3D12ResourcePool = D3D12ResourcePool.instance;
        long l = d3D12ResourcePool.estimateTextureSize(n4, n3, pixelFormat);
        if (!d3D12ResourcePool.prepareForAllocation(l)) {
            return null;
        }
        D3D12NativeTexture d3D12NativeTexture = this.mContext.getDevice().createTexture(n4, n3, pixelFormat, usage, wrapMode, 1, bl, false);
        if (!d3D12NativeTexture.isValid()) {
            throw new RuntimeException("Failed to create D3D12 texture");
        }
        return D3D12Texture.create(d3D12NativeTexture, this.mContext, pixelFormat, wrapMode);
    }

    @Override
    public Texture createTexture(MediaFrame mediaFrame) {
        if (this.checkDisposed()) {
            return null;
        }
        D3D12Texture d3D12Texture = null;
        try (D3D12Utils.AutoReleasableMediaFrame autoReleasableMediaFrame = new D3D12Utils.AutoReleasableMediaFrame(mediaFrame);){
            int n = autoReleasableMediaFrame.get().getWidth();
            int n2 = autoReleasableMediaFrame.get().getHeight();
            int n3 = autoReleasableMediaFrame.get().getEncodedWidth();
            int n4 = autoReleasableMediaFrame.get().getEncodedHeight();
            PixelFormat pixelFormat = autoReleasableMediaFrame.get().getPixelFormat();
            if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
                MultiTexture multiTexture = new MultiTexture(pixelFormat, Texture.WrapMode.CLAMP_TO_EDGE, n, n2);
                for (int i = 0; i < mediaFrame.planeCount(); ++i) {
                    D3D12Texture d3D12Texture2;
                    int n5 = n3;
                    int n6 = n4;
                    if (i == 2 || i == 1) {
                        n5 /= 2;
                        n6 /= 2;
                    }
                    Texture.WrapMode wrapMode = Texture.WrapMode.CLAMP_TO_EDGE;
                    PixelFormat pixelFormat2 = PixelFormat.BYTE_ALPHA;
                    D3D12NativeTexture d3D12NativeTexture = this.mContext.getDevice().createTexture(n5, n6, pixelFormat2, Texture.Usage.DYNAMIC, wrapMode, 1, false, false);
                    if (d3D12NativeTexture == null) {
                        multiTexture.dispose();
                        d3D12Texture2 = null;
                        return d3D12Texture2;
                    }
                    d3D12Texture2 = D3D12Texture.create(d3D12NativeTexture, this.mContext, pixelFormat2, wrapMode);
                    multiTexture.setTexture(d3D12Texture2, i);
                }
                MultiTexture multiTexture2 = multiTexture;
                return multiTexture2;
            }
            if (n3 <= 0 || n4 <= 0) {
                throw new RuntimeException("Illegal texture dimensions (" + n3 + "x" + n4 + ")");
            }
            int n7 = pixelFormat.getBytesPerPixelUnit();
            if (n3 >= Integer.MAX_VALUE / n4 / n7) {
                throw new RuntimeException("Illegal texture dimensions (" + n3 + "x" + n4 + ")");
            }
            D3D12ResourcePool d3D12ResourcePool = D3D12ResourcePool.instance;
            long l = d3D12ResourcePool.estimateTextureSize(n3, n4, pixelFormat);
            if (!d3D12ResourcePool.prepareForAllocation(l)) {
                Texture texture = null;
                return texture;
            }
            Texture.WrapMode wrapMode = Texture.WrapMode.CLAMP_TO_EDGE;
            D3D12NativeTexture d3D12NativeTexture = this.mContext.getDevice().createTexture(n3, n4, pixelFormat, Texture.Usage.DYNAMIC, wrapMode, 1, false, false);
            if (!d3D12NativeTexture.isValid()) {
                throw new RuntimeException("Failed to create D3D12 texture for MediaFrame");
            }
            int n8 = d3D12NativeTexture.getWidth();
            int n9 = d3D12NativeTexture.getHeight();
            wrapMode = n3 < n8 || n4 < n9 ? Texture.WrapMode.CLAMP_TO_EDGE_SIMULATED : Texture.WrapMode.CLAMP_TO_EDGE;
            d3D12Texture = D3D12Texture.create(d3D12NativeTexture, this.mContext, pixelFormat, wrapMode);
        }
        return d3D12Texture;
    }

    @Override
    public boolean isFormatSupported(PixelFormat pixelFormat) {
        return this.mContext.getDevice().checkFormatSupport(pixelFormat);
    }

    @Override
    public int getMaximumTextureSize() {
        return this.mMaximumTextureSize;
    }

    @Override
    public int getRTTWidth(int n, Texture.WrapMode wrapMode) {
        return n;
    }

    @Override
    public int getRTTHeight(int n, Texture.WrapMode wrapMode) {
        return n;
    }

    @Override
    public RTTexture createRTTexture(int n, int n2, Texture.WrapMode wrapMode) {
        return this.createRTTexture(n, n2, wrapMode, false);
    }

    @Override
    public RTTexture createRTTexture(int n, int n2, Texture.WrapMode wrapMode, boolean bl) {
        long l;
        if (this.checkDisposed()) {
            return null;
        }
        int n3 = n;
        int n4 = n2;
        if (PrismSettings.forcePow2) {
            n3 = D3D12ResourceFactory.nextPowerOfTwo(n3, Integer.MAX_VALUE);
            n4 = D3D12ResourceFactory.nextPowerOfTwo(n4, Integer.MAX_VALUE);
        }
        if (n3 <= 0 || n4 <= 0) {
            throw new RuntimeException("Illegal texture dimensions (" + n3 + "x" + n4 + ")");
        }
        PixelFormat pixelFormat = PixelFormat.INT_ARGB_PRE;
        int n5 = pixelFormat.getBytesPerPixelUnit();
        if (n3 >= Integer.MAX_VALUE / n4 / n5) {
            throw new RuntimeException("Illegal texture dimensions (" + n3 + "x" + n4 + ")");
        }
        D3D12ResourcePool d3D12ResourcePool = D3D12ResourcePool.instance;
        int n6 = 1;
        if (bl) {
            n6 = this.mContext.getMSAASampleSize(pixelFormat);
        }
        if (!d3D12ResourcePool.prepareForAllocation(l = d3D12ResourcePool.estimateRTTextureSize(n, n2, false))) {
            return null;
        }
        D3D12RTTexture d3D12RTTexture = D3D12RTTexture.create(this.mContext, n, n2, pixelFormat, wrapMode, n6);
        if (!d3D12RTTexture.isValid()) {
            return null;
        }
        return d3D12RTTexture;
    }

    @Override
    public boolean isCompatibleTexture(Texture texture) {
        return texture instanceof D3D12Texture;
    }

    @Override
    public Presentable createPresentable(PresentableState presentableState) {
        if (this.checkDisposed()) {
            return null;
        }
        return D3D12SwapChain.create(this.mContext, presentableState);
    }

    @Override
    public PhongMaterial createPhongMaterial() {
        if (this.checkDisposed()) {
            return null;
        }
        return D3D12PhongMaterial.create(this.mContext);
    }

    @Override
    public MeshView createMeshView(Mesh mesh) {
        if (this.checkDisposed()) {
            return null;
        }
        return D3D12MeshView.create(this.mContext, (D3D12Mesh)mesh);
    }

    @Override
    public Mesh createMesh() {
        if (this.checkDisposed()) {
            return null;
        }
        return D3D12Mesh.create(this.mContext);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mContext.dispose();
    }
}

