/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.prism.PixelFormat;
import com.sun.prism.d3d12.D3D12TextureData;
import com.sun.prism.impl.BaseResourcePool;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;

class D3D12ResourcePool
extends BaseResourcePool<D3D12TextureData>
implements TextureResourcePool<D3D12TextureData> {
    public static final D3D12ResourcePool instance = new D3D12ResourcePool();

    private D3D12ResourcePool() {
        super(PrismSettings.targetVram, PrismSettings.maxVram);
    }

    @Override
    public long size(D3D12TextureData d3D12TextureData) {
        return d3D12TextureData.getSize();
    }

    @Override
    public long estimateTextureSize(int n, int n2, PixelFormat pixelFormat) {
        return (long)n * (long)n2 * (long)pixelFormat.getBytesPerPixelUnit();
    }

    @Override
    public long estimateRTTextureSize(int n, int n2, boolean bl) {
        long l = 4L * (long)n * (long)n2;
        if (bl) {
            l += (long)(n * n2) * 4L;
        }
        return l;
    }

    public String toString() {
        return "D3D12 Resource Pool";
    }
}

