/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.Texture;
import com.sun.prism.d3d12.D3D12Context;
import com.sun.prism.d3d12.D3D12Graphics;
import com.sun.prism.d3d12.D3D12RTTexture;
import com.sun.prism.d3d12.D3D12ResourceFactory;
import com.sun.prism.d3d12.ni.D3D12NativeSwapChain;
import com.sun.prism.impl.PrismSettings;

class D3D12SwapChain
implements Presentable,
GraphicsResource {
    private D3D12Context mContext;
    private D3D12RTTexture mOffscreenRTT;
    private D3D12NativeSwapChain mSwapChain;
    private PresentableState mState;
    private float mRenderScaleX;
    private float mRenderScaleY;
    private int mWidth;
    private int mHeight;
    private boolean mMSAA;

    D3D12SwapChain(D3D12Context d3D12Context, PresentableState presentableState) {
        if (!d3D12Context.getDevice().isValid()) {
            throw new NullPointerException("D3D12 device is NULL");
        }
        this.mContext = d3D12Context;
        this.mState = presentableState;
        this.mRenderScaleX = this.mState.getRenderScaleX();
        this.mRenderScaleY = this.mState.getRenderScaleY();
        this.mWidth = this.mState.getRenderWidth();
        this.mHeight = this.mState.getRenderHeight();
        this.mMSAA = this.mState.isMSAA();
        this.mSwapChain = ((D3D12ResourceFactory)d3D12Context.getResourceFactory()).getNativeInstance().createSwapChain(this.mContext.getDevice(), this.mState.getNativeView());
        if (!this.mSwapChain.isValid()) {
            throw new NullPointerException("D3D12 swapchain is NULL");
        }
        this.mOffscreenRTT = (D3D12RTTexture)d3D12Context.getResourceFactory().createRTTexture(this.mState.getRenderWidth(), this.mState.getRenderHeight(), Texture.WrapMode.CLAMP_NOT_NEEDED, this.mMSAA);
        if (!this.mOffscreenRTT.isValid()) {
            throw new NullPointerException("D3D12 swapchain is NULL");
        }
        if (PrismSettings.dirtyOptsEnabled) {
            this.mOffscreenRTT.contentsUseful();
        }
    }

    public static D3D12SwapChain create(D3D12Context d3D12Context, PresentableState presentableState) {
        return new D3D12SwapChain(d3D12Context, presentableState);
    }

    PresentableState getPresentableState() {
        return this.mState;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.mContext.getAssociatedScreen();
    }

    @Override
    public Graphics createGraphics() {
        D3D12Graphics d3D12Graphics = new D3D12Graphics(this.mContext, this.mOffscreenRTT);
        d3D12Graphics.scale(this.mState.getRenderScaleX(), this.mState.getRenderScaleY());
        return d3D12Graphics;
    }

    @Override
    public boolean isOpaque() {
        return this.mOffscreenRTT.isOpaque();
    }

    @Override
    public void setOpaque(boolean bl) {
        this.mOffscreenRTT.setOpaque(bl);
    }

    @Override
    public boolean isMSAA() {
        return this.mOffscreenRTT != null ? this.mOffscreenRTT.isMSAA() : false;
    }

    @Override
    public int getPhysicalWidth() {
        return this.mSwapChain.getWidth();
    }

    @Override
    public int getPhysicalHeight() {
        return this.mSwapChain.getHeight();
    }

    @Override
    public int getContentX() {
        return 0;
    }

    @Override
    public int getContentY() {
        return 0;
    }

    @Override
    public int getContentWidth() {
        return this.getPhysicalWidth();
    }

    @Override
    public int getContentHeight() {
        return this.getPhysicalHeight();
    }

    @Override
    public boolean lockResources(PresentableState presentableState) {
        if (this.mWidth != presentableState.getRenderWidth() || this.mHeight != presentableState.getRenderHeight() || this.mRenderScaleX != presentableState.getRenderScaleX() || this.mRenderScaleY != presentableState.getRenderScaleY()) {
            return true;
        }
        if (this.mOffscreenRTT != null) {
            this.mOffscreenRTT.lock();
            if (this.mOffscreenRTT.isSurfaceLost()) {
                this.mOffscreenRTT.dispose();
                this.mOffscreenRTT = null;
                return true;
            }
            if (this.mWidth != presentableState.getRenderWidth() || this.mHeight != presentableState.getRenderHeight()) {
                this.mWidth = presentableState.getRenderWidth();
                this.mHeight = presentableState.getRenderHeight();
                if (!this.mSwapChain.resize(this.mWidth, this.mHeight)) {
                    return true;
                }
                if (!this.mOffscreenRTT.resize(this.mSwapChain.getWidth(), this.mSwapChain.getHeight())) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean prepare(Rectangle rectangle) {
        this.mContext.flushVertexBuffer();
        int n = this.mOffscreenRTT.getContentWidth();
        int n2 = this.mOffscreenRTT.getContentHeight();
        int n3 = this.getContentWidth();
        int n4 = this.getContentHeight();
        this.mContext.getDevice().blit(this.mOffscreenRTT.getNativeRenderTarget(), 0, 0, n, n2, this.mSwapChain, 0, 0, n3, n4);
        this.mOffscreenRTT.unlock();
        if (rectangle == null) {
            return this.mSwapChain.prepare(-1L, -1L, -1L, -1L);
        }
        return this.mSwapChain.prepare(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public boolean present() {
        this.mContext.getDevice().finishFrame();
        return this.mSwapChain.present();
    }

    @Override
    public float getPixelScaleFactorX() {
        return this.mState.getRenderScaleX();
    }

    @Override
    public float getPixelScaleFactorY() {
        return this.mState.getRenderScaleY();
    }

    @Override
    public void dispose() {
        this.mSwapChain.dispose();
        this.mOffscreenRTT.dispose();
    }
}

