/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d12;

import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.d3d12.D3D12Context;
import com.sun.prism.d3d12.D3D12Resource;
import com.sun.prism.d3d12.D3D12TextureData;
import com.sun.prism.d3d12.D3D12Utils;
import com.sun.prism.d3d12.ni.D3D12NativeTexture;
import com.sun.prism.impl.BaseTexture;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class D3D12Texture
extends BaseTexture<D3D12Resource<D3D12TextureData>> {
    protected D3D12Context mContext;

    protected D3D12Texture(D3D12Resource<D3D12TextureData> d3D12Resource, D3D12Context d3D12Context, PixelFormat pixelFormat, Texture.WrapMode wrapMode, int n, int n2) {
        super(d3D12Resource, pixelFormat, wrapMode, n, n2);
        this.mContext = d3D12Context;
    }

    private D3D12Texture(D3D12Texture d3D12Texture, Texture.WrapMode wrapMode) {
        super(d3D12Texture, wrapMode, false);
    }

    public static D3D12Texture create(D3D12NativeTexture d3D12NativeTexture, D3D12Context d3D12Context, PixelFormat pixelFormat, Texture.WrapMode wrapMode) {
        return new D3D12Texture(new D3D12Resource<D3D12TextureData>(new D3D12TextureData(d3D12NativeTexture, null, d3D12NativeTexture.getWidth(), d3D12NativeTexture.getHeight(), pixelFormat)), d3D12Context, pixelFormat, wrapMode, d3D12NativeTexture.getWidth(), d3D12NativeTexture.getHeight());
    }

    D3D12NativeTexture getNativeTexture() {
        return ((D3D12TextureData)((D3D12Resource)this.resource).getResource()).getNativeTexture();
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (!((D3D12Resource)this.resource).isValid()) {
            System.err.println("update cancelled, resource not valid");
            return;
        }
        this.checkUpdateParams(buffer, pixelFormat, n, n2, n3, n4, n5, n6, n7);
        if (!bl) {
            this.mContext.flushVertexBuffer();
        }
        int n8 = this.getContentX();
        int n9 = this.getContentY();
        int n10 = this.getContentWidth();
        int n11 = this.getContentHeight();
        int n12 = this.getPhysicalWidth();
        int n13 = this.getPhysicalHeight();
        boolean bl2 = this.mContext.getDevice().updateTexture(this.getNativeTexture(), buffer, pixelFormat, n, n2, n3, n4, n5, n6, n7);
        if (!bl2) {
            new Exception(String.format("D3D12: Texture update failed. Stack trace:", new Object[0])).printStackTrace(System.err);
        }
        switch (this.getWrapMode()) {
            case CLAMP_TO_EDGE: {
                break;
            }
            case REPEAT: {
                break;
            }
            case CLAMP_TO_EDGE_SIMULATED: {
                boolean bl3;
                boolean bl4 = n10 < n12 && n + n5 == n10;
                boolean bl5 = bl3 = n11 < n13 && n2 + n6 == n11;
                if (bl4) {
                    this.mContext.getDevice().updateTexture(this.getNativeTexture(), buffer, pixelFormat, n8 + n10, n9 + n2, n3 + n5 - 1, n4, 1, n6, n7);
                }
                if (!bl3) break;
                this.mContext.getDevice().updateTexture(this.getNativeTexture(), buffer, pixelFormat, n8 + n, n9 + n11, n3, n4 + n6 - 1, n5, 1, n7);
                if (!bl4) break;
                this.mContext.getDevice().updateTexture(this.getNativeTexture(), buffer, pixelFormat, n8 + n10, n9 + n11, n3 + n5 - 1, n4 + n6 - 1, 1, 1, n7);
                break;
            }
            case REPEAT_SIMULATED: {
                boolean bl6;
                boolean bl7 = n10 < n12 && n == 0;
                boolean bl8 = bl6 = n11 < n13 && n2 == 0;
                if (bl7) {
                    this.mContext.getDevice().updateTexture(this.getNativeTexture(), buffer, pixelFormat, n8 + n10, n9 + n2, n3, n4, 1, n6, n7);
                }
                if (!bl6) break;
                this.mContext.getDevice().updateTexture(this.getNativeTexture(), buffer, pixelFormat, n8 + n, n9 + n11, n3, n4, n5, 1, n7);
                if (!bl7) break;
                this.mContext.getDevice().updateTexture(this.getNativeTexture(), buffer, pixelFormat, n8 + n10, n9 + n11, n3, n4, 1, 1, n7);
                break;
            }
        }
    }

    @Override
    public void update(MediaFrame mediaFrame, boolean bl) {
        if (!((D3D12Resource)this.resource).isValid()) {
            System.err.println("update(MediaFrame) cancelled, resource not valid");
            return;
        }
        if (mediaFrame.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Unsupported format " + String.valueOf((Object)mediaFrame.getPixelFormat()));
        }
        try (D3D12Utils.AutoReleasableMediaFrame autoReleasableMediaFrame = new D3D12Utils.AutoReleasableMediaFrame(mediaFrame);){
            PixelFormat pixelFormat;
            boolean bl2;
            ByteBuffer byteBuffer = autoReleasableMediaFrame.get().getBufferForPlane(0);
            if (!bl) {
                this.mContext.flushVertexBuffer();
            }
            if (!(bl2 = (pixelFormat = autoReleasableMediaFrame.get().getPixelFormat()).getDataType() == PixelFormat.DataType.INT ? this.mContext.getDevice().updateTexture(this.getNativeTexture(), byteBuffer.asIntBuffer(), pixelFormat, 0, 0, 0, 0, autoReleasableMediaFrame.get().getEncodedWidth(), autoReleasableMediaFrame.get().getEncodedHeight(), autoReleasableMediaFrame.get().strideForPlane(0)) : this.mContext.getDevice().updateTexture(this.getNativeTexture(), byteBuffer, pixelFormat, 0, 0, 0, 0, autoReleasableMediaFrame.get().getEncodedWidth(), autoReleasableMediaFrame.get().getEncodedHeight(), autoReleasableMediaFrame.get().strideForPlane(0)))) {
                new Exception(String.format("D3D12: Texture update failed. Stack trace:", new Object[0])).printStackTrace(System.err);
            }
        }
    }

    @Override
    protected Texture createSharedTexture(Texture.WrapMode wrapMode) {
        return new D3D12Texture(this, wrapMode);
    }
}

