/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableIntegerProperty
extends IntegerPropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin;
    private TransitionMediatorImpl mediator;

    public StyleableIntegerProperty() {
    }

    public StyleableIntegerProperty(int n) {
        super(n);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        int n;
        Node node;
        Object object = this.getBean();
        TransitionDefinition transitionDefinition = object instanceof Node && !NodeHelper.isInitialCssState(node = (Node)object) ? NodeHelper.findTransitionDefinition(node, this.getCssMetaData()) : null;
        int n2 = n = number != null ? number.intValue() : 0;
        if (transitionDefinition == null) {
            this.set(n);
        } else if (this.mediator == null || this.mediator.endValue != n) {
            this.mediator = new TransitionMediatorImpl(this.get(), n);
            this.mediator.run(transitionDefinition, this.getCssMetaData().getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
        this.origin = styleOrigin;
    }

    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    public void set(int n) {
        super.set(n);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel();
        }
    }

    private final class TransitionMediatorImpl
    extends TransitionMediator {
        private final int startValue;
        private final int endValue;
        private int reversingAdjustedStartValue;

        public TransitionMediatorImpl(int n, int n2) {
            this.startValue = n;
            this.endValue = n2;
            this.reversingAdjustedStartValue = n;
        }

        @Override
        public void onUpdate(double d) {
            StyleableIntegerProperty.super.set(d != 1.0 ? (int)Math.round((double)this.startValue + (double)(this.endValue - this.startValue) * d) : this.endValue);
        }

        @Override
        public void onStop() {
            StyleableIntegerProperty.this.mediator = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableIntegerProperty.this;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionMediatorImpl transitionMediatorImpl = (TransitionMediatorImpl)transitionMediator;
            if (transitionMediatorImpl.reversingAdjustedStartValue == this.endValue) {
                this.reversingAdjustedStartValue = transitionMediatorImpl.endValue;
                return true;
            }
            return false;
        }
    }
}

