/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.util.InterpolationUtils;
import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.beans.NamedArg;
import javafx.geometry.Side;

public final class BackgroundPosition
implements Interpolatable<BackgroundPosition> {
    public static final BackgroundPosition DEFAULT = new BackgroundPosition(Side.LEFT, 0.0, true, Side.TOP, 0.0, true);
    public static final BackgroundPosition CENTER = new BackgroundPosition(Side.LEFT, 0.5, true, Side.TOP, 0.5, true);
    private final Side horizontalSide;
    private final Side verticalSide;
    private final double horizontalPosition;
    private final double verticalPosition;
    private final boolean horizontalAsPercentage;
    private final boolean verticalAsPercentage;
    private final int hash;

    public final Side getHorizontalSide() {
        return this.horizontalSide;
    }

    public final Side getVerticalSide() {
        return this.verticalSide;
    }

    public final double getHorizontalPosition() {
        return this.horizontalPosition;
    }

    public final double getVerticalPosition() {
        return this.verticalPosition;
    }

    public final boolean isHorizontalAsPercentage() {
        return this.horizontalAsPercentage;
    }

    public final boolean isVerticalAsPercentage() {
        return this.verticalAsPercentage;
    }

    public BackgroundPosition(@NamedArg(value="horizontalSide") Side side, @NamedArg(value="horizontalPosition") double d, @NamedArg(value="horizontalAsPercentage") boolean bl, @NamedArg(value="verticalSide") Side side2, @NamedArg(value="verticalPosition") double d2, @NamedArg(value="verticalAsPercentage") boolean bl2) {
        if (side == Side.TOP || side == Side.BOTTOM) {
            throw new IllegalArgumentException("The horizontalSide must be LEFT or RIGHT");
        }
        if (side2 == Side.LEFT || side2 == Side.RIGHT) {
            throw new IllegalArgumentException("The verticalSide must be TOP or BOTTOM");
        }
        this.horizontalSide = side == null ? Side.LEFT : side;
        this.verticalSide = side2 == null ? Side.TOP : side2;
        this.horizontalPosition = d;
        this.verticalPosition = d2;
        this.horizontalAsPercentage = bl;
        this.verticalAsPercentage = bl2;
        int n = this.horizontalSide.hashCode();
        n = 31 * n + this.verticalSide.hashCode();
        long l = this.horizontalPosition != 0.0 ? Double.doubleToLongBits(this.horizontalPosition) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        l = this.verticalPosition != 0.0 ? Double.doubleToLongBits(this.verticalPosition) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.horizontalAsPercentage ? 1 : 0);
        this.hash = n = 31 * n + (this.verticalAsPercentage ? 1 : 0);
    }

    @Override
    public BackgroundPosition interpolate(BackgroundPosition backgroundPosition, double d) {
        Side side;
        boolean bl;
        double d2;
        Side side2;
        boolean bl2;
        double d3;
        Objects.requireNonNull(backgroundPosition, "endValue cannot be null");
        if (d == 0.0) {
            return this;
        }
        if (d == 1.0) {
            return backgroundPosition;
        }
        if (this.horizontalSide == backgroundPosition.horizontalSide && this.horizontalAsPercentage == backgroundPosition.horizontalAsPercentage) {
            d3 = InterpolationUtils.interpolate(this.horizontalPosition, backgroundPosition.horizontalPosition, d);
            bl2 = this.horizontalAsPercentage;
            side2 = this.horizontalSide;
        } else if (d < 0.5) {
            d3 = this.horizontalPosition;
            bl2 = this.horizontalAsPercentage;
            side2 = this.horizontalSide;
        } else {
            d3 = backgroundPosition.horizontalPosition;
            bl2 = backgroundPosition.horizontalAsPercentage;
            side2 = backgroundPosition.horizontalSide;
        }
        if (this.verticalSide == backgroundPosition.verticalSide && this.verticalAsPercentage == backgroundPosition.verticalAsPercentage) {
            d2 = InterpolationUtils.interpolate(this.verticalPosition, backgroundPosition.verticalPosition, d);
            bl = this.verticalAsPercentage;
            side = this.verticalSide;
        } else if (d < 0.5) {
            d2 = this.verticalPosition;
            bl = this.verticalAsPercentage;
            side = this.verticalSide;
        } else {
            d2 = backgroundPosition.verticalPosition;
            bl = backgroundPosition.verticalAsPercentage;
            side = backgroundPosition.verticalSide;
        }
        if (this.isSame(side2, d3, bl2, side, d2, bl)) {
            return this;
        }
        if (backgroundPosition.isSame(side2, d3, bl2, side, d2, bl)) {
            return backgroundPosition;
        }
        return new BackgroundPosition(side2, d3, bl2, side, d2, bl);
    }

    private boolean isSame(Side side, double d, boolean bl, Side side2, double d2, boolean bl2) {
        return this.horizontalSide == side && this.horizontalPosition == d && this.horizontalAsPercentage == bl && this.verticalSide == side2 && this.verticalPosition == d2 && this.verticalAsPercentage == bl2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BackgroundPosition backgroundPosition = (BackgroundPosition)object;
        if (this.hash != backgroundPosition.hash) {
            return false;
        }
        if (this.horizontalAsPercentage != backgroundPosition.horizontalAsPercentage) {
            return false;
        }
        if (Double.compare(backgroundPosition.horizontalPosition, this.horizontalPosition) != 0) {
            return false;
        }
        if (this.verticalAsPercentage != backgroundPosition.verticalAsPercentage) {
            return false;
        }
        if (Double.compare(backgroundPosition.verticalPosition, this.verticalPosition) != 0) {
            return false;
        }
        if (this.horizontalSide != backgroundPosition.horizontalSide) {
            return false;
        }
        return this.verticalSide == backgroundPosition.verticalSide;
    }

    public int hashCode() {
        return this.hash;
    }
}

