/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.MarkerHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jfx.incubator.scene.control.richtext.Marker;
import jfx.incubator.scene.control.richtext.TextPos;

public class Markers {
    private HashMap<TextPos, List<WeakReference<Marker>>> markers = new HashMap();

    public Marker getMarker(TextPos textPos) {
        List<WeakReference<Marker>> list = this.markers.get(textPos);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                WeakReference<Marker> weakReference = list.get(i);
                Marker marker = (Marker)weakReference.get();
                if (marker == null) continue;
                return marker;
            }
        }
        Marker marker = MarkerHelper.createMarker(textPos);
        if (list == null) {
            list = new ArrayList<WeakReference<Marker>>(2);
        }
        list.add(new WeakReference<Marker>(marker));
        this.markers.put(textPos, list);
        return marker;
    }

    public String toString() {
        ArrayList<TextPos> arrayList = new ArrayList<TextPos>(this.markers.keySet());
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        boolean bl = false;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            TextPos textPos = arrayList.get(i);
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append('{');
            stringBuilder.append(textPos.index());
            stringBuilder.append(',');
            stringBuilder.append(textPos.offset());
            stringBuilder.append('}');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void update(TextPos textPos, TextPos textPos2, int n, int n2, int n3) {
        Object object;
        if (textPos.compareTo(textPos2) > 0) {
            object = textPos;
            textPos = textPos2;
            textPos2 = object;
        }
        object = new HashMap(this.markers.size());
        for (TextPos textPos3 : this.markers.keySet()) {
            int n4;
            TextPos textPos4;
            List<WeakReference<Marker>> list = this.markers.get(textPos3);
            if (textPos3.compareTo(textPos) <= 0) {
                textPos4 = textPos3;
            } else if (textPos3.compareTo(textPos2) < 0) {
                textPos4 = textPos;
            } else {
                n4 = textPos3.index();
                int n5 = n4 == textPos2.index() ? (n2 == 0 && textPos.index() == textPos2.index() ? textPos3.offset() - (textPos2.offset() - textPos.offset()) + n + n3 : textPos3.offset() - textPos2.offset() + n3) : textPos3.offset();
                textPos4 = TextPos.ofLeading(n4 += n2 - textPos2.index() + textPos.index(), n5);
            }
            for (n4 = list.size() - 1; n4 >= 0; --n4) {
                Marker marker = (Marker)list.get(n4).get();
                if (marker == null) {
                    list.remove(n4);
                    continue;
                }
                MarkerHelper.setMarkerPos(marker, textPos4);
            }
            if (list.size() <= 0) continue;
            ((HashMap)object).put(textPos4, list);
        }
        this.markers = object;
    }
}

