/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.prism.RenderTarget;
import com.sun.prism.impl.ps.BaseShaderGraphics;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLLog;
import com.sun.prism.paint.Color;

public class MTLGraphics
extends BaseShaderGraphics {
    private final MTLContext context;

    private MTLGraphics(MTLContext mTLContext, RenderTarget renderTarget) {
        super(mTLContext, renderTarget);
        this.context = mTLContext;
        MTLLog.Debug("MTLGraphics(): context = " + String.valueOf(mTLContext) + ", target = " + String.valueOf(renderTarget));
    }

    static MTLGraphics create(MTLContext mTLContext, RenderTarget renderTarget) {
        if (renderTarget == null) {
            return null;
        }
        MTLLog.Debug("MTLGraphics.create(): context = " + String.valueOf(mTLContext) + ", target = " + String.valueOf(renderTarget));
        return new MTLGraphics(mTLContext, renderTarget);
    }

    @Override
    public void clear(Color color) {
        MTLLog.Debug("MTLGraphics.clear(): color = " + String.valueOf(color));
        float f = color.getRedPremult();
        float f2 = color.getGreenPremult();
        float f3 = color.getBluePremult();
        float f4 = color.getAlpha();
        MTLLog.Debug("MTLGraphics.clear(): r = " + f + ", g = " + f2 + ", b = " + f3 + ", a = " + f4);
        this.context.validateClearOp(this);
        this.getRenderTarget().setOpaque(color.isOpaque());
        int n = MTLGraphics.nClear(this.context.getContextHandle(), f, f2, f3, f4, this.isDepthBuffer());
    }

    @Override
    public void sync() {
        this.context.flushVertexBuffer();
        this.context.commitCurrentCommandBuffer();
    }

    private static native int nClear(long var0, float var2, float var3, float var4, float var5, boolean var6);
}

