/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.prism.Graphics;
import com.sun.prism.Material;
import com.sun.prism.impl.BaseMeshView;
import com.sun.prism.impl.Disposer;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLMesh;
import com.sun.prism.mtl.MTLPhongMaterial;

class MTLMeshView
extends BaseMeshView {
    static int count = 0;
    private final MTLContext context;
    private final long nativeHandle;
    private final MTLMesh mesh;
    private MTLPhongMaterial material;

    private MTLMeshView(MTLContext mTLContext, long l, MTLMesh mTLMesh, Disposer.Record record) {
        super(record);
        this.context = mTLContext;
        this.mesh = mTLMesh;
        this.nativeHandle = l;
        ++count;
    }

    static MTLMeshView create(MTLContext mTLContext, MTLMesh mTLMesh) {
        long l = mTLContext.createMTLMeshView(mTLMesh.getNativeHandle());
        return new MTLMeshView(mTLContext, l, mTLMesh, new MTLMeshViewDisposerRecord(mTLContext, l));
    }

    @Override
    public void setCullingMode(int n) {
        this.context.setCullingMode(this.nativeHandle, n);
    }

    @Override
    public void setMaterial(Material material) {
        this.context.setMaterial(this.nativeHandle, ((MTLPhongMaterial)material).getNativeHandle());
        this.material = (MTLPhongMaterial)material;
    }

    @Override
    public void setWireframe(boolean bl) {
        this.context.setWireframe(this.nativeHandle, bl);
    }

    @Override
    public void setAmbientLight(float f, float f2, float f3) {
        this.context.setAmbientLight(this.nativeHandle, f, f2, f3);
    }

    @Override
    public void setLight(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18) {
        if (n >= 0 && n <= 2) {
            this.context.setLight(this.nativeHandle, n, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18);
        }
    }

    @Override
    public void render(Graphics graphics) {
        this.material.lockTextureMaps();
        this.context.renderMeshView(this.nativeHandle, graphics);
        this.material.unlockTextureMaps();
    }

    @Override
    public boolean isValid() {
        return !this.context.isDisposed();
    }

    @Override
    public void dispose() {
        this.material = null;
        this.disposerRecord.dispose();
        --count;
    }

    public int getCount() {
        return count;
    }

    static class MTLMeshViewDisposerRecord
    implements Disposer.Record {
        private final MTLContext context;
        private long nativeHandle;

        MTLMeshViewDisposerRecord(MTLContext mTLContext, long l) {
            this.context = mTLContext;
            this.nativeHandle = l;
        }

        void traceDispose() {
        }

        @Override
        public void dispose() {
            if (this.nativeHandle != 0L) {
                this.traceDispose();
                this.context.releaseMTLMeshView(this.nativeHandle);
                this.nativeHandle = 0L;
            }
        }
    }
}

